---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, concepts, formats, Adobe
---

# Que sont les formats de fonte Adobe ?

[L'entreprise Adobe](wpfr:Adobe_(entreprise)) a spécifié un certain nombre de formats de fichiers 
pour représenter les polices dans les fichiers PostScript.
Cette question ne se voulant pas encyclopédique, nous n'abordons que les deux formats 
les plus couramment rencontrés dans le contexte de (La)TeX, les types 1 et 3. 
En particulier, nous n'abordons pas le format [OpenType](wpfr:OpenType), 
dont les nombreux avantages sont désormais accessibles à la plupart des utilisateurs de (La)TeX 
par le biais de [XeTeX](/1_generalites/glossaire/xetex) 
et de [LuaTeX](/1_generalites/glossaire/luatex).

Le format Adobe Type 1 spécifie un moyen de représenter les contours des glyphes d'une police. 
Le "langage" utilisé est volontairement limité, 
afin de garantir que la police soit rendue aussi rapidement que possible (ou, plus exactement,
aussi rapidement que le permettait la technologie d'Adobe au moment où la spécification a été rédigée ;
 la structure pourrait être bien différente si elle était spécifiée aujourd'hui). 
 Ce format a longtemps été la base de l'activité des fonderies de caractères numériques, 
 bien qu'aujourd'hui la plupart des nouvelles polices soient publiées au format OpenType.

Dans le contexte de (La)TeX, les polices de type 1 sont extrêmement importantes. 
Outre la disponibilité de ce format (il existe des milliers de polices de texte Type 1 commerciales), 
les lecteurs de fichiers PDF les plus courants ont depuis longtemps *insisté* sur l'utilisation
de celui-ci (voir ci-dessous).

Les polices de type 3 ont une spécification plus souple. 
Une large gamme d'opérateurs PostScript est autorisée, y compris les spécificateurs bitmap. 
Le Type 3 est donc le format naturel à utiliser pour des programmes tels que `dvips` 
lorsqu'ils vont représenter automatiquement les polices générées par MetaFont dans un fichier PostScript. 
C'est d'ailleurs le traitement par Adobe Acrobat Viewer des polices bitmap de type 3 
qui a rendu la sortie directe de MetaFont de moins en moins attrayante ces dernières années. 
Si vous avez un document PDF dans lequel le texte semble flou ou de qualité inégale dans Acrobat Reader, 
consultez dans Reader le menu `Fichier` → `Propriétés du document` → `Fontes ...`, 
et il affichera probablement une police ou une autre comme étant de "Type 3" 
(généralement avec l'encodage "Custom"). 
Le problème a disparu avec la version 6 d'Acrobat Reader. 
Vous pouvez également consulter la question 
"[](/5_fichiers/formats/pdf/generer_un_fichier_pdf_de_qualite)" sur ce sujet.

Les polices de type 3 ne doivent cependant pas être entièrement rejetées. 
L'échec d'Acrobat Reader avec ces polices est entièrement dû au fait 
qu'il n'utilise pas les techniques d'anticrénelage courantes dans les logiciels TeX. 
Choisissez un ensemble différent d'opérateurs graphiques PostScript 
et vous pourrez créer des polices de type 3 agréables qui n'ennuieront pas Acrobat Reader. 
Par exemple, vous ne pouvez pas changer la couleur d'un glyphe d'une police de type 1, 
mais il n'y a pas de restriction de ce type pour une police de type 3, 
ce qui permet d'obtenir des effets surprenants.

:::{todo} Ajouter une page Opentype ?
:::

:::{sources}
[Adobe font formats](faquk:FAQ-adobetypen)
:::