---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, équations, 
              numérotation des équations, numérotation, référence, \label, \ref
---

# Comment changer le style de numérotation des équations ?

Pour modifier le style de numérotation, on peut redéfinir la commande 
`\theequation`. L'exemple qui suit numérote les équations 
avec des lettres majuscules :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \renewcommand{\theequation}{\thesection \Alph{equation}}

\begin{document}
\section{Systèmes à une variable}
\begin{align}
  x + 4 & = 0 \\
  x & = 3
\end{align}

\section{Systèmes à deux variables}
\begin{align}
  x + 4 & = 0 \\
  8 - y & = 0
\end{align}
\end{document}
```

Ce second exemple permet de placer la numérotation entre crochets :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \makeatletter
  \renewcommand{\@eqnnum}{{\normalfont\normalcolor \theequation}}
  \renewcommand{\theequation}{[\arabic{equation}]}
  \makeatother

\begin{document}
Voici un exemple de numérotation
placée entre crochets :
\begin{equation}
  y - 2 = 0
\end{equation}
\end{document}
```