---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, erreur
---

# Pourquoi mes caractères n'apparaissent pas ?

Vous avez tapé du texte apparemment classique et vous l'avez compilé. 
Le cas le plus fréquent d'erreur concernant des caractères est :

```text
! Package inputenc Error : Unicode character (...)
(inputenc) not set up for use with LaTeX.
See the inputenc package documentation for explanation.
```

Vous avez utilisé des caractères qui posent problème à l'extension <ctanpkg:inputenc>.

Mais ce n'est pas systématique : parfois, aucune erreur ne stoppe la compilation 
mais le résultat ne contient pas certains des caractères que vous avez tapés. 
Une raison probable est que la fonte que vous avez sélectionnée 
n'a tout simplement pas de représentation pour les caractères en question. 
L'exemple suivant illustre le cas :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{calligra}

\begin{document}
\calligra Au programme~: Neuvième symphonie d'Antonín Dvořák
\end{document}
```

Avez-vous remarqué la lettre manquante ?
La fonte *Calligra*, fournie par l'extension <ctanpkg:fundus-calligra>,
ne définit pas le glyphe `ř`. Il n'y a pas ici de réel message d'erreur :
vous devez lire le fichier journal ou la sortie sur le terminal,
et vous y trouverez des avertissements confirmant ce point. Avec LuaLaTeX :

```text
Missing character: There is no ř (U+0159) in font callig15!
```

Et avec pdfLaTeX, un message un rien plus mystérieux :

```text
Missing character: There is no ° in font callig15!
```

Il faut donc charger une autre fonte, ou 
[tenter quelques bricolages si le problème est lié à des diacritiques](/3_composition/texte/symboles/polices/ajuster_diacritiques).

Vous pouvez aussi recevoir des messages similaires de <ctanpkg:dvips> 
lorsque vous utilisez les versions OT1 et T1 des polices fournies dans l'encodage standard d'Adobe :

```text
dvips: Warning: missing glyph `Delta'
```

Le processus qui génère les métriques pour l'utilisation des fontes 
donne aussi une instruction à <ctanpkg:dvips> pour produire ces messages, 
de sorte que leur non-apparition dans la sortie imprimée est moins surprenante. 
De nombreux glyphes fournis dans les encodages classiques, celui de Cork en particulier, 
ne sont pas disponibles dans les polices Adobe. Dans ces cas, 
le programme `dvips` produit un rectangle noir de la taille spécifiée par le fichier de police.

:::{sources}
[Where have my characters gone?](faquk:FAQ-misschar)
:::
