---
myst:
  html_meta:
    keywords: LaTeX, programmation, commandes, macros, \newcommand*, commandes courtes, commandes longues, commande courte, commande longue
---
# Que fait `\newcommand*` ?

Voici une astuce qui ne changera rien à vos documents, mais rendra votre code plus robuste en vous permettant de localiser les erreurs plus facilement. Une des erreurs les plus courantes en tapant un document LaTeX est de mal équilibrer les accolades : en particulier d'oublier l'accolade fermante à la fin de l'argument d'une commande.

Dans un cas pareil, si rien n'est prévu, TeX lira votre fichier jusqu'à la fin avant de comprendre qu'il y a un problème et qu'il ne pourra rien faire. Pour éviter cela, il est possible de distinguer deux types de commandes, les *longues* et les *courtes*, selon que leurs arguments peuvent ou non contenir un changement de paragraphe. Par défaut, `\newcommand` définit des commandes longues.

En utilisant `\newcommand*` pour définir votre commande, vous en faites une commande courte, ce qui est largement préférable dans la plupart des cas : ainsi, les erreurs dues à un éventuel oubli d'accolade fermante seront circonscrites à un paragraphe. En cas de problème, TeX s'en rendra compte à la fin du paragraphe (et non du document), il pourra vous signaler facilement l'emplacement de l'erreur et composer le reste du document comme si de rien n'était.

Prenez donc l'habitude d'utiliser la plupart du temps les versions étoilés de `\newcommand` et `\renewcommand` (sauf bien sûr dans des cas particuliers), cela vous épargnera quelques désagréments.

:::{sources}
[Étoiler ses `\newcommand`](https://www.elzevir.fr/imj/latex/tips.html#ncstared), par Manuel Pégourié-Gonnard
:::
