---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              espacement vertical, espacement horizontal, espace extensible,
              espace compressible
---

# Que signifie l'erreur : "Infinite glue shrinkage found ⟨quelque part⟩" ?

- **Message** : `Infinite glue shrinkage found ⟨quelque part⟩`
- **Origine** : TeX

Pour couper un paragraphe en lignes ou la réserve en pages, TeX suppose 
qu'il n'y a pas de longueur élastique pouvant se compresser arbitrairement
puisque cela signifierait que n'importe quelle quantité de matériel pourrait 
loger dans une seule page. 

Ainsi, il n'est pas permis d'écrire `\hspace{0pt minus 1fil}` 
dans un paragraphe ou `\vspace{0pt minus 1fil}` entre deux paragraphes. 
Le faire provoque cette erreur `⟨quelque part⟩`, ce qui indique l'emplacement
approximatif où le matériel interdit a été trouvé.


:::{sources}
- [FAQ erreurs - Lettre I](https://latex.developpez.com/faq/erreurs?page=I), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::