---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              police non trouvée, fonte non trouvée, charger une fonte, 
              charger une police, fichiers de métrique, fichiers TFM
---

# Que signifie l'erreur : "Font ⟨nom-interne⟩ = ⟨nom-externe⟩ not loadable : ⟨raison⟩" ?

- **Message** : `Font ⟨nom-interne⟩ = ⟨nom-externe⟩ not loadable : ⟨raison⟩`
- **Origine** : TeX

TeX est incapable de charger une fonte avec le nom LaTeX `⟨nom-interne⟩` 
ayant la structure suivante en notation NFSS [^footnote-1] 

:::{noedit}
`\⟨codage⟩/⟨famille⟩/⟨graisse⟩/⟨forme⟩/⟨taille⟩` 
:::

Il s'agit en fait d'un nom de commande unique mais, en raison 
des barres obliques dans ce nom, vous ne pouvez pas le spécifier 
directement dans le document.

Par exemple, il peut s'agir de `\T1/cmr/m/it/10`
(*Computer Modern* medium italique, 10 points, au codage T1). Cela donne 
une information intéressante pour savoir sur quelle fonte porte l'erreur, 
même si vous ne pouvez pas en faire grand chose. Selon la `⟨raison⟩` donnée
dans le message, l'action à mener n'est pas la même.


## "Bad metric (TFM) file"

Le fichier de métrique TeX de la fonte (c'est-à-dire TFM) est corrompu. 
L'installation peut disposer de quelques programmes utilitaires permettant 
de vérifier les fichiers TFM en détail, même si cela exige habituellement 
l'aide d'un expert.


## "Metric (TFM) file not found"

Le fichier de métrique TeX de la fonte (c'est-à-dire TFM) n'a pas été trouvé.
L'installation peut disposer d'une extension (par exemple, <ctanpkg:cmbright>)
comme support d'une certaine famille de fontes, mais les fontes correspondantes
ne sont pas disponibles ou pas correctement installées.


:::{sources}
- [FAQ erreurs - Lettre F](https://latex.developpez.com/faq/erreurs?page=F), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::


[^footnote-1]: **NFSS** signifie *new font selection scheme*.