/*
 * tex2ucs.h
 * Copyright (C) 2012-2016 TANAKA Takui <ttk@t-lab.opal.ne.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/* replacement character U+FFFD */
#define RPLCHR  0xFFFD

static const unsigned short ot1_to_ucs[] = {
 0x0393, 0x0394, 0x0398, 0x039B, 0x039E, 0x03A0, 0x03A3, 0x03A5,
 0x03A6, 0x03A8, 0x03A9, 0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04,
 0x0131, 0x0237, 0x0060, 0x00B4, 0x02C7, 0x02D8, 0x00AF, 0x02DA,
 0x00B8, 0x00DF, 0x00E6, 0x0153, 0x00F8, 0x00C6, 0x0152, 0x00D8,
 RPLCHR, 0x0021, 0x201D, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x00A1, 0x003D, 0x00BF, 0x003F,
 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x0058, 0x0059, 0x005A, 0x005B, 0x201C, 0x005D, 0x005E, 0x02D9,
 0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
 0x0078, 0x0079, 0x007A, 0x2013, 0x2014, 0x02DD, 0x02DC, 0x00A8,
};


static const unsigned short oml_to_ucs[] = {
 0x0393, 0x0394, 0x0398, 0x039B, 0x039E, 0x03A0, 0x03A3, 0x03A5,
 0x03A6, 0x03A8, 0x03A9, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5,
 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD,
 0x03BE, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03D5, 0x03C7,
 0x03C8, 0x03C9, 0x03B5, 0x03D1, 0x03D6, 0x03F1, 0x03C2, 0x03C6,
 0x21BC, 0x21BD, 0x21C0, 0x21C1, RPLCHR, RPLCHR, 0x25B7, 0x25C1,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x002E, 0x002C, 0x003C, 0x2215, 0x003E, 0x22C6,
 0x2202, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x0058, 0x0059, 0x005A, 0x266D, 0x266E, 0x266F, 0x23DC, 0x23DD,
 0x2113, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
 0x0078, 0x0079, 0x007A, 0x0131, 0x0237, 0x2118, RPLCHR, RPLCHR,
};


static const unsigned short oms_to_ucs[] = {
 0x2212, 0x2215, 0x00D7, 0x2217, 0x00F7, 0x22C4, 0x00B1, 0x2213,
 0x2295, 0x2296, 0x2297, 0x2298, 0x2299, 0x25EF, 0x2218, 0x2219,
 0x224D, 0x2261, 0x2286, 0x2287, 0x2264, 0x2265, 0x2AAF, 0x2AB0,
 0x223C, 0x2248, 0x2282, 0x2283, 0x226A, 0x226B, 0x227A, 0x227B,
 0x2190, 0x2191, 0x2192, 0x2193, 0x2194, 0x2197, 0x2198, 0x2243,
 0x21D0, 0x21D1, 0x21D2, 0x21D3, 0x21D4, 0x2196, 0x2199, 0x221D,
 0x2032, 0x221E, 0x2208, 0x220B, 0x25B3, 0x25BD, RPLCHR, RPLCHR,
 0x2200, 0x2203, 0x00AC, 0x2205, 0x211C, 0x2111, 0x22A4, 0x22A5,
 0x2135, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x0058, 0x0059, 0x005A, 0x222A, 0x2229, 0x228E, 0x22C0, 0x22C1,
 0x22A2, 0x22A3, 0x23A3, 0x23A6, 0x23A1, 0x23A4, 0x007B, 0x007D,
 0x27E8, 0x27E9, 0x007C, 0x2016, 0x2195, 0x21D5, 0x2216, 0x2240,
 0x221A, 0x2210, 0x2207, 0x222B, 0x2294, 0x2293, 0x2291, 0x2292,
 0x00A7, 0x2020, 0x2021, 0x00B6, 0x2663, 0x2662, 0x2661, 0x2660,
};


static const unsigned short tt_to_ucs[] = {
 0x0393, 0x0394, 0x0398, 0x039B, 0x039E, 0x03A0, 0x03A3, 0x03A5,
 0x03A6, 0x03A8, 0x03A9, 0x2191, 0x2193, 0x0027, 0x00A1, 0x00BF,
 0x0131, 0x0237, 0x0060, 0x00B4, 0x02C7, 0x02D8, 0x00AF, 0x02DA,
 0x00B8, 0x00DF, 0x00E6, 0x0153, 0x00F8, 0x00C6, 0x0152, 0x00D8,
 0x2423, 0x0021, 0x201D, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
 0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x02DC, 0x00A8,
};


static const unsigned short ot2_to_ucs[] = {
 0x040A, 0x0409, 0x040F, 0x042D, 0x0406, 0x0404, 0x0402, 0x040B,
 0x045A, 0x0459, 0x045F, 0x044D, 0x0456, 0x0454, 0x0452, 0x045B,
 0x042E, 0x0416, 0x0419, 0x0401, 0x0474, 0x0472, 0x0405, 0x042F,
 0x044E, 0x0436, 0x0439, 0x0451, 0x0475, 0x0473, 0x0455, 0x044F,
 0x00A8, 0x0021, 0x201D, 0x0462, 0x02D8, 0x0025, 0x00B4, 0x2019,
 0x0028, 0x0029, 0x002A, 0x0463, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x00AB, 0x0131, 0x00BB, 0x003F,
 0x02D8, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413,
 0x0425, 0x0418, 0x0408, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E,
 0x041F, 0x0427, 0x0420, 0x0421, 0x0422, 0x0423, 0x0412, 0x0429,
 0x0428, 0x042B, 0x0417, 0x005B, 0x201C, 0x005D, 0x042C, 0x042A,
 0x2018, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433,
 0x0445, 0x0438, 0x0458, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E,
 0x043F, 0x0447, 0x0440, 0x0441, 0x0442, 0x0443, 0x0432, 0x0449,
 0x0448, 0x044B, 0x0437, 0x2013, 0x2014, 0x2116, 0x044C, 0x044A,
};


static const unsigned short t1_to_ucs[] = {
 0x0060, 0x00B4, 0x005E, 0x02DC, 0x00A8, 0x02DD, 0x02DA, 0x02C7,
 0x02D8, 0x00AF, 0x02D9, 0x00B8, 0x02DB, 0x201A, 0x2039, 0x203A,
 0x201C, 0x201D, 0x201E, 0x00AB, 0x00BB, 0x2013, 0x2014, 0x200C,
 RPLCHR, 0x0131, 0x0237, 0xFB00, 0xFB01, 0xFB02, 0xFB03, 0xFB04,
 0x2423, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
 0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x02DC, 0x2010,
 0x0102, 0x0104, 0x0106, 0x010C, 0x010E, 0x011A, 0x0118, 0x011E,
 0x0139, 0x013D, 0x0141, 0x0143, 0x0147, 0x014A, 0x0150, 0x0154,
 0x0158, 0x015A, 0x0160, 0x015E, 0x0164, 0x0162, 0x0170, 0x016E,
 0x0178, 0x0179, 0x017D, 0x017B, 0x0132, 0x0130, 0x0111, 0x00A7,
 0x0103, 0x0105, 0x0107, 0x010D, 0x010F, 0x011B, 0x0119, 0x011F,
 0x013A, 0x013E, 0x0142, 0x0144, 0x0148, 0x014B, 0x0151, 0x0155,
 0x0159, 0x015B, 0x0161, 0x015F, 0x0165, 0x0163, 0x0171, 0x016F,
 0x00FF, 0x017A, 0x017E, 0x017C, 0x0133, 0x00A1, 0x00BF, 0x00A3,
 0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x0152,
 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE,      0,
 0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
 0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
 0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x0153,
 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00DF,
};


static const unsigned short ts1_to_ucs[] = {
 0x0060, 0x00B4, 0x005E, 0x02DC, 0x00A8, 0x02DD, 0x02DA, 0x02C7,
 0x02D8, 0x00AF, 0x02D9, 0x00B8, 0x02DB, 0x201A,      0,      0,
      0,      0, 0x201E,      0,      0, 0x2013, 0x2014, 0x200C,
 0x2190, 0x2192, RPLCHR, RPLCHR, RPLCHR, RPLCHR,      0, 0x200C,
 0x2422,      0,      0,      0, 0x0024,      0,      0, 0x2019,
      0,      0, 0x204E,      0, 0x002C, 0x30A0, 0x002E, 0x2044,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039,      0,      0, 0x2329, 0x2212, 0x232A,      0,
      0,      0,      0,      0,      0,      0,      0,      0,
      0,      0,      0,      0,      0, 0x2127,      0, 0x25EF,
      0, RPLCHR,      0,      0,      0,      0,      0, 0x2126,
      0,      0,      0, 0x27E6,      0, 0x27E7, 0x2191, 0x2193,
 0x0060,      0, 0x002A, 0x26AE, 0x002B,      0,      0,      0,
      0,      0,      0,      0, RPLCHR, 0x26AD, 0x266A,      0,
      0, RPLCHR,      0, 0x017F,      0,      0,      0,      0,
      0,      0,      0,      0,      0,      0, 0x007E, 0x30A0,
 0x02D8, 0x02C7, 0x02DD, RPLCHR, 0x2020, 0x2021, 0x2016, 0x2030,
 0x2022, 0x2103, 0x0024, 0x00A2, 0x0192, 0x20A1, 0x20A9, 0x20A6,
 0x20B2, 0x20B1, 0x20A4, 0x211E, 0x203D, 0x2E18, 0x20AB, 0x2122,
 0x2031, 0x00B6, 0x0E3F, 0x2116, 0x2052, 0x212E, 0x25E6, 0x2120,
 0x2045, 0x2046, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
 0x00A8, 0x00A9, 0x00AA, RPLCHR, 0x00AC, 0x2117, 0x00AE, 0x00AF,
 0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
 0x203B, 0x00B9, 0x00BA, 0x221A, 0x00BC, 0x00BD, 0x00BE, 0x20AC,
      0,      0,      0,      0,      0,      0,      0,      0,
      0,      0,      0,      0,      0,      0,      0,      0,
      0,      0,      0,      0,      0,      0, 0x00D7,      0,
      0,      0,      0,      0,      0,      0,      0,      0,
      0,      0,      0,      0,      0,      0,      0,      0,
      0,      0,      0,      0,      0,      0,      0,      0,
      0,      0,      0,      0,      0,      0, 0x00F7,      0,
      0,      0,      0,      0,      0,      0,      0,      0,
};


static const unsigned short t2a_to_ucs[] = {
 0x0060, 0x00B4, 0x005E, 0x02DC, 0x00A8, 0x02DD, 0x02DA, 0x02C7,
 0x02D8, 0x00AF, 0x02D9, 0x00B8, 0x02DB, 0x04C0, 0x2329, 0x232A,
 0x201C, 0x201D, RPLCHR, RPLCHR, 0x02D8, 0x2013, 0x2014, 0x200C,
 RPLCHR, 0x0131, 0x0237, 0XFB00, 0XFB01, 0XFB02, 0XFB03, 0XFB04,
 0x2423, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0406, 0x0408, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x051A, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x051C,
 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
 0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0456, 0x0458, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x051B, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x051D,
 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x02DC, 0x2010,
 0x0490, 0x0492, 0x0402, 0x040B, 0x04BA, 0x0496, 0x0498, 0x0409,
 0x0407, 0x049A, 0x04A0, 0x049C, 0x04D4, 0x04A2, 0x04A4, 0x0405,
 0x04E8, 0x04AA, 0x040E, 0x04AE, 0x04B0, 0x04B2, 0x040F, 0x04B8,
 0x04B6, 0x0404, 0x04D8, 0x040A, 0x0401, 0x2116, 0x00A4, 0x00A7,
 0x0491, 0x0493, 0x0452, 0x045B, 0x04BB, 0x0497, 0x0499, 0x0459,
 0x0457, 0x049B, 0x04A1, 0x049D, 0x04D5, 0x04A3, 0x04A5, 0x0455,
 0x04E9, 0x04AB, 0x045E, 0x04AF, 0x04B1, 0x04B3, 0x045F, 0x04B9,
 0x04B7, 0x0454, 0x04D9, 0x045A, 0x0451, 0x201E, 0x00AB, 0x00BB,
 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
};


static const unsigned short t2b_to_ucs[] = {
 0x0060, 0x00B4, 0x005E, 0x02DC, 0x00A8, 0x02DD, 0x02DA, 0x02C7,
 0x02D8, 0x00AF, 0x02D9, 0x00B8, 0x02DB, 0x04C0, 0x2329, 0x232A,
 0x201C, 0x201D, RPLCHR, RPLCHR, 0x02D8, 0x2013, 0x2014, 0x200C,
 RPLCHR, 0x0131, 0x0237, 0XFB00, 0XFB01, 0XFB02, 0XFB03, 0XFB04,
 0x2423, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0406, 0x0408, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x051A, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x051C,
 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
 0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0456, 0x0458, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x051B, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x051D,
 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x02DC, 0x2010,
 0x04FA, 0x0492, 0x04F6, 0x0494, 0x04BA, 0x0496, RPLCHR, 0x04E0,
 0x0409, 0x049A, 0x04C5, 0x04C3, 0x0512, 0x04A2, 0x04A4, 0x04C7,
 0x04E8, RPLCHR, 0x040E, 0x04AE, 0x04FE, 0x04B2, 0x04FC, 0x04CB,
 0x04B6, 0x040A, 0x04D8, 0x0510, 0x0401, 0x2116, 0x00A4, 0x00A7,
 0x04FB, 0x0493, 0x04F7, 0x0495, 0x04BB, 0x0497, RPLCHR, 0x04E1,
 0x0459, 0x049B, 0x04C6, 0x04C4, 0x0513, 0x04A3, 0x04A5, 0x04C8,
 0x04E9, RPLCHR, 0x045E, 0x04AF, 0x04FF, 0x04B3, 0x04FD, 0x04CC,
 0x04B7, 0x045A, 0x04D9, 0x0511, 0x0451, 0x201E, 0x00AB, 0x00BB,
 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
};


static const unsigned short t2c_to_ucs[] = {
 0x0060, 0x00B4, 0x005E, 0x02DC, 0x00A8, 0x02DD, 0x02DA, 0x02C7,
 0x02D8, 0x00AF, 0x02D9, 0x00B8, 0x02DB, 0x04C0, 0x2329, 0x232A,
 0x201C, 0x201D, RPLCHR, RPLCHR, 0x02D8, 0x2013, 0x2014, 0x200C,
 RPLCHR, 0x0131, 0x0237, 0XFB00, 0XFB01, 0XFB02, 0XFB03, 0XFB04,
 0x2423, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
 0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
 0x0048, 0x0406, 0x0408, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
 0x0050, 0x051A, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x051C,
 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
 0x2018, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
 0x0068, 0x0456, 0x0458, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
 0x0070, 0x051B, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x051D,
 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x02DC, 0x2010,
 0x04A6, 0x04B4, 0x04AC, 0x0494, 0x04BA, RPLCHR, 0x048E, 0x04E0,
 0x04CD, 0x049A, 0x04C5, 0x049E, 0x0512, 0x04A2, 0x04CD, 0x04C7,
 0x04E8, 0x04BC, 0x04BE, 0x048C, 0x048A, 0x04B2, 0x040F, 0x04A8,
 0x04B6, RPLCHR, 0x04D8, RPLCHR, 0x0401, 0x2116, 0x00A4, 0x00A7,
 0x04A7, 0x04B5, 0x04AD, 0x0495, 0x04BB, RPLCHR, 0x048F, 0x04E1,
 0x04CE, 0x049B, 0x04C6, 0x049F, 0x0513, 0x04A3, 0x04CE, 0x04C8,
 0x04E9, 0x04BD, 0x04BF, 0x048D, 0x048B, 0x04B3, 0x045F, 0x04A9,
 0x04B7, RPLCHR, 0x04D9, RPLCHR, 0x0451, 0x201E, 0x00AB, 0x00BB,
 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
};


static const unsigned short x2_to_ucs[] = {
 0x0060, 0x00B4, 0x005E, 0x02DC, 0x00A8, 0x02DD, 0x02DA, 0x02C7,
 0x02D8, 0x00AF, 0x02D9, 0x00B8, 0x02DB, 0x04C0, 0x2329, 0x232A,
 0x201C, 0x201D, RPLCHR, RPLCHR, 0x02D8, 0x2013, 0x2014, 0x200C,
 RPLCHR, RPLCHR, RPLCHR, RPLCHR, RPLCHR, RPLCHR, RPLCHR, RPLCHR,
 0x2423, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x2019,
 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
 0x0040, 0x04D4, 0x0402, 0x040B, 0x04BC, 0x04BE, 0x049C, 0x049E,
 0x04C5, 0x0406, 0x0408, 0x0409, 0x04CD, 0x040A, 0x04A8, 0x04A6,
 RPLCHR, 0x051A, 0x04AC, 0x0405, 0x04B4, 0x040F, 0x04B8, 0x051C,
 0x0462, 0x046A, 0x0474, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
 0x2018, 0x04D5, 0x0452, 0x045B, 0x04BD, 0x04BF, 0x049D, 0x049F,
 0x04C6, 0x0456, 0x0458, 0x0459, 0x04CE, 0x045A, 0x04A9, 0x04A7,
 RPLCHR, 0x051B, 0x04AD, 0x0455, 0x04B5, 0x045F, 0x04B9, 0x051D,
 0x0463, 0x046B, 0x0475, 0x007B, 0x007C, 0x007D, 0x02DC, 0x2010,
 0x0490, 0x0492, 0x04F6, 0x0494, 0x04BA, 0x0496, 0x0498, 0x04E0,
 0x0407, 0x049A, 0x04A0, 0x04C3, 0x0512, 0x04A2, 0x04A4, 0x04C7,
 0x04E8, 0x04AA, 0x040E, 0x04AE, 0x04B0, 0x04B2, 0x04FC, 0x04CB,
 0x04B6, 0x0404, 0x04D8, 0x0510, 0x0401, 0x2116, 0x00A4, 0x00A7,
 0x0491, 0x0493, 0x04F7, 0x0495, 0x04BB, 0x0497, 0x0499, 0x04E1,
 0x0457, 0x049B, 0x04A1, 0x04C4, 0x0513, 0x04A3, 0x04A5, 0x04C8,
 0x04E9, 0x04AB, 0x045E, 0x04AF, 0x04B1, 0x04B3, 0x04FD, 0x04CC,
 0x04B7, 0x0454, 0x04D9, 0x0511, 0x0451, 0x201E, 0x00AB, 0x00BB,
 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
};

