/*
 * JTester.java - Test application for the library, wrapper for all demos
 *
 * Copyright (c) 2004-2011 Gregory Kotsaftis
 * gregkotsaftis@yahoo.com
 * http://zeus-jscl.sourceforge.net/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package gr.zeus.tests;

import gr.zeus.ui.SingleAppInstance;
import gr.zeus.util.SimpleTimerMillis;
import gr.zeus.util.SimpleTimerNanos;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

public class JTester extends JFrame {

    // allow only one instance of this program (tester for SingleAppInstance)
    // very simple to use: execute onInit() just after program execution and
    // onExit() just before program exiting.
    private static SingleAppInstance m_inst = null;

    // SimpleTimerMillis demo
    private SimpleTimerMillis m_timerMillis = new SimpleTimerMillis();

    // SimpleTimerNanos demo
    private SimpleTimerNanos m_timerNanos = new SimpleTimerNanos();


    public JTester()
    {
        // time how long for the gui to load
        m_timerMillis.start();
        m_timerNanos.start();

        init_lnf();

        initComponents();

        long nanos = m_timerNanos.elapsedNanos();
        double millis2 = m_timerNanos.elapsedMillis();
        double secs2 = m_timerNanos.elapsedSeconds();
        long millis = m_timerMillis.elapsedMillis();
        double secs = m_timerMillis.elapsedSeconds();

        System.out.println("gui startup time: " + nanos + " nanos, " + millis2 +
                " milliseconds, " + secs2 + " seconds.");
        System.out.println("gui startup time: " + millis + " milliseconds, " +
                secs + " seconds.");

        // reset the timer
        m_timerMillis.reset();
        m_timerNanos.reset();

        // time how long we used this application
        m_timerMillis.start();
        m_timerNanos.start();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        javax.swing.JTextArea infoTextArea = new javax.swing.JTextArea();
        javax.swing.JPanel buttonsPanel = new javax.swing.JPanel();
        javax.swing.JButton windowManagerButton = new javax.swing.JButton();
        javax.swing.JButton outlookToolbarButton = new javax.swing.JButton();
        javax.swing.JButton tableButton = new javax.swing.JButton();
        javax.swing.JButton jsplashButton = new javax.swing.JButton();
        javax.swing.JButton jconsoleButton = new javax.swing.JButton();
        jconsoleButton2 = new javax.swing.JButton();
        typesafeButton = new javax.swing.JButton();
        jmessageButton = new javax.swing.JButton();
        javax.swing.JMenuBar jMenuBar1 = new javax.swing.JMenuBar();
        javax.swing.JMenu jMenu1 = new javax.swing.JMenu();
        javax.swing.JMenuItem abnormalExit = new javax.swing.JMenuItem();
        javax.swing.JMenuItem normalExit = new javax.swing.JMenuItem();

        setTitle("Main Test/Demo Application");
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                formWindowClosing(evt);
            }
        });

        infoTextArea.setEditable(false);
        infoTextArea.setLineWrap(true);
        infoTextArea.setText("In order to test the SingleAppInstance functionality\ntry to start again this program (JTester).\n\nAlso you can try the \"Abnormal Exit\" from the menu\nand then try to start again this program.\n");
        infoTextArea.setWrapStyleWord(true);
        getContentPane().add(infoTextArea, java.awt.BorderLayout.CENTER);

        buttonsPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        windowManagerButton.setText("WindowManager");
        windowManagerButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                windowManagerButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(windowManagerButton);

        outlookToolbarButton.setText("OutLookToolBar");
        outlookToolbarButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                outlookToolbarButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(outlookToolbarButton);

        tableButton.setText("JTable");
        tableButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                tableButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(tableButton);

        jsplashButton.setText("JSplash");
        jsplashButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jsplashButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(jsplashButton);

        jconsoleButton.setText("JConsole");
        jconsoleButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jconsoleButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(jconsoleButton);

        jconsoleButton2.setText("JConsole2");
        jconsoleButton2.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jconsoleButton2ActionPerformed(evt);
            }
        });
        buttonsPanel.add(jconsoleButton2);

        typesafeButton.setText("TypeSafe");
        typesafeButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                typesafeButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(typesafeButton);

        jmessageButton.setText("JMessage");
        jmessageButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jmessageButtonActionPerformed(evt);
            }
        });
        buttonsPanel.add(jmessageButton);

        getContentPane().add(buttonsPanel, java.awt.BorderLayout.SOUTH);

        jMenu1.setText("Menu");

        abnormalExit.setText("Abnormal Exit");
        abnormalExit.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                abnormalExitActionPerformed(evt);
            }
        });
        jMenu1.add(abnormalExit);

        normalExit.setText("Normal Exit");
        normalExit.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                normalExitActionPerformed(evt);
            }
        });
        jMenu1.add(normalExit);

        jMenuBar1.add(jMenu1);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jconsoleButton2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jconsoleButton2ActionPerformed
    {//GEN-HEADEREND:event_jconsoleButton2ActionPerformed

        JOptionPane.showMessageDialog(
            this,
            "Please use the console_panel.bat to check out the " +
                "JConsolePane functionality.",
            "Info",
            JOptionPane.INFORMATION_MESSAGE);

        /* This does not work any more. Why?
         *
        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JConsolePaneTester t = new JConsolePaneTester();
                    t.setVisible(true);
                    t.setExitMode( false );
                }
            }
        );*/

    }//GEN-LAST:event_jconsoleButton2ActionPerformed

    private void jmessageButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jmessageButtonActionPerformed
    {//GEN-HEADEREND:event_jmessageButtonActionPerformed

        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JMessageTester t = new JMessageTester();
                    t.setVisible(true);
                    t.setDefaultCloseOperation( WindowConstants.HIDE_ON_CLOSE );
                }
            }
        );

    }//GEN-LAST:event_jmessageButtonActionPerformed

    private void typesafeButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_typesafeButtonActionPerformed
    {//GEN-HEADEREND:event_typesafeButtonActionPerformed

        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JTypeSafeTester t = new JTypeSafeTester();
                    t.setVisible(true);
                    t.setDefaultCloseOperation( WindowConstants.HIDE_ON_CLOSE );
                }
            }
        );

    }//GEN-LAST:event_typesafeButtonActionPerformed

    private void normalExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_normalExitActionPerformed

        normal_exit();

    }//GEN-LAST:event_normalExitActionPerformed

    private void abnormalExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_abnormalExitActionPerformed

        abnormal_exit();

    }//GEN-LAST:event_abnormalExitActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing

        normal_exit();

    }//GEN-LAST:event_formWindowClosing

    private void windowManagerButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_windowManagerButtonActionPerformed

        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JDesktopTester t = new JDesktopTester();
                    t.setVisible(true);
                    t.setDefaultCloseOperation( WindowConstants.HIDE_ON_CLOSE );
                }
            }
        );

    }//GEN-LAST:event_windowManagerButtonActionPerformed

    private void outlookToolbarButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_outlookToolbarButtonActionPerformed

        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JToolBarTester t = new JToolBarTester();
                    t.setVisible(true);
                    t.setDefaultCloseOperation( WindowConstants.HIDE_ON_CLOSE );
                }
            }
        );

    }//GEN-LAST:event_outlookToolbarButtonActionPerformed

    private void tableButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_tableButtonActionPerformed
    {//GEN-HEADEREND:event_tableButtonActionPerformed

        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JTableTester t = new JTableTester();
                    t.setVisible(true);
                    t.setDefaultCloseOperation( WindowConstants.HIDE_ON_CLOSE );
                }
            }
        );

    }//GEN-LAST:event_tableButtonActionPerformed

    private void jsplashButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jsplashButtonActionPerformed

        JOptionPane.showMessageDialog(
            this,
            "Please use the splash.bat to check out the splash screen demo.",
            "Info",
            JOptionPane.INFORMATION_MESSAGE);

    }//GEN-LAST:event_jsplashButtonActionPerformed

    private void jconsoleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jconsoleButtonActionPerformed

        JOptionPane.showMessageDialog(
            this,
            "Please use the console.bat to check out the " +
                "JConsolePane functionality.",
            "Info",
            JOptionPane.INFORMATION_MESSAGE);

        /* This does not work any more. Why?
         *
        SwingUtilities.invokeLater(
            new Runnable() {
                public void run() {
                    JConsoleTester t = new JConsoleTester();
                    t.setVisible(true);
                    t.setExitMode( false );
                }
            }
        );*/

    }//GEN-LAST:event_jconsoleButtonActionPerformed


    /**
     * setup our look and feel
     */
    private void init_lnf()
    {
        try
        {
            UIManager.setLookAndFeel(
                    UIManager.getSystemLookAndFeelClassName() );
        }
        catch( Exception e )
        {
            System.err.println("Cannot initialize the look & feel");

            e.printStackTrace();
        }
    }


    private void abnormal_exit()
    {
        // do not invoke SingleAppInstance's onExit() method...
        // ...and see what happens!
        System.exit( 0 );
    }


    private void normal_exit()
    {
        // at the end make sure we notify SingleAppInstance
        // that our application finished...
        m_inst.onExit();

        long nanos = m_timerNanos.elapsedNanos();
        double millis2 = m_timerNanos.elapsedMillis();
        double secs2 = m_timerNanos.elapsedSeconds();
        long millis = m_timerMillis.elapsedMillis();
        double secs = m_timerMillis.elapsedSeconds();
        System.out.println("user time: " + nanos + " nanoseconds, " + millis2 +
                " milliseconds, " + secs2 + " seconds.");
        System.out.println("user time: " + millis + " milliseconds, " + secs +
                " seconds.");

        System.exit( 0 );
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        m_inst = SingleAppInstance.getInstance();
        /*
         * if you wish to execute more than one applications at a single time,
         * from within the same folder use the method below instead, in order
         * to specify the unique filename to create and lock.
         *
         * m_inst = SingleAppInstance.getInstance(
         *              JTester.class.getSimpleName() + ".run" );
         */

        /*
         * if you wish to be notified via stderr instead a popup window, use
         * the method below. Execute now 2 times the 'test.bat' and see what
         * happens!
         *
         * m_inst.setReportPopup( false );
         */

        // notify SingleAppInstance that our application started...
        m_inst.onInit();

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JTester().setVisible(true);
            }
        });
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jconsoleButton2;
    private javax.swing.JButton jmessageButton;
    private javax.swing.JButton typesafeButton;
    // End of variables declaration//GEN-END:variables

}
