# frozen_string_literal: true

module Gitlab
  module BackgroundMigration
    # This batched background migration will backfill values for `uuid_convert_string_to_uuid` column in
    # vulnerability_occurrences table to allow us to migrate the column type from `varchar(36)` to `uuid`
    class BackfillUuidConversionColumnInVulnerabilityOccurrences < BatchedMigrationJob
      operation_name :backfill_uuid_conversion_column_in_vulnerability_occurrences
      scope_to ->(relation) do
        relation.where("uuid_convert_string_to_uuid = '00000000-0000-0000-0000-000000000000'::uuid")
      end
      feature_category :vulnerability_management

      def perform
        each_sub_batch do |sub_batch|
          sub_batch.update_all("uuid_convert_string_to_uuid = uuid::uuid")
        end
      end
    end
  end
end
