; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; Test to make sure llvm.invariant.start calls are not treated as clobbers.
; RUN: opt < %s -passes=dse -S | FileCheck %s

declare ptr @llvm.invariant.start.p0(i64, ptr nocapture) nounwind readonly

; We could remove either store here. The first store is dead in the
; conventional sense, because there is a later killing store. The second store
; is undefined behavior by the semantics of invariant.start, and as such
; unreachable.
define void @test(ptr %p) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    store i8 3, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret void
;
  store i8 1, ptr %p, align 4
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %p)
  store i8 3, ptr %p, align 4
  ret void
}

; FIXME: We should be able to remove the first store to p, even though p and q
; may alias.
define void @test2(ptr %p, ptr %q) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    store i8 1, ptr [[P:%.*]], align 4
; CHECK-NEXT:    store i8 2, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[I:%.*]] = call ptr @llvm.invariant.start.p0(i64 1, ptr [[Q]])
; CHECK-NEXT:    store i8 3, ptr [[P]], align 4
; CHECK-NEXT:    ret void
;
  store i8 1, ptr %p, align 4
  store i8 2, ptr %q, align 4
  %i = call ptr @llvm.invariant.start.p0(i64 1, ptr %q)
  store i8 3, ptr %p, align 4
  ret void
}
