; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zbkb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32ZBKB

declare i32 @llvm.riscv.brev8(i32);

define i32 @brev8(i32 %a) nounwind {
; RV32ZBKB-LABEL: brev8:
; RV32ZBKB:       # %bb.0:
; RV32ZBKB-NEXT:    brev8 a0, a0
; RV32ZBKB-NEXT:    ret
  %val = call i32 @llvm.riscv.brev8(i32 %a)
  ret i32 %val
}

; Test that rev8 is recognized as preserving zero extension.
define zeroext i16 @brev8_knownbits(i16 zeroext %a) nounwind {
; RV32ZBKB-LABEL: brev8_knownbits:
; RV32ZBKB:       # %bb.0:
; RV32ZBKB-NEXT:    brev8 a0, a0
; RV32ZBKB-NEXT:    ret
  %zext = zext i16 %a to i32
  %val = call i32 @llvm.riscv.brev8(i32 %zext)
  %trunc = trunc i32 %val to i16
  ret i16 %trunc
}

declare i32 @llvm.bswap.i32(i32)

define i32 @rev8_i32(i32 %a) nounwind {
; RV32ZBKB-LABEL: rev8_i32:
; RV32ZBKB:       # %bb.0:
; RV32ZBKB-NEXT:    rev8 a0, a0
; RV32ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

declare i32 @llvm.riscv.zip(i32);

define i32 @zip(i32 %a) nounwind {
; RV32ZBKB-LABEL: zip:
; RV32ZBKB:       # %bb.0:
; RV32ZBKB-NEXT:    zip a0, a0
; RV32ZBKB-NEXT:    ret
  %val = call i32 @llvm.riscv.zip(i32 %a)
  ret i32 %val
}

declare i32 @llvm.riscv.unzip(i32);

define i32 @unzip(i32 %a) nounwind {
; RV32ZBKB-LABEL: unzip:
; RV32ZBKB:       # %bb.0:
; RV32ZBKB-NEXT:    unzip a0, a0
; RV32ZBKB-NEXT:    ret
  %val = call i32 @llvm.riscv.unzip(i32 %a)
  ret i32 %val
}
