; NOTE: Assertions have been autogenerated by update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i64 @ptrdiff1(ptr %ptr) {
; CHECK-LABEL: @ptrdiff1(
; CHECK:         ret i64 42
;
  %last = getelementptr inbounds i8, ptr %ptr, i32 42
  %first.int = ptrtoint ptr %ptr to i64
  %last.int = ptrtoint ptr %last to i64
  %diff = sub i64 %last.int, %first.int
  ret i64 %diff
}

define i64 @ptrdiff2(ptr %ptr) {
; CHECK-LABEL: @ptrdiff2(
; CHECK:         ret i64 42
;
  %first2 = getelementptr inbounds i8, ptr %ptr, i32 1
  %first3 = getelementptr inbounds i8, ptr %first2, i32 2
  %first4 = getelementptr inbounds i8, ptr %first3, i32 4
  %last1 = getelementptr inbounds i8, ptr %first2, i32 48
  %last2 = getelementptr inbounds i8, ptr %last1, i32 8
  %last3 = getelementptr inbounds i8, ptr %last2, i32 -4
  %last4 = getelementptr inbounds i8, ptr %last3, i32 -4
  %first.int = ptrtoint ptr %first4 to i64
  %last.int = ptrtoint ptr %last4 to i64
  %diff = sub i64 %last.int, %first.int
  ret i64 %diff
}

define i64 @ptrdiff3(ptr %ptr) {
; Don't bother with non-inbounds GEPs.
; CHECK-LABEL: @ptrdiff3(
; CHECK:         [[LAST:%.*]] = getelementptr i8, ptr %ptr, i32 42
; CHECK-NEXT:    [[FIRST_INT:%.*]] = ptrtoint ptr %ptr to i64
; CHECK-NEXT:    [[LAST_INT:%.*]] = ptrtoint ptr [[LAST]] to i64
; CHECK-NEXT:    [[DIFF:%.*]] = sub i64 [[LAST_INT]], [[FIRST_INT]]
; CHECK-NEXT:    ret i64 [[DIFF]]
;
  %last = getelementptr i8, ptr %ptr, i32 42
  %first.int = ptrtoint ptr %ptr to i64
  %last.int = ptrtoint ptr %last to i64
  %diff = sub i64 %last.int, %first.int
  ret i64 %diff
}

define <4 x i32> @ptrdiff4(<4 x ptr> %arg) nounwind {
; Handle simple cases of vectors of pointers.
; CHECK-LABEL: @ptrdiff4(
; CHECK:         ret <4 x i32> zeroinitializer
;
  %p1 = ptrtoint <4 x ptr> %arg to <4 x i32>
  %bc = bitcast <4 x ptr> %arg to <4 x ptr>
  %p2 = ptrtoint <4 x ptr> %bc to <4 x i32>
  %sub = sub <4 x i32> %p1, %p2
  ret <4 x i32> %sub
}

%struct.ham = type { i32, [2 x [2 x i32]] }

@global = internal global %struct.ham zeroinitializer, align 4

define i32 @ptrdiff5() nounwind {
; CHECK-LABEL: @ptrdiff5(
; CHECK:       bb:
; CHECK-NEXT:    ret i32 0
;
bb:
  %tmp = getelementptr inbounds %struct.ham, ptr @global, i32 0, i32 1
  %tmp3 = ptrtoint ptr %tmp to i32
  %tmp4 = getelementptr inbounds %struct.ham, ptr @global, i32 0, i32 1
  %tmp6 = ptrtoint ptr %tmp4 to i32
  %tmp7 = sub i32 %tmp3, %tmp6
  ret i32 %tmp7
}
