/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.managed.PoolableManagedConnection;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionRegistry;
import org.apache.tomcat.dbcp.dbcp2.managed.XAConnectionFactory;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableManagedConnectionFactory
extends PoolableConnectionFactory {
    private final TransactionRegistry transactionRegistry;

    public PoolableManagedConnectionFactory(XAConnectionFactory xAConnectionFactory, ObjectName objectName) {
        super(xAConnectionFactory, objectName);
        this.transactionRegistry = xAConnectionFactory.getTransactionRegistry();
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public synchronized PooledObject<PoolableConnection> makeObject() throws SQLException {
        Object object;
        Connection connection = this.getConnectionFactory().createConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(connection);
        if (this.getPoolStatements()) {
            Object object2;
            connection = new PoolingConnection(connection);
            object = new GenericKeyedObjectPoolConfig();
            ((GenericKeyedObjectPoolConfig)object).setMaxTotalPerKey(-1);
            ((BaseObjectPoolConfig)object).setBlockWhenExhausted(false);
            ((BaseObjectPoolConfig)object).setMaxWait(Duration.ZERO);
            ((GenericKeyedObjectPoolConfig)object).setMaxIdlePerKey(1);
            ((GenericKeyedObjectPoolConfig)object).setMaxTotal(this.getMaxOpenPreparedStatements());
            ObjectName objectName = this.getDataSourceJmxName();
            long l = this.getConnectionIndex().getAndIncrement();
            if (objectName != null) {
                object2 = new StringBuilder(objectName.toString());
                ((StringBuilder)object2).append(",connectionpool=connections,connection=");
                ((StringBuilder)object2).append(l);
                ((BaseObjectPoolConfig)object).setJmxNameBase(((StringBuilder)object2).toString());
                ((BaseObjectPoolConfig)object).setJmxNamePrefix(",statementpool=statements");
            } else {
                ((BaseObjectPoolConfig)object).setJmxEnabled(false);
            }
            object2 = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>((PoolingConnection)connection, (GenericKeyedObjectPoolConfig<DelegatingPreparedStatement>)object);
            ((PoolingConnection)connection).setStatementPool((KeyedObjectPool<PStmtKey, DelegatingPreparedStatement>)object2);
            ((PoolingConnection)connection).setCacheState(this.getCacheState());
        }
        object = new PoolableManagedConnection(this.transactionRegistry, connection, this.getPool(), this.getDisconnectionSqlCodes(), this.getDisconnectionIgnoreSqlCodes(), this.isFastFailValidation());
        ((DelegatingConnection)object).setCacheState(this.getCacheState());
        return new DefaultPooledObject<Object>(object);
    }
}

