/**
 *
 * @file pastix/config.h.in
 *
 * PaStiX configuration parameters
 *
 * @copyright 2016-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Gregoire Pichon
 * @author Tony Delarue
 * @author Nolan Bredel
 * @author Tom Moenne-Loccoz
 * @author Brieuc Nicolas
 * @author Mohamed Aymane Kherraz
 * @date 2024-07-05
 *
 **/
#ifndef _pastix_config_h_
#define _pastix_config_h_

#define PASTIX_VERSION_MAJOR 6
#define PASTIX_VERSION_MINOR 4
#define PASTIX_VERSION_MICRO 0

#define PASTIX_WITH_FORTRAN
#define PASTIX_WITH_MPI
/* #undef PASTIX_WITH_CUDA */
/* #undef PASTIX_WITH_EZTRACE */
/* #undef PASTIX_WITH_PAPI */

/* system */
#define HAVE_SCHED_SETAFFINITY
#define HAVE_CLOCK_GETTIME
/* #define HAVE_ASPRINTF */
/* #define HAVE_VASPRINTF */
#define HAVE_ATOMIC_GCC_32_BUILTINS
#define HAVE_ATOMIC_GCC_64_BUILTINS
/* #undef HAVE_ATOMIC_GCC_128_BUILTINS */
/* #undef HAVE_ATOMIC_XLC_32_BUILTINS */
/* #undef HAVE_ATOMIC_XLC_64_BUILTINS */
/* #undef HAVE_ATOMIC_MIPOSPRO_32_BUILTINS */
/* #undef HAVE_ATOMIC_MIPOSPRO_64_BUILTINS */
/* #undef HAVE_ATOMIC_SUN_32 */
/* #undef HAVE_ATOMIC_SUN_64 */
#define HAVE_STDARG_H
#define HAVE_UNISTD_H
#define HAVE_VA_COPY
/* #undef HAVE_UNDERSCORE_VA_COPY */
#define HAVE_GETOPT_LONG
#define HAVE_GETRUSAGE
#define HAVE_GETOPT_H
#define HAVE_ERRNO_H
#define HAVE_STDDEF_H
#define HAVE_LIMITS_H
#define HAVE_STRING_H
#define HAVE_COMPLEX_H
#define HAVE_FALLTHROUGH
#define HAVE_BUILTIN_EXPECT
#define HAVE_GETLINE
#define HAVE_MKDTEMP
/* #undef HAVE_MM_SETCSR */
/* #undef HAVE_FTZ_MACROS */
/* #undef HAVE_DAZ_MACROS */

/* BLAS set_num_threads */
/* #undef HAVE_BLAS_SET_NUM_THREADS */
/* #undef HAVE_BLI_THREAD_SET_NUM_THREADS */
/* #undef HAVE_MKL_SET_NUM_THREADS */
/* #undef HAVE_OPENBLAS_SET_NUM_THREADS */

/* Architecture */
/* #undef PASTIX_ARCH_X86 */
/* #undef PASTIX_ARCH_X86_64 */
/* #undef PASTIX_ARCH_PPC */
/* #undef PASTIX_OS_MACOS */

/* Optional packages */
#define HAVE_HWLOC

/* Ordering options */
#define PASTIX_ORDERING_SCOTCH
/* #undef PASTIX_ORDERING_METIS */
/* #undef PASTIX_ORDERING_PTSCOTCH */

#define PASTIX_ORDERING_FIX_SEED
#define PASTIX_ORDERING_SCOTCH_MT

/* Symbolic factorization options */
/* #undef PASTIX_SYMBOL_DUMP_SYMBMTX */
/* #undef PASTIX_ORDER_DRAW_LASTSEP */

/* Analyze options */
/* #undef PASTIX_BLEND_GENTRACE */
#define PASTIX_BLEND_DEEPEST_DISTRIB
/* #undef PASTIX_BLEND_PROPMAP_2STEPS */
/* #undef PASTIX_BLEND_FANIN_FR */

/* #undef FORGET_PARTITION */
/* #undef COMPACT_SMX */

/* Numerical factorization options */
/* #undef PASTIX_NUMFACT_DUMP_SOLVER */
/* #undef PASTIX_SUPERNODE_STATS */
/* #undef PASTIX_COMMUNICATION_MATRIX */

/* Scheduling options */
/* #undef PASTIX_WITH_PARSEC */
/* #undef PASTIX_WITH_STARPU */
/* #undef PASTIX_STARPU_PROFILING */
/* #undef PASTIX_STARPU_PROFILING_LOG */
/* #undef PASTIX_STARPU_COST_PER_ARCH */
/* #undef PASTIX_STARPU_SYNC */
/* #undef PASTIX_STARPU_STATS */
/* #undef PASTIX_STARPU_HETEROPRIO */
/* #undef HAVE_STARPU_SCHED_POLICY_CALLBACK */

/* Models */
/* #undef PASTIX_GENERATE_MODEL */

/* #undef PASTIX_CUDA_FERMI */

#define PASTIX_THREAD_COMM

/* Debug */
/* #undef PASTIX_DEBUG_VALGRIND */
/* #undef PASTIX_DEBUG_GRAPH */
/* #undef PASTIX_DEBUG_ORDERING */
/* #undef PASTIX_DEBUG_SYMBOL */
/* #undef PASTIX_DEBUG_BLEND */
/* #undef PASTIX_DEBUG_DUMP_COEFTAB */
/* #undef PASTIX_DEBUG_FACTO */
/* #undef PASTIX_DEBUG_SOLVE */
/* #undef PASTIX_DEBUG_PARSEC */
/* #undef PASTIX_DEBUG_STARPU */
/* #undef PASTIX_DEBUG_LR */
/* #undef PASTIX_DEBUG_LR_NANCHECK */
/* #undef PASTIX_DEBUG_GMRES */
/* #undef PASTIX_DEBUG_MPI */

/* Datatypes used */
/* #undef PASTIX_INT64 */

#if defined(HAVE_FALLTHROUGH)
#define pastix_attr_fallthrough __attribute__((fallthrough))
#else
#define pastix_attr_fallthrough do {} while(0)
#endif

#if defined(WIN32) || defined(_WIN32)
#define PASTIX_OS_WINDOWS 1
#endif

/*
 * BEGIN_C_DECLS should be used at the beginning of your declarations,
 * so that C++ compilers don't mangle their names.  Use END_C_DECLS at
 * the end of C declarations.
 */
#undef BEGIN_C_DECLS
#undef END_C_DECLS
#if defined(c_plusplus) || defined(__cplusplus)
# define BEGIN_C_DECLS extern "C" {
# define END_C_DECLS }
#else
#define BEGIN_C_DECLS          /* empty */
#define END_C_DECLS            /* empty */
#endif

#endif /* _pastix_config_h_ */
