/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;
import tim.prune.gui.BaseImageDefinitionPanel;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.WholeNumberField;
import tim.prune.gui.colour.PointColourer;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.MapUtils;
import tim.prune.gui.map.WaypointIcons;
import tim.prune.gui.map.WpIconDefinition;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.BaseImageConsumer;
import tim.prune.save.GroutedImage;
import tim.prune.save.ImageSizeLimits;
import tim.prune.save.MapGrouter;
import tim.prune.threedee.ImageDefinition;

public class ImageExporter
extends GenericFunction
implements BaseImageConsumer {
    private JDialog _dialog = null;
    private JCheckBox _drawDataCheckbox = null;
    private JCheckBox _drawTrackPointsCheckbox = null;
    private WholeNumberField _textScaleField = null;
    private BaseImageDefinitionPanel _baseImagePanel = null;
    private JFileChooser _fileChooser = null;
    private JButton _okButton = null;

    public ImageExporter(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.exportimage";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._textScaleField.setValue(100);
        }
        if (!this._baseImagePanel.isImagePossible()) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.exportimage.noimagepossible");
            return;
        }
        this._baseImagePanel.updateBaseImageDetails();
        this.baseImageChanged();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(4, 4));
        this._drawDataCheckbox = new JCheckBox(I18nManager.getText("dialog.exportimage.drawtrack"));
        this._drawDataCheckbox.setSelected(true);
        this._drawTrackPointsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportimage.drawtrackpoints"));
        this._drawTrackPointsCheckbox.setSelected(true);
        this._drawDataCheckbox.addActionListener(actionEvent -> this._drawTrackPointsCheckbox.setEnabled(this._drawDataCheckbox.isSelected()));
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        guiGridLayout.add(new JLabel(String.valueOf(I18nManager.getText("dialog.exportimage.textscalepercent")) + ": "));
        this._textScaleField = new WholeNumberField(3);
        this._textScaleField.setText("888");
        guiGridLayout.add(this._textScaleField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> {
            this.doExport();
            this._baseImagePanel.getGrouter().clearMapImage();
            this._dialog.dispose();
        });
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> {
            this._baseImagePanel.getGrouter().clearMapImage();
            this._dialog.dispose();
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ImageExporter.this._dialog.dispose();
                    ImageExporter.this._baseImagePanel.getGrouter().clearMapImage();
                }
            }
        };
        this._drawDataCheckbox.addKeyListener(keyAdapter);
        this._baseImagePanel = new BaseImageDefinitionPanel(this, this._dialog, this._app.getTrackInfo().getTrack(), this.getConfig());
        this._baseImagePanel.setImageDefaultYes();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(this._drawDataCheckbox);
        jPanel4.add(this._drawTrackPointsCheckbox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel2, "Center");
        jPanel5.add((Component)this._baseImagePanel, "South");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add((Component)jPanel5, "North");
        return jPanel;
    }

    private void doExport() {
        this._okButton.setEnabled(false);
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetypefilter.png", new String[]{"png"}));
            this._fileChooser.setAcceptAllFileFilterUsed(false);
            String string = this.getConfig().getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        boolean bl = false;
        do {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".png")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".png");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                if (this.exportFile(file)) continue;
                bl = true;
                continue;
            }
            bl = true;
        } while (bl);
    }

    private boolean exportFile(File file) {
        ImageDefinition imageDefinition = this._baseImagePanel.getImageDefinition();
        MapSource mapSource = MapSourceLibrary.getSource(imageDefinition.getSourceIndex());
        MapGrouter mapGrouter = this._baseImagePanel.getGrouter();
        GroutedImage groutedImage = mapGrouter.getMapImage(this._app.getTrackInfo().getTrack(), mapSource, imageDefinition.getZoom(), this.getConfig());
        if (groutedImage == null || !groutedImage.isValid()) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.exportpov.cannotmakebaseimage");
            return true;
        }
        try {
            if (this._drawDataCheckbox.isSelected()) {
                this.drawData(groutedImage);
            }
            if (!ImageIO.write((RenderedImage)groutedImage.getImage(), "png", file)) {
                this._app.showErrorMessage(this.getNameKey(), "dialog.exportpov.cannotmakebaseimage");
                return false;
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't write image: " + iOException.getClass().getName());
        }
        return true;
    }

    private void drawData(GroutedImage groutedImage) {
        int n;
        int n2;
        double d;
        Object object;
        int n3;
        double d2;
        Object object2;
        DoubleRange doubleRange = groutedImage.getXRange();
        DoubleRange doubleRange2 = groutedImage.getYRange();
        int n4 = 1 << this._baseImagePanel.getImageDefinition().getZoom();
        Graphics graphics = groutedImage.getImage().getGraphics();
        PointColourer pointColourer = this._app.getPointColourer();
        Color color = this.getConfig().getColourScheme().getColour(1);
        graphics.setColor(color);
        Track track = this._app.getTrackInfo().getTrack();
        int n5 = track.getNumPoints();
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        int n8 = 0;
        while (n8 < n5) {
            object2 = track.getPoint(n8);
            if (!((DataPoint)object2).isWaypoint()) {
                if (pointColourer != null) {
                    Color color2 = pointColourer.getColour(n8);
                    graphics.setColor(color2 == null ? color : color2);
                }
                double d3 = track.getX(n8) - doubleRange.getMinimum();
                d2 = track.getY(n8) - doubleRange2.getMinimum();
                int n9 = (int)(d3 * (double)n4 * 256.0);
                n3 = (int)(d2 * (double)n4 * 256.0);
                if (!((DataPoint)object2).getSegmentStart() && bl) {
                    graphics.drawLine(n6, n7, n9, n3);
                }
                if (this._drawTrackPointsCheckbox.isSelected()) {
                    graphics.drawRect(n9 - 2, n3 - 2, 3, 3);
                }
                n6 = n9;
                n7 = n3;
                bl = true;
            }
            ++n8;
        }
        Color color3 = this.getConfig().getColourScheme().getColour(3);
        graphics.setColor(color3);
        object2 = WaypointIcons.getDefinition(this.getConfig(), this._app.getIconManager());
        int n10 = 0;
        while (n10 < n5) {
            object = track.getPoint(n10);
            if (((DataPoint)object).isWaypoint()) {
                d2 = track.getX(n10) - doubleRange.getMinimum();
                double d4 = track.getY(n10) - doubleRange2.getMinimum();
                int n11 = (int)(d2 * (double)n4 * 256.0);
                int n12 = (int)(d4 * (double)n4 * 256.0);
                graphics.fillRect(n11 - 3, n12 - 3, 6, 6);
                if (object2 == null) {
                    graphics.fillRect(n11 - 3, n12 - 3, 6, 6);
                } else {
                    graphics.drawImage(((WpIconDefinition)object2).getImageIcon().getImage(), n11 - ((WpIconDefinition)object2).getXOffset(), n12 - ((WpIconDefinition)object2).getYOffset(), null);
                }
            }
            ++n10;
        }
        n10 = this._textScaleField.getValue();
        if (n10 > 0 && n10 <= 999) {
            object = graphics.getFont();
            graphics.setFont(((Font)object).deriveFont((float)((double)((Font)object).getSize() * 0.01 * (double)n10)));
        }
        object = graphics.getFontMetrics();
        int n13 = ((FontMetrics)object).getHeight();
        int n14 = groutedImage.getImageSize();
        Color color4 = this.getConfig().getColourScheme().getColour(5);
        graphics.setColor(color4);
        n3 = 0;
        while (n3 < n5) {
            DataPoint dataPoint = track.getPoint(n3);
            if (dataPoint.hasMedia()) {
                double d5 = track.getX(n3) - doubleRange.getMinimum();
                d = track.getY(n3) - doubleRange2.getMinimum();
                n2 = (int)(d5 * (double)n4 * 256.0);
                n = (int)(d * (double)n4 * 256.0);
                graphics.fillRect(n2 - 3, n - 3, 6, 6);
            }
            ++n3;
        }
        graphics.setColor(color3);
        n3 = 0;
        while (n3 < n5) {
            DataPoint dataPoint = track.getPoint(n3);
            if (dataPoint.isWaypoint() && n10 > 0) {
                double d6 = track.getX(n3) - doubleRange.getMinimum();
                d = track.getY(n3) - doubleRange2.getMinimum();
                n2 = (int)(d6 * (double)n4 * 256.0);
                n = (int)(d * (double)n4 * 256.0);
                String string = dataPoint.getWaypointName();
                int n15 = ((FontMetrics)object).stringWidth(string);
                boolean bl2 = false;
                int[] nArray = new int[]{n2 + 2, n2 - n15 - 2, n2 - n15 / 2, n2 - n15 / 2};
                int[] nArray2 = new int[]{n + n13 / 2, n + n13 / 2, n - 2, n + n13 + 2};
                int n16 = 4;
                while (n16 < 13 && !bl2) {
                    nArray[0] = nArray[0] + 2;
                    nArray[1] = nArray[1] - 2;
                    nArray2[2] = nArray2[2] - 2;
                    nArray2[3] = nArray2[3] + 2;
                    int n17 = 0;
                    while (n17 < 4) {
                        if (nArray[n17] > 0 && nArray[n17] + n15 < n14 && nArray2[n17] < n14 && nArray2[n17] - n13 > 0 && !MapUtils.overlapsPoints(groutedImage.getImage(), nArray[n17], nArray2[n17], n15, n13, color3)) {
                            graphics.drawString(string, nArray[n17], nArray2[n17]);
                            bl2 = true;
                            break;
                        }
                        ++n17;
                    }
                    n16 += 2;
                }
            }
            ++n3;
        }
    }

    @Override
    public void baseImageChanged() {
        boolean bl = this._baseImagePanel.getImageDefinition().getUseImage();
        int n = this._baseImagePanel.getImageDefinition().getZoom();
        boolean bl2 = bl && this._baseImagePanel.getFoundData() && ImageSizeLimits.isZoomLevelOk(this._app.getTrackInfo().getTrack(), n);
        this._okButton.setEnabled(bl2);
    }
}

