/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress.methods;

import tim.prune.data.DataPoint;
import tim.prune.data.MarkingData;
import tim.prune.data.SpeedValue;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.compress.TrackDetails;
import tim.prune.function.compress.methods.CompressionMethod;
import tim.prune.function.compress.methods.CompressionSpeedCalculator;

public abstract class SpeedLimitMethod
extends CompressionMethod {
    private final double _speedLimit;
    private final boolean _deleteFaster;

    public SpeedLimitMethod(double d, boolean bl) {
        this._speedLimit = d;
        this._deleteFaster = bl;
    }

    @Override
    public String getParam() {
        return "" + Math.abs(this._speedLimit);
    }

    protected double getSpeedLimit() {
        return this._speedLimit;
    }

    @Override
    public int compress(Track track, TrackDetails trackDetails, MarkingData markingData) {
        if (this._speedLimit <= 0.0) {
            return 0;
        }
        int n = track.getNumPoints();
        Double[] doubleArray = this.calculateSpeeds(track, markingData);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint;
            Double d;
            if (!markingData.isPointMarkedForDeletion(n3) && (d = doubleArray[n3]) != null && !(dataPoint = track.getPoint(n3)).isWaypoint() && !dataPoint.hasMedia() && !trackDetails.isSegmentStart(n3) && !trackDetails.isSegmentEnd(n3) && (this._deleteFaster && d > this._speedLimit || !this._deleteFaster && d < this._speedLimit)) {
                markingData.markPointForDeletion(n3, true, true);
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private Double[] calculateSpeeds(Track track, MarkingData markingData) {
        CompressionSpeedCalculator compressionSpeedCalculator = new CompressionSpeedCalculator(markingData);
        int n = track.getNumPoints();
        Double[] doubleArray = new Double[n];
        SpeedValue speedValue = new SpeedValue();
        int n2 = 0;
        while (n2 < n) {
            compressionSpeedCalculator.calculateHorizontalSpeed(track, n2, UnitSetLibrary.getMetricUnitSet(), speedValue);
            doubleArray[n2] = speedValue.isValid() ? Double.valueOf(speedValue.getValue()) : null;
            ++n2;
        }
        return doubleArray;
    }
}

