/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import tim.prune.data.Timestamp;

public class TimestampLocal
extends Timestamp {
    private final boolean _valid;
    private final int _year;
    private final int _month;
    private final int _day;
    private final int _hour;
    private final int _minute;
    private final int _second;

    public TimestampLocal(int n, int n2, int n3, int n4, int n5, int n6) {
        this._valid = n > 0 && n < 3000 && n2 > 0 && n2 < 13 && n3 > 0 && n3 < 32 && n4 >= 0 && n4 < 24 && n5 >= 0 && n5 < 60 && n6 >= 0 && n6 < 60;
        this._year = this._valid ? n : 0;
        this._month = this._valid ? n2 : 0;
        this._day = this._valid ? n3 : 0;
        this._hour = this._valid ? n4 : 0;
        this._minute = this._valid ? n5 : 0;
        this._second = this._valid ? n6 : 0;
    }

    @Override
    public boolean isValid() {
        return this._valid;
    }

    @Override
    public Calendar getCalendar(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        calendar.set(1, this._year);
        calendar.set(2, this._month - 1);
        calendar.set(5, this._day);
        calendar.set(11, this._hour);
        calendar.set(12, this._minute);
        calendar.set(13, this._second);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    public long getMilliseconds(TimeZone timeZone) {
        return this.getCalendar(timeZone).getTimeInMillis();
    }

    @Override
    public Timestamp addOffsetMilliseconds(long l) {
        throw new IllegalArgumentException("Local timestamps don't support offsets.");
    }

    @Override
    protected boolean hasMilliseconds() {
        return false;
    }

    @Override
    protected String format(DateFormat dateFormat, TimeZone timeZone) {
        Calendar calendar = this.getCalendar(timeZone);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat.format(calendar.getTime());
    }
}

