/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.morph;

import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MorphoFeatures
implements Serializable {
    private static final long serialVersionUID = -3893316324305154940L;
    public static final String KEY_VAL_DELIM = ":";
    protected final Map<MorphoFeatureSpecification.MorphoFeatureType, String> fSpec = new HashMap<MorphoFeatureSpecification.MorphoFeatureType, String>();
    protected String altTag;

    public void addFeature(MorphoFeatureSpecification.MorphoFeatureType feat, String val) {
        this.fSpec.put(feat, val);
    }

    public boolean hasFeature(MorphoFeatureSpecification.MorphoFeatureType feat) {
        return this.fSpec.containsKey((Object)feat);
    }

    public String getValue(MorphoFeatureSpecification.MorphoFeatureType feat) {
        if (this.fSpec.containsKey((Object)feat)) {
            return this.fSpec.get((Object)feat);
        }
        throw new IllegalArgumentException("Value requested for non-existent feature: " + feat.toString());
    }

    public int numFeatureMatches(MorphoFeatures other) {
        int nMatches = 0;
        for (Map.Entry<MorphoFeatureSpecification.MorphoFeatureType, String> fPair : this.fSpec.entrySet()) {
            if (!other.hasFeature(fPair.getKey()) || !other.getValue(fPair.getKey()).equals(fPair.getValue())) continue;
            ++nMatches;
        }
        return nMatches;
    }

    public int numActiveFeatures() {
        return this.fSpec.keySet().size();
    }

    public String getTag(String baseTag) {
        return baseTag + this.toString();
    }

    public void setAltTag(String tag) {
        this.altTag = tag;
    }

    public String getAltTag() {
        return this.altTag;
    }

    public MorphoFeatures fromTagString(String str) {
        List<String> feats = Arrays.asList(str.split("\\-"));
        MorphoFeatures mFeats = new MorphoFeatures();
        for (String fPair : feats) {
            String[] keyValue = fPair.split(KEY_VAL_DELIM);
            if (keyValue.length != 2) continue;
            MorphoFeatureSpecification.MorphoFeatureType fName = MorphoFeatureSpecification.MorphoFeatureType.valueOf(keyValue[0].trim());
            mFeats.addFeature(fName, keyValue[1].trim());
        }
        return mFeats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MorphoFeatureSpecification.MorphoFeatureType feat : MorphoFeatureSpecification.MorphoFeatureType.values()) {
            if (!this.fSpec.containsKey((Object)feat)) continue;
            sb.append(String.format("-%s%s%s", feat.toString(), KEY_VAL_DELIM, this.fSpec.get((Object)feat)));
        }
        return sb.toString();
    }
}

