"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentDirectives = getComponentDirectives;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
const builtInDirectives = new Set([
    'vBind',
    'vIf',
    'vOn',
    'vOnce',
    'vShow',
    'vSlot',
]);
function getComponentDirectives(fileName) {
    const { typescript: ts, language, languageService } = this;
    const sourceScript = language.scripts.get(fileName);
    const root = sourceScript?.generated?.root;
    if (!sourceScript?.generated || !(root instanceof language_core_1.VueVirtualCode)) {
        return [];
    }
    const directives = (0, utils_1.getVariableType)(ts, languageService, root, '__VLS_directives');
    if (!directives) {
        return [];
    }
    return directives.type.getProperties()
        .map(({ name }) => name)
        .filter(name => name.startsWith('v') && name.length >= 2 && name[1] === name[1].toUpperCase())
        .filter(name => !builtInDirectives.has(name));
}
//# sourceMappingURL=getComponentDirectives.js.map