"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const utils_1 = require("../utils");
function create() {
    return {
        name: 'vue-compiler-dom-errors',
        capabilities: {
            diagnosticProvider: {
                interFileDependencies: false,
                workspaceDiagnostics: false,
            },
        },
        create(context) {
            return {
                provideDiagnostics(document) {
                    const info = (0, utils_1.getEmbeddedInfo)(context, document, 'template');
                    if (!info) {
                        return;
                    }
                    const { root } = info;
                    const { template } = root.sfc;
                    if (!template) {
                        return;
                    }
                    const diagnostics = [];
                    for (const [errors, severity] of [
                        [template.errors, 1],
                        [template.warnings, 2],
                    ]) {
                        for (const error of errors) {
                            diagnostics.push({
                                range: {
                                    start: document.positionAt(error.loc?.start.offset ?? 0),
                                    end: document.positionAt(error.loc?.end.offset ?? 0),
                                },
                                severity,
                                code: error.code,
                                source: 'vue',
                                message: error.message,
                            });
                        }
                    }
                    return diagnostics;
                },
            };
        },
    };
}
//# sourceMappingURL=vue-compiler-dom-errors.js.map