"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const semanticTokens_1 = require("volar-service-typescript/lib/semanticFeatures/semanticTokens");
const utils_1 = require("../utils");
function create({ getEncodedSemanticClassifications }) {
    return {
        name: 'typescript-semantic-tokens',
        capabilities: {
            semanticTokensProvider: {
                legend: {
                    tokenTypes: [
                        'namespace',
                        'class',
                        'enum',
                        'interface',
                        'typeParameter',
                        'type',
                        'parameter',
                        'variable',
                        'property',
                        'enumMember',
                        'function',
                        'method',
                    ],
                    tokenModifiers: [
                        'declaration',
                        'readonly',
                        'static',
                        'async',
                        'defaultLibrary',
                        'local',
                    ],
                },
            },
        },
        create(context) {
            return {
                async provideDocumentSemanticTokens(document, range, legend) {
                    const info = (0, utils_1.getEmbeddedInfo)(context, document, 'main');
                    if (!info) {
                        return;
                    }
                    const { root } = info;
                    const start = document.offsetAt(range.start);
                    const end = document.offsetAt(range.end);
                    const span = {
                        start: start,
                        length: end - start,
                    };
                    const classifications = await getEncodedSemanticClassifications(root.fileName, span);
                    if (classifications) {
                        return (0, semanticTokens_1.convertClassificationsToSemanticTokens)(document, span, legend, classifications);
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=typescript-semantic-tokens.js.map