"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLanguageService = getLanguageService;
let currentProjectVersion = -1;
let currentFileName = '';
let currentSnapshot;
let languageService;
const host = {
    getProjectVersion: () => currentProjectVersion.toString(),
    getScriptFileNames: () => [currentFileName],
    getScriptVersion: () => currentProjectVersion.toString(),
    getScriptSnapshot: fileName => fileName === currentFileName ? currentSnapshot : undefined,
    getCompilationSettings: () => ({
        allowJs: true,
    }),
    getCurrentDirectory: () => '',
    getDefaultLibFileName: () => '',
    readFile: () => undefined,
    fileExists: fileName => fileName === currentFileName,
};
// TODO: share with volar-service-typescript
function getLanguageService(ts, snapshot, languageId) {
    if (currentSnapshot !== snapshot) {
        currentSnapshot = snapshot;
        currentFileName = '/tmp.' + (languageId === 'javascript'
            ? 'js'
            : languageId === 'typescriptreact'
                ? 'tsx'
                : languageId === 'javascriptreact'
                    ? 'jsx'
                    : 'ts');
        currentProjectVersion++;
    }
    languageService ??= ts.createLanguageService(host);
    return {
        languageService,
        fileName: currentFileName,
    };
}
//# sourceMappingURL=reactivityAnalyzeLS.js.map