import type * as ts from 'typescript';
declare const enum TrackKind {
    AccessDotValue = 0,
    AccessAnyValue = 1,
    Call = 2
}
interface SignalNode {
    bindingInfo?: {
        isRef: boolean;
        name: ts.BindingName;
        trackKinds: TrackKind[];
    };
    trackInfo?: {
        depsHandler: ts.Node;
        needToUse: boolean;
    };
    sideEffectInfo?: {
        isEffect: boolean;
        handler: ts.Node;
    };
}
export declare function analyze(ts: typeof import('typescript'), languageService: ts.LanguageService, fileName: string, position: number): {
    sourceFile: ts.SourceFile;
    subscribers: SignalNode[];
    dependencies: ts.Node[];
} | undefined;
export {};
