/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Inflection;
import us.fatehi.utility.Multimap;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class PrefixMatches {
    private static final Logger LOGGER = Logger.getLogger(PrefixMatches.class.getName());
    private final String keySeparator;
    private final Multimap<String, String> keyPrefixes;

    public PrefixMatches(List<String> keys, String keySeparator) {
        this.keySeparator = Objects.requireNonNull(keySeparator, "No key separator provided");
        this.keyPrefixes = new Multimap();
        this.analyze(keys);
    }

    public List<String> get(String key) {
        if (this.keyPrefixes.containsKey(key)) {
            return (List)this.keyPrefixes.get(key);
        }
        return Arrays.asList(key);
    }

    public String toString() {
        return this.keyPrefixes.toString();
    }

    private void analyze(List<String> keys) {
        if (keys.isEmpty()) {
            return;
        }
        Collection<String> prefixes = this.findPrefixes(keys);
        this.mapPrefixes(keys, prefixes);
        LOGGER.log(Level.FINE, new StringFormat("Key prefixes=%s", prefixes));
        LOGGER.log(Level.FINE, new StringFormat("Key matches map: %s", new ObjectToStringFormat(this.keyPrefixes)));
    }

    private Collection<String> findPrefixes(List<String> keys) {
        TreeMap<String, Integer> prefixesMap = new TreeMap<String, Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            for (int j = i + 1; j < keys.size(); ++j) {
                String key2;
                String key1 = keys.get(i);
                String commonPrefix = Utility.commonPrefix(key1, key2 = keys.get(j));
                if (Utility.isBlank(commonPrefix)) continue;
                ArrayList<String> splitCommonPrefixes = new ArrayList<String>();
                String[] splitPrefix = commonPrefix.split(this.keySeparator);
                if (splitPrefix != null && splitPrefix.length > 0) {
                    for (int k = 0; k < splitPrefix.length; ++k) {
                        StringBuilder buffer = new StringBuilder(1024);
                        for (int l = 0; l < k; ++l) {
                            buffer.append(splitPrefix[l]).append(this.keySeparator);
                        }
                        if (buffer.length() <= 0) continue;
                        splitCommonPrefixes.add(buffer.toString());
                    }
                }
                if (commonPrefix.endsWith(this.keySeparator)) {
                    splitCommonPrefixes.add(commonPrefix);
                }
                for (String splitCommonPrefix : splitCommonPrefixes) {
                    int prevCount = prefixesMap.containsKey(splitCommonPrefix) ? (Integer)prefixesMap.get(splitCommonPrefix) : 0;
                    prefixesMap.put(splitCommonPrefix, prevCount + 1);
                }
            }
        }
        ArrayList prefixesList = new ArrayList(prefixesMap.entrySet());
        Collections.sort(prefixesList, (entry1, entry2) -> ((Integer)entry1.getValue()).compareTo((Integer)entry2.getValue()));
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < prefixesList.size(); ++i) {
            boolean add;
            boolean bl = add = i < 5 || (double)((Integer)((Map.Entry)prefixesList.get(i)).getValue()).intValue() > (double)prefixesMap.size() * 0.5;
            if (!add) continue;
            prefixes.add((String)((Map.Entry)prefixesList.get(i)).getKey());
        }
        prefixes.add("");
        return prefixes;
    }

    private void mapPrefixes(List<String> keys, Collection<String> prefixes) {
        for (String key : keys) {
            for (String prefix : prefixes) {
                String matchKeyName = key.toLowerCase();
                if (!matchKeyName.startsWith(prefix)) continue;
                matchKeyName = matchKeyName.substring(prefix.length());
                if (Utility.isBlank(matchKeyName = Inflection.singularize(matchKeyName))) continue;
                this.keyPrefixes.add(key, matchKeyName);
            }
        }
    }
}

