/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.module;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PythonModule})
public final class ModuleBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ModuleBuiltinsSlotsGen.SLOTS;
    public static final TruffleString T__INITIALIZING = PythonUtils.tsLiteral("_initializing");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ModuleBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        public static final TruffleString T__MODULE_REPR = PythonUtils.tsLiteral("_module_repr");

        ReprNode() {
        }

        @Specialization
        Object repr(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Bind PythonContext context, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, context.getImportlib(), T__MODULE_REPR, self);
        }
    }

    @Builtin(name="__annotations__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    static abstract class AnnotationsNode
    extends PythonBinaryBuiltinNode {
        AnnotationsNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object get(Object self, Object value, @Bind Node inliningTarget, @Cached.Shared(value="read") @Cached ReadAttributeFromObjectNode read, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write, @Cached InlinedBranchProfile createAnnotations) {
            Object annotations = read.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == PNone.NO_VALUE) {
                createAnnotations.enter(inliningTarget);
                annotations = PFactory.createDict(PythonLanguage.get(inliningTarget));
                write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, annotations);
            }
            return annotations;
        }

        @Specialization(guards={"isDeleteMarker(value)"})
        static Object delete(Object self, Object value, @Bind Node inliningTarget, @Cached.Shared(value="read") @Cached ReadAttributeFromObjectNode read, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write, @Cached PRaiseNode raiseNode) {
            Object annotations = read.execute(self, SpecialAttributeNames.T___ANNOTATIONS__);
            if (annotations == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, new Object[]{SpecialAttributeNames.T___ANNOTATIONS__});
            }
            write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, PNone.NO_VALUE);
            return PNone.NONE;
        }

        @Fallback
        static Object set(Object self, Object value, @Cached.Shared(value="write") @Cached WriteAttributeToObjectNode write) {
            write.execute(self, SpecialAttributeNames.T___ANNOTATIONS__, value);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ModuleGetattributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @Specialization
        static Object getattributeStr(VirtualFrame frame, PythonModule self, TruffleString key, @Cached.Shared @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached.Shared @Cached HandleGetattrExceptionNode handleException) {
            try {
                return objectGetattrNode.execute(frame, self, key);
            }
            catch (PException e) {
                return handleException.execute(frame, self, key, e);
            }
        }

        @Specialization(replaces={"getattributeStr"})
        @HostCompilerDirectives.InliningCutoff
        static Object getattribute(VirtualFrame frame, PythonModule self, Object keyObj, @Bind Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castKeyToStringNode, @Cached.Shared @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached.Shared @Cached HandleGetattrExceptionNode handleException) {
            TruffleString key = castKeyToStringNode.cast(inliningTarget, keyObj, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            try {
                return objectGetattrNode.execute(frame, self, key);
            }
            catch (PException e) {
                return handleException.execute(frame, self, key, e);
            }
        }

        @Specialization(guards={"!isPythonModule(self)"})
        static Object getattribute(Object self, Object key, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___GETATTRIBUTE__, "module", self);
        }

        @GenerateInline(value=false)
        protected static abstract class HandleGetattrExceptionNode
        extends PNodeWithContext {
            protected HandleGetattrExceptionNode() {
            }

            public abstract Object execute(VirtualFrame var1, PythonModule var2, TruffleString var3, PException var4);

            @Specialization
            static Object getattribute(VirtualFrame frame, PythonModule self, TruffleString key, PException e, @Bind Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isAttrError, @Cached ReadAttributeFromObjectNode readGetattr, @Cached InlinedConditionProfile customGetAttr, @Cached CallNode callNode, @Cached PyObjectIsTrueNode castToBooleanNode, @Cached CastToTruffleStringNode castNameToStringNode, @Cached PRaiseNode raiseNode) {
                TruffleString moduleName;
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, isAttrError);
                Object getAttr = readGetattr.execute(self, SpecialMethodNames.T___GETATTR__);
                if (customGetAttr.profile(inliningTarget, getAttr != PNone.NO_VALUE)) {
                    return callNode.execute((Frame)frame, getAttr, key);
                }
                try {
                    moduleName = castNameToStringNode.execute(inliningTarget, readGetattr.execute(self, SpecialAttributeNames.T___NAME__));
                }
                catch (CannotCastException ce) {
                    moduleName = null;
                }
                if (moduleName != null) {
                    Object isInitializing;
                    Object moduleSpec = readGetattr.execute(self, SpecialAttributeNames.T___SPEC__);
                    if (moduleSpec != PNone.NO_VALUE && (isInitializing = readGetattr.execute(moduleSpec, T__INITIALIZING)) != PNone.NO_VALUE && castToBooleanNode.execute((Frame)frame, isInitializing)) {
                        throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.MODULE_PARTIALLY_INITIALIZED_S_HAS_NO_ATTR_S, moduleName, key);
                    }
                    throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.MODULE_S_HAS_NO_ATTR_S, moduleName, key);
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.AttributeError, ErrorMessages.MODULE_HAS_NO_ATTR_S, key);
            }
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true)
    @GenerateNodeFactory
    public static abstract class ModuleDictNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object doManaged(PythonModule self, PNone none, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached SetDictNode setDict) {
            PDict dict = getDict.execute(self);
            if (dict == null) {
                dict = ModuleDictNode.createDict(inliningTarget, self, setDict);
            }
            return dict;
        }

        @Specialization(guards={"isNoValue(none)"})
        static Object doNativeObject(PythonAbstractNativeObject self, PNone none, @Bind Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached PRaiseNode raiseNode) {
            PDict dict = getDict.execute(self);
            if (dict == null) {
                ModuleDictNode.doError(self, none, raiseNode);
            }
            return dict;
        }

        @Fallback
        static Object doError(Object self, Object dict, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_DICT_FOR_MOD_OBJ_DOES_NOT_APPLY_FOR_P, self);
        }

        private static PDict createDict(Node inliningTarget, PythonModule self, SetDictNode setDict) {
            PDict dict = PFactory.createDictFixedStorage(PythonLanguage.get(inliningTarget), self);
            setDict.execute(inliningTarget, self, dict);
            return dict;
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class ModuleDirNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object dir(VirtualFrame frame, PythonModule self, @Bind Node inliningTarget, @Cached PyDictGetItem pyDictGetItem, @Cached ListNodes.ConstructListNode constructListNode, @Cached CallNode callNode, @Cached PyObjectLookupAttr lookup, @Cached PRaiseNode raiseNode) {
            Object dictObj = lookup.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___DICT__);
            if (dictObj instanceof PDict) {
                PDict dict = (PDict)dictObj;
                Object dirFunc = pyDictGetItem.execute((Frame)frame, inliningTarget, dict, SpecialMethodNames.T___DIR__);
                if (dirFunc != null) {
                    return callNode.execute((Frame)frame, dirFunc, new Object[0]);
                }
                return constructListNode.execute((Frame)frame, dict);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_DICTIONARY, "<module>.__dict__");
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="module", minNumOfPositionalArgs=2, parameterNames={"self", "name", "doc"})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class ModuleNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ModuleBuiltinsClinicProviders.ModuleNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        public PNone module(PythonModule self, TruffleString name, Object doc, @Bind Node inliningTarget, @Cached WriteAttributeToObjectNode writeName, @Cached WriteAttributeToObjectNode writeDoc, @Cached WriteAttributeToObjectNode writePackage, @Cached WriteAttributeToObjectNode writeLoader, @Cached WriteAttributeToObjectNode writeSpec, @Cached GetOrCreateDictNode getDict) {
            getDict.execute(inliningTarget, self);
            writeName.execute(self, SpecialAttributeNames.T___NAME__, name);
            if (doc != PNone.NO_VALUE) {
                writeDoc.execute(self, SpecialAttributeNames.T___DOC__, doc);
            } else {
                writeDoc.execute(self, SpecialAttributeNames.T___DOC__, PNone.NONE);
            }
            writePackage.execute(self, SpecialAttributeNames.T___PACKAGE__, PNone.NONE);
            writeLoader.execute(self, SpecialAttributeNames.T___LOADER__, PNone.NONE);
            writeSpec.execute(self, SpecialAttributeNames.T___SPEC__, PNone.NONE);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="module", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ModuleNewNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doGeneric(Object cls, Object[] varargs, PKeyword[] kwargs, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createPythonModule(language, cls, getInstanceShape.execute(cls));
        }
    }
}

