/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.MethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.MethodBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMethod})
public final class MethodBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MethodBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MethodBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        @Specialization
        static PMethod doGeneric(PMethod self, Object obj, Object cls) {
            return self;
        }
    }

    @Builtin(name="__kwdefaults__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetMethodKwdefaultsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object kwDefaults(PMethod self, @Bind Node inliningTarget, @Cached FunctionNodes.GetKeywordDefaultsNode getKeywordDefaultsNode) {
            PKeyword[] kwdefaults = getKeywordDefaultsNode.execute(inliningTarget, self);
            return kwdefaults.length > 0 ? PFactory.createDict(PythonLanguage.get(inliningTarget), kwdefaults) : PNone.NONE;
        }
    }

    @Builtin(name="__defaults__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetMethodDefaultsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object defaults(PMethod self, @Bind Node inliningTarget, @Cached FunctionNodes.GetDefaultsNode getDefaultsNode) {
            Object[] argDefaults = getDefaultsNode.execute(inliningTarget, self);
            assert (argDefaults != null);
            return argDefaults.length == 0 ? PNone.NONE : PFactory.createTuple(PythonLanguage.get(inliningTarget), argDefaults);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString reprMethod(VirtualFrame frame, PMethod method, @Bind Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode repr, @Cached CastToTruffleStringNode toStringNode, @Cached PyObjectLookupAttr lookup, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object self = method.getSelf();
            Object func = method.getFunction();
            Object funcName = lookup.execute((Frame)frame, inliningTarget, func, SpecialAttributeNames.T___QUALNAME__);
            if (funcName == PNone.NO_VALUE) {
                funcName = lookup.execute((Frame)frame, inliningTarget, func, SpecialAttributeNames.T___NAME__);
            }
            try {
                return simpleTruffleStringFormatNode.format("<bound method %s of %s>", toStringNode.execute(inliningTarget, funcName), repr.execute((Frame)frame, inliningTarget, self));
            }
            catch (CannotCastException e) {
                return simpleTruffleStringFormatNode.format("<bound method ? of %s>", repr.execute((Frame)frame, inliningTarget, self));
            }
        }
    }

    @Slot(value=Slot.SlotKind.tp_getattro, isComplex=true)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    public static abstract class GetattributeNode
    extends TpSlotGetAttr.GetAttrBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, PMethod self, Object keyObj, @Bind Node inliningTarget, @Cached ObjectBuiltins.GetAttributeNode objectGetattrNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached PRaiseNode raiseNode) {
            TruffleString key;
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            try {
                return objectGetattrNode.execute(frame, self, key);
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, errorProfile);
                return objectGetattrNode.execute(frame, self.getFunction(), key);
            }
        }

        @Specialization(guards={"!isPMethod(self)"})
        @HostCompilerDirectives.InliningCutoff
        static Object getattribute(Object self, Object key, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___GETATTRIBUTE__, "method", self);
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class DictNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object doIt(PMethod self, @Bind Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self.getFunction());
        }
    }

    @Builtin(name="__code__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class CodeNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object doIt(VirtualFrame frame, PMethod self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getCode) {
            return getCode.execute((Frame)frame, inliningTarget, self.getFunction(), SpecialAttributeNames.T___CODE__);
        }
    }

    @Builtin(name="__func__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class FuncNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object doIt(PMethod self) {
            return self.getFunction();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="method", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class MethodTypeNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object method(Object cls, PFunction func, Object self, @Bind PythonLanguage language) {
            return PFactory.createMethod(language, self, func);
        }

        @Specialization
        static Object methodBuiltin(Object cls, PBuiltinFunction func, Object self, @Bind PythonLanguage language) {
            return PFactory.createMethod(language, self, func);
        }

        @Specialization
        static Object methodGeneric(Object cls, Object func, Object self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyCallableCheckNode callableCheck, @Cached PRaiseNode raiseNode) {
            if (callableCheck.execute(inliningTarget, func)) {
                return PFactory.createMethod(language, self, func);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.FIRST_ARG_MUST_BE_CALLABLE_S, "");
        }
    }
}

