/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.itertools.PPermutations;
import com.oracle.graal.python.builtins.objects.itertools.PermutationsBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.PermutationsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PermutationsBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PPermutations})
public final class PermutationsBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PermutationsBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PermutationsBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PPermutations self, Object state, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached InlinedLoopConditionProfile indicesProfile, @Cached InlinedLoopConditionProfile cyclesProfile, @Cached CastToJavaBooleanNode castBoolean, @Cached CastToJavaIntExactNode castInt, @Cached PRaiseNode raiseNode) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            try {
                int index;
                if (sizeNode.execute((Frame)frame, inliningTarget, state) != 3) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
                }
                Object indices = getItemNode.execute(frame, state, 0);
                Object cycles = getItemNode.execute(frame, state, 1);
                int poolLen = self.getPool().length;
                if (sizeNode.execute((Frame)frame, inliningTarget, indices) != poolLen || sizeNode.execute((Frame)frame, inliningTarget, cycles) != self.getR()) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
                }
                self.setStarted(castBoolean.execute(inliningTarget, getItemNode.execute(frame, state, 2)));
                indicesProfile.profileCounted(inliningTarget, (long)poolLen);
                int i = 0;
                while (indicesProfile.inject(inliningTarget, i < poolLen)) {
                    index = castInt.execute(inliningTarget, getItemNode.execute(frame, indices, i));
                    if (index < 0) {
                        index = 0;
                    } else if (index > poolLen - 1) {
                        index = poolLen - 1;
                    }
                    self.getIndices()[i] = index;
                    ++i;
                }
                cyclesProfile.profileCounted(inliningTarget, (long)self.getR());
                i = 0;
                while (cyclesProfile.inject(inliningTarget, i < self.getR())) {
                    index = castInt.execute(inliningTarget, getItemNode.execute(frame, cycles, i));
                    if (index < 1) {
                        index = 1;
                    } else if (index > poolLen - i) {
                        index = poolLen - 1;
                    }
                    self.getCycles()[i] = index;
                    ++i;
                }
                return PNone.NONE;
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"!self.isRaisedStopIteration()"})
        static Object reduce(PPermutations self, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            PList poolList = PFactory.createList(language, self.getPool());
            PTuple tuple = PFactory.createTuple(language, new Object[]{poolList, self.getR()});
            PTuple indicesTuple = PFactory.createTuple(language, self.getIndices());
            PTuple cyclesTuple = PFactory.createTuple(language, self.getCycles());
            PTuple tuple2 = PFactory.createTuple(language, new Object[]{indicesTuple, cyclesTuple, self.isStarted()});
            Object[] result = new Object[]{type, tuple, tuple2};
            return PFactory.createTuple(language, result);
        }

        @Specialization(guards={"self.isRaisedStopIteration()"})
        static Object reduceStopped(PPermutations self, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, new Object[]{PFactory.createEmptyTuple(language), self.getR()});
            Object[] result = new Object[]{type, tuple};
            return PFactory.createTuple(language, result);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"self.isStopped()"})
        static Object next(PPermutations self) {
            self.setRaisedStopIteration(true);
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!self.isStopped()"})
        static Object next(PPermutations self, @Bind Node inliningTarget, @Cached InlinedConditionProfile isStartedProfile, @Cached InlinedBranchProfile jProfile, @Cached InlinedLoopConditionProfile resultLoopProfile, @Cached InlinedLoopConditionProfile mainLoopProfile, @Cached InlinedLoopConditionProfile shiftIndicesProfile, @Bind PythonLanguage language) {
            int r = self.getR();
            int[] indices = self.getIndices();
            Object[] result = new Object[r];
            Object[] pool = self.getPool();
            resultLoopProfile.profileCounted(inliningTarget, (long)r);
            int i = 0;
            while (resultLoopProfile.inject(inliningTarget, i < r)) {
                result[i] = pool[indices[i]];
                ++i;
            }
            int[] cycles = self.getCycles();
            int i2 = r - 1;
            while (mainLoopProfile.profile(inliningTarget, i2 >= 0)) {
                int j = cycles[i2] - 1;
                if (j > 0) {
                    jProfile.enter(inliningTarget);
                    cycles[i2] = j;
                    int tmp = indices[i2];
                    indices[i2] = indices[indices.length - j];
                    indices[indices.length - j] = tmp;
                    return PFactory.createTuple(language, result);
                }
                cycles[i2] = indices.length - i2;
                int n1 = indices.length - 1;
                assert (n1 >= 0);
                int num = indices[i2];
                shiftIndicesProfile.profileCounted(inliningTarget, (long)(n1 - i2));
                int k = i2;
                while (shiftIndicesProfile.profile(inliningTarget, k < n1)) {
                    indices[k] = indices[k + 1];
                    ++k;
                }
                indices[n1] = num;
                --i2;
            }
            self.setStopped(true);
            if (isStartedProfile.profile(inliningTarget, self.isStarted())) {
                throw NextNode.iteratorExhausted();
            }
            self.setStarted(true);
            return PFactory.createTuple(language, result);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PPermutations self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="permutations", minNumOfPositionalArgs=2, parameterNames={"cls", "iterable", "r"})
    @ArgumentClinic(name="r", defaultValue="PNone.NONE")
    @GenerateNodeFactory
    public static abstract class PermutationsNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return PermutationsBuiltinsClinicProviders.PermutationsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object construct(VirtualFrame frame, Object cls, Object iterable, Object rArg, @Bind Node inliningTarget, @Cached InlinedConditionProfile rIsNoneProfile, @Cached IteratorNodes.ToArrayNode toArrayNode, @Cached CastToJavaIntExactNode castToInt, @Cached InlinedConditionProfile wrongTypeProfile, @Cached InlinedBranchProfile wrongRprofile, @Cached InlinedBranchProfile negRprofile, @Cached InlinedConditionProfile nrProfile, @Cached InlinedLoopConditionProfile indicesLoopProfile, @Cached InlinedLoopConditionProfile cyclesLoopProfile, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            int r;
            if (!wrongTypeProfile.profile(inliningTarget, isTypeNode.execute(inliningTarget, cls))) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            Object[] pool = toArrayNode.execute(frame, iterable);
            if (rIsNoneProfile.profile(inliningTarget, PGuards.isNone(rArg))) {
                r = pool.length;
            } else {
                try {
                    r = castToInt.execute(inliningTarget, rArg);
                }
                catch (CannotCastException e) {
                    wrongRprofile.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_INT_AS_R);
                }
                if (r < 0) {
                    negRprofile.enter(inliningTarget);
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE, "r");
                }
            }
            PPermutations self = PFactory.createPermutations(language, cls, getInstanceShape.execute(cls));
            self.setPool(pool);
            self.setR(r);
            int n = pool.length;
            self.setN(n);
            int nMinusR = n - r;
            if (!nrProfile.profile(inliningTarget, nMinusR < 0)) {
                self.setStopped(false);
                int[] indices = new int[n];
                indicesLoopProfile.profileCounted(inliningTarget, (long)indices.length);
                LoopNode.reportLoopCount((Node)inliningTarget, (int)indices.length);
                int i = 0;
                while (indicesLoopProfile.inject(inliningTarget, i < indices.length)) {
                    indices[i] = i;
                    ++i;
                }
                self.setIndices(indices);
                int[] cycles = new int[r];
                int idx = 0;
                cyclesLoopProfile.profileCounted(inliningTarget, (long)r);
                LoopNode.reportLoopCount((Node)inliningTarget, (int)r);
                int i2 = n;
                while (cyclesLoopProfile.inject(inliningTarget, i2 > nMinusR)) {
                    cycles[idx++] = i2--;
                }
                self.setCycles(cycles);
                self.setRaisedStopIteration(false);
                self.setStarted(false);
                return self;
            }
            self.setStopped(true);
            self.setRaisedStopIteration(true);
            return self;
        }
    }
}

