# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Scenario message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class Scenario < Message
      ##
      # The location of the `Scenario` keyword
      ##
      attr_reader :location

      attr_reader :tags

      attr_reader :keyword

      attr_reader :name

      attr_reader :description

      attr_reader :steps

      attr_reader :examples

      attr_reader :id

      def initialize(
        location: Location.new,
        tags: [],
        keyword: '',
        name: '',
        description: '',
        steps: [],
        examples: [],
        id: ''
      )
        @location = location
        @tags = tags
        @keyword = keyword
        @name = name
        @description = description
        @steps = steps
        @examples = examples
        @id = id
        super()
      end

      ##
      # Returns a new Scenario from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Scenario.from_h(some_hash) # => #<Cucumber::Messages::Scenario:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          location: Location.from_h(hash[:location]),
          tags: hash[:tags]&.map { |item| Tag.from_h(item) },
          keyword: hash[:keyword],
          name: hash[:name],
          description: hash[:description],
          steps: hash[:steps]&.map { |item| Step.from_h(item) },
          examples: hash[:examples]&.map { |item| Examples.from_h(item) },
          id: hash[:id]
        )
      end
    end
  end
end
