/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.Extension;
import org.scilab.forge.jlatexmath.Metrics;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.VerticalBox;

public class DelimiterFactory {
    public static Box create(SymbolAtom symbol, TeXEnvironment env, int size) {
        int i;
        if (size > 4) {
            return symbol.createBox(env);
        }
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Char c = tf.getChar(symbol.getName(), style);
        for (i = 1; i <= size && tf.hasNextLarger(c); ++i) {
            c = tf.getNextLarger(c, style);
        }
        if (i <= size && !tf.hasNextLarger(c)) {
            CharBox A2 = new CharBox(tf.getChar('A', "mathnormal", style));
            Box b = DelimiterFactory.create(symbol.getName(), env, (float)size * (A2.getHeight() + A2.getDepth()));
            return b;
        }
        return new CharBox(c);
    }

    public static Box create(String symbol, TeXEnvironment env, float minHeight) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Char c = tf.getChar(symbol, style);
        Metrics m4 = c.getMetrics();
        float total = m4.getHeight() + m4.getDepth();
        while (total < minHeight && tf.hasNextLarger(c)) {
            c = tf.getNextLarger(c, style);
            m4 = c.getMetrics();
            total = m4.getHeight() + m4.getDepth();
        }
        if (total >= minHeight) {
            return new CharBox(c);
        }
        if (tf.isExtensionChar(c)) {
            boolean middle;
            VerticalBox vBox = new VerticalBox();
            Extension ext = tf.getExtension(c, style);
            if (ext.hasTop()) {
                c = ext.getTop();
                vBox.add(new CharBox(c));
            }
            if (middle = ext.hasMiddle()) {
                c = ext.getMiddle();
                vBox.add(new CharBox(c));
            }
            if (ext.hasBottom()) {
                c = ext.getBottom();
                vBox.add(new CharBox(c));
            }
            c = ext.getRepeat();
            CharBox rep = new CharBox(c);
            while (vBox.getHeight() + vBox.getDepth() <= minHeight) {
                if (ext.hasTop() && ext.hasBottom()) {
                    vBox.add(1, rep);
                    if (!middle) continue;
                    vBox.add(vBox.getSize() - 1, rep);
                    continue;
                }
                if (ext.hasBottom()) {
                    vBox.add(0, rep);
                    continue;
                }
                vBox.add(rep);
            }
            return vBox;
        }
        return new CharBox(c);
    }
}

