/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentDependency;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.BaseRoutingDirectionStrategy;
import org.eclipse.elk.core.util.Pair;

public class HyperEdgeSegment
implements Comparable<HyperEdgeSegment> {
    private final BaseRoutingDirectionStrategy routingStrategy;
    private final List<LPort> ports = Lists.newArrayList();
    int mark;
    private int routingSlot;
    private double startPosition = Double.NaN;
    private double endPosition = Double.NaN;
    private final LinkedList<Double> incomingConnectionCoordinates = Lists.newLinkedList();
    private final LinkedList<Double> outgoingConnectionCoordinates = Lists.newLinkedList();
    private final List<HyperEdgeSegmentDependency> outgoingSegmentDependencies = Lists.newArrayList();
    private int outDepWeight;
    private int criticalOutDepWeight;
    private final List<HyperEdgeSegmentDependency> incomingSegmentDependencies = Lists.newArrayList();
    private int inDepWeight;
    private int criticalInDepWeight;
    private HyperEdgeSegment splitPartner;
    private HyperEdgeSegment splitBy;

    public HyperEdgeSegment(BaseRoutingDirectionStrategy routingStrategy) {
        this.routingStrategy = routingStrategy;
    }

    public void addPortPositions(LPort port, Map<LPort, HyperEdgeSegment> hyperEdgeSegmentMap) {
        hyperEdgeSegmentMap.put(port, this);
        this.ports.add(port);
        double portPos = this.routingStrategy.getPortPositionOnHyperNode(port);
        if (port.getSide() == this.routingStrategy.getSourcePortSide()) {
            HyperEdgeSegment.insertSorted(this.incomingConnectionCoordinates, portPos);
        } else {
            HyperEdgeSegment.insertSorted(this.outgoingConnectionCoordinates, portPos);
        }
        this.recomputeExtent();
        for (LPort otherPort : port.getConnectedPorts()) {
            if (hyperEdgeSegmentMap.containsKey(otherPort)) continue;
            this.addPortPositions(otherPort, hyperEdgeSegmentMap);
        }
    }

    private static void insertSorted(List<Double> list, double value) {
        ListIterator<Double> listIter = list.listIterator();
        while (listIter.hasNext()) {
            double next = listIter.next().floatValue();
            if (next == value) {
                return;
            }
            if (!(next > value)) continue;
            listIter.previous();
            break;
        }
        listIter.add(value);
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    public int getRoutingSlot() {
        return this.routingSlot;
    }

    public void setRoutingSlot(int slot) {
        this.routingSlot = slot;
    }

    public double getStartCoordinate() {
        return this.startPosition;
    }

    public double getEndCoordinate() {
        return this.endPosition;
    }

    public LinkedList<Double> getIncomingConnectionCoordinates() {
        return this.incomingConnectionCoordinates;
    }

    public LinkedList<Double> getOutgoingConnectionCoordinates() {
        return this.outgoingConnectionCoordinates;
    }

    public List<HyperEdgeSegmentDependency> getOutgoingSegmentDependencies() {
        return this.outgoingSegmentDependencies;
    }

    public int getOutWeight() {
        return this.outDepWeight;
    }

    public void setOutWeight(int outWeight) {
        this.outDepWeight = outWeight;
    }

    public int getCriticalOutWeight() {
        return this.criticalOutDepWeight;
    }

    public void setCriticalOutWeight(int outWeight) {
        this.criticalOutDepWeight = outWeight;
    }

    public List<HyperEdgeSegmentDependency> getIncomingSegmentDependencies() {
        return this.incomingSegmentDependencies;
    }

    public int getInWeight() {
        return this.inDepWeight;
    }

    public void setInWeight(int inWeight) {
        this.inDepWeight = inWeight;
    }

    public int getCriticalInWeight() {
        return this.criticalInDepWeight;
    }

    public void setCriticalInWeight(int inWeight) {
        this.criticalInDepWeight = inWeight;
    }

    public HyperEdgeSegment getSplitPartner() {
        return this.splitPartner;
    }

    public void setSplitPartner(HyperEdgeSegment splitPartner) {
        this.splitPartner = splitPartner;
    }

    public HyperEdgeSegment getSplitBy() {
        return this.splitBy;
    }

    public void setSplitBy(HyperEdgeSegment splitBy) {
        this.splitBy = splitBy;
    }

    public double getLength() {
        return this.getEndCoordinate() - this.getStartCoordinate();
    }

    public boolean representsHyperedge() {
        return this.getIncomingConnectionCoordinates().size() + this.getOutgoingConnectionCoordinates().size() > 2;
    }

    public boolean isDummy() {
        return this.splitPartner != null && this.splitBy == null;
    }

    public void recomputeExtent() {
        this.startPosition = Double.NaN;
        this.endPosition = Double.NaN;
        this.recomputeExtent(this.incomingConnectionCoordinates);
        this.recomputeExtent(this.outgoingConnectionCoordinates);
    }

    private void recomputeExtent(LinkedList<Double> positions) {
        if (!positions.isEmpty()) {
            this.startPosition = Double.isNaN(this.startPosition) ? positions.getFirst() : Math.min(this.startPosition, positions.getFirst());
            this.endPosition = Double.isNaN(this.endPosition) ? positions.getLast() : Math.max(this.endPosition, positions.getLast());
        }
    }

    public Pair<HyperEdgeSegment, HyperEdgeSegment> simulateSplit() {
        HyperEdgeSegment newSplit = new HyperEdgeSegment(this.routingStrategy);
        HyperEdgeSegment newSplitPartner = new HyperEdgeSegment(this.routingStrategy);
        newSplit.incomingConnectionCoordinates.addAll(this.incomingConnectionCoordinates);
        newSplit.splitBy = this.splitBy;
        newSplit.splitPartner = newSplitPartner;
        newSplit.recomputeExtent();
        newSplitPartner.outgoingConnectionCoordinates.addAll(this.outgoingConnectionCoordinates);
        newSplitPartner.splitPartner = newSplit;
        newSplitPartner.recomputeExtent();
        return Pair.of(newSplit, newSplitPartner);
    }

    public HyperEdgeSegment splitAt(double splitPosition) {
        this.splitPartner = new HyperEdgeSegment(this.routingStrategy);
        this.splitPartner.setSplitPartner(this);
        this.splitPartner.outgoingConnectionCoordinates.addAll(this.outgoingConnectionCoordinates);
        this.outgoingConnectionCoordinates.clear();
        this.outgoingConnectionCoordinates.add(splitPosition);
        this.splitPartner.incomingConnectionCoordinates.add(splitPosition);
        this.recomputeExtent();
        this.splitPartner.recomputeExtent();
        while (!this.incomingSegmentDependencies.isEmpty()) {
            this.incomingSegmentDependencies.get(0).remove();
        }
        while (!this.outgoingSegmentDependencies.isEmpty()) {
            this.outgoingSegmentDependencies.get(0).remove();
        }
        return this.splitPartner;
    }

    @Override
    public int compareTo(HyperEdgeSegment other) {
        return this.mark - other.mark;
    }

    public boolean equals(Object object) {
        if (object instanceof HyperEdgeSegment) {
            HyperEdgeSegment other = (HyperEdgeSegment)object;
            return this.mark == other.mark;
        }
        return false;
    }

    public int hashCode() {
        return this.mark;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator<LPort> portIter = this.ports.iterator();
        while (portIter.hasNext()) {
            LPort port = portIter.next();
            String name = port.getNode().getDesignation();
            if (name == null) {
                name = "n" + port.getNode().getIndex();
            }
            builder.append(name);
            if (!portIter.hasNext()) continue;
            builder.append(',');
        }
        builder.append('}');
        return builder.toString();
    }
}

