/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.common.nodespacing.NodeDimensionCalculation;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphAdapters;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.OrthogonalRoutingGenerator;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.RoutingDirection;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class HierarchicalPortOrthogonalEdgeRouter
implements ILayoutProcessor<LGraph> {
    private double northernExtPortEdgeRoutingHeight;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Orthogonally routing hierarchical port edges", 1.0f);
        this.northernExtPortEdgeRoutingHeight = 0.0;
        List<LNode> northSouthDummies = this.restoreNorthSouthDummies(layeredGraph);
        this.setNorthSouthDummyCoordinates(layeredGraph, northSouthDummies);
        this.routeEdges(monitor, layeredGraph, northSouthDummies);
        this.removeTemporaryNorthSouthDummies(layeredGraph);
        this.fixCoordinates(layeredGraph);
        this.correctSlantedEdgeSegments(layeredGraph);
        monitor.done();
    }

    private List<LNode> restoreNorthSouthDummies(LGraph layeredGraph) {
        ArrayList<LNode> restoredDummies = Lists.newArrayList();
        if (!layeredGraph.hasProperty(InternalProperties.EXT_PORT_REPLACED_DUMMIES)) {
            return restoredDummies;
        }
        for (LNode dummy : layeredGraph.getProperty(InternalProperties.EXT_PORT_REPLACED_DUMMIES)) {
            this.restoreDummy(dummy, layeredGraph);
            restoredDummies.add(dummy);
        }
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LNode replacedDummy;
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT || (replacedDummy = node.getProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY)) == null) continue;
                assert (replacedDummy.getType() == LNode.NodeType.EXTERNAL_PORT);
                this.connectNodeToDummy(layeredGraph, node, replacedDummy);
            }
        }
        for (LNode dummy : restoredDummies) {
            dummy.setLayer(layeredGraph.getLayers().get(layeredGraph.getLayers().size() - 1));
        }
        return restoredDummies;
    }

    private void restoreDummy(LNode dummy, LGraph graph) {
        PortSide portSide = dummy.getProperty(InternalProperties.EXT_PORT_SIDE);
        LPort dummyPort = dummy.getPorts().get(0);
        if (portSide == PortSide.NORTH) {
            dummyPort.setSide(PortSide.SOUTH);
        } else if (portSide == PortSide.SOUTH) {
            dummyPort.setSide(PortSide.NORTH);
        }
        if (graph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS).contains((Object)SizeConstraint.PORT_LABELS)) {
            double portLabelSpacingHorizontal = dummy.getProperty(LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL);
            double portLabelSpacingVertical = dummy.getProperty(LayeredOptions.SPACING_LABEL_PORT_VERTICAL);
            double labelLabelSpacing = dummy.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
            Set portLabelPlacement = graph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT);
            if (portLabelPlacement.contains((Object)PortLabelPlacement.INSIDE)) {
                double currentY = portLabelSpacingVertical;
                double xCenterRelativeToPort = dummy.getSize().x / 2.0 - dummyPort.getPosition().x;
                for (LLabel label : dummyPort.getLabels()) {
                    label.getPosition().y = currentY;
                    label.getPosition().x = xCenterRelativeToPort - label.getSize().x / 2.0;
                    currentY += label.getSize().y + labelLabelSpacing;
                }
            } else if (portLabelPlacement.contains((Object)PortLabelPlacement.OUTSIDE)) {
                for (LLabel label : dummyPort.getLabels()) {
                    label.getPosition().x = portLabelSpacingHorizontal + dummy.getSize().x - dummyPort.getPosition().x;
                }
            }
            NodeDimensionCalculation.getNodeMarginCalculator(LGraphAdapters.adapt(graph, false)).processNode(LGraphAdapters.adapt(dummy, false));
        }
    }

    private void connectNodeToDummy(LGraph layeredGraph, LNode node, LNode dummy) {
        LPort outPort = new LPort();
        outPort.setNode(node);
        PortSide extPortSide = node.getProperty(InternalProperties.EXT_PORT_SIDE);
        outPort.setSide(extPortSide);
        LPort inPort = dummy.getPorts().get(0);
        LEdge edge = new LEdge();
        edge.setSource(outPort);
        edge.setTarget(inPort);
    }

    private void setNorthSouthDummyCoordinates(LGraph layeredGraph, List<LNode> northSouthDummies) {
        PortConstraints constraints = layeredGraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        KVector graphSize = layeredGraph.getSize();
        LPadding graphPadding = layeredGraph.getPadding();
        double graphWidth = graphSize.x + graphPadding.left + graphPadding.right;
        double northY = 0.0 - graphPadding.top - layeredGraph.getOffset().y;
        double southY = graphSize.y + graphPadding.top + graphPadding.bottom - layeredGraph.getOffset().y;
        ArrayList<LNode> northernDummies = Lists.newArrayList();
        ArrayList<LNode> southernDummies = Lists.newArrayList();
        for (LNode dummy : northSouthDummies) {
            switch (constraints) {
                case FREE: 
                case FIXED_SIDE: 
                case FIXED_ORDER: {
                    this.calculateNorthSouthDummyPositions(dummy);
                    break;
                }
                case FIXED_RATIO: {
                    this.applyNorthSouthDummyRatio(dummy, graphWidth);
                    dummy.borderToContentAreaCoordinates(true, false);
                    break;
                }
                case FIXED_POS: {
                    this.applyNorthSouthDummyPosition(dummy);
                    dummy.borderToContentAreaCoordinates(true, false);
                    graphSize.x = Math.max(graphSize.x, dummy.getPosition().x + dummy.getSize().x / 2.0);
                }
            }
            switch (dummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case NORTH: {
                    dummy.getPosition().y = northY;
                    northernDummies.add(dummy);
                    break;
                }
                case SOUTH: {
                    dummy.getPosition().y = southY;
                    southernDummies.add(dummy);
                }
            }
        }
        switch (constraints) {
            case FREE: 
            case FIXED_SIDE: {
                this.ensureUniquePositions(northernDummies, layeredGraph);
                this.ensureUniquePositions(southernDummies, layeredGraph);
                break;
            }
            case FIXED_ORDER: {
                this.restoreProperOrder(northernDummies, layeredGraph);
                this.restoreProperOrder(southernDummies, layeredGraph);
            }
        }
    }

    private void calculateNorthSouthDummyPositions(LNode dummy) {
        LPort dummyInPort = dummy.getPorts().get(0);
        if (dummyInPort.getDegree() == 0) {
            dummy.getPosition().x = 0.0;
        } else {
            double posSum = 0.0;
            for (LPort connectedPort : dummyInPort.getConnectedPorts()) {
                posSum += connectedPort.getNode().getPosition().x + connectedPort.getPosition().x + connectedPort.getAnchor().x;
            }
            KVector anchor = dummy.getProperty(LayeredOptions.PORT_ANCHOR);
            double offset = anchor == null ? 0.0 : anchor.x;
            dummy.getPosition().x = posSum / (double)dummyInPort.getDegree() - offset;
        }
    }

    private void applyNorthSouthDummyRatio(LNode dummy, double width) {
        KVector anchor = dummy.getProperty(LayeredOptions.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = width * dummy.getProperty(InternalProperties.PORT_RATIO_OR_POSITION) - offset;
    }

    private void applyNorthSouthDummyPosition(LNode dummy) {
        KVector anchor = dummy.getProperty(LayeredOptions.PORT_ANCHOR);
        double offset = anchor == null ? 0.0 : anchor.x;
        dummy.getPosition().x = dummy.getProperty(InternalProperties.PORT_RATIO_OR_POSITION) - offset;
    }

    private void ensureUniquePositions(List<LNode> dummies, LGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = LGraphUtil.toNodeArray(dummies);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                return Double.compare(a.getPosition().x, b.getPosition().x);
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void restoreProperOrder(List<LNode> dummies, LGraph graph) {
        if (dummies.isEmpty()) {
            return;
        }
        LNode[] dummyArray = LGraphUtil.toNodeArray(dummies);
        Arrays.sort(dummyArray, new Comparator<LNode>(){

            @Override
            public int compare(LNode a, LNode b) {
                return Double.compare(a.getProperty(InternalProperties.PORT_RATIO_OR_POSITION), b.getProperty(InternalProperties.PORT_RATIO_OR_POSITION));
            }
        });
        this.assignAscendingCoordinates(dummyArray, graph);
    }

    private void assignAscendingCoordinates(LNode[] dummies, LGraph graph) {
        double spacing = graph.getProperty(LayeredOptions.SPACING_PORT_PORT);
        double nextValidCoordinate = dummies[0].getPosition().x + dummies[0].getSize().x + dummies[0].getMargin().right + spacing;
        int index = 1;
        while (index < dummies.length) {
            KVector currentPosition = dummies[index].getPosition();
            KVector currentSize = dummies[index].getSize();
            LMargin currentMargin = dummies[index].getMargin();
            double delta = currentPosition.x - currentMargin.left - nextValidCoordinate;
            if (delta < 0.0) {
                currentPosition.x -= delta;
            }
            KVector graphSize = graph.getSize();
            graphSize.x = Math.max(graphSize.x, currentPosition.x + currentSize.x);
            nextValidCoordinate = currentPosition.x + currentSize.x + currentMargin.right + spacing;
            ++index;
        }
    }

    private void routeEdges(IElkProgressMonitor monitor, LGraph layeredGraph, Iterable<LNode> northSouthDummies) {
        OrthogonalRoutingGenerator routingGenerator;
        int slots;
        LinkedHashSet<LNode> northernSourceLayer = Sets.newLinkedHashSet();
        LinkedHashSet<LNode> northernTargetLayer = Sets.newLinkedHashSet();
        LinkedHashSet<LNode> southernSourceLayer = Sets.newLinkedHashSet();
        LinkedHashSet<LNode> southernTargetLayer = Sets.newLinkedHashSet();
        double nodeSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        double edgeSpacing = layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        for (LNode hierarchicalPortDummy : northSouthDummies) {
            PortSide portSide = hierarchicalPortDummy.getProperty(InternalProperties.EXT_PORT_SIDE);
            if (portSide == PortSide.NORTH) {
                northernTargetLayer.add(hierarchicalPortDummy);
                for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                    northernSourceLayer.add(edge.getSource().getNode());
                }
                continue;
            }
            if (portSide != PortSide.SOUTH) continue;
            southernTargetLayer.add(hierarchicalPortDummy);
            for (LEdge edge : hierarchicalPortDummy.getIncomingEdges()) {
                southernSourceLayer.add(edge.getSource().getNode());
            }
        }
        if (!northernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(RoutingDirection.SOUTH_TO_NORTH, edgeSpacing, "extnorth")).routeEdges(monitor, layeredGraph, northernSourceLayer, 0, northernTargetLayer, -nodeSpacing - layeredGraph.getOffset().y)) > 0) {
            this.northernExtPortEdgeRoutingHeight = nodeSpacing + (double)(slots - 1) * edgeSpacing;
            layeredGraph.getOffset().y += this.northernExtPortEdgeRoutingHeight;
            layeredGraph.getSize().y += this.northernExtPortEdgeRoutingHeight;
        }
        if (!southernSourceLayer.isEmpty() && (slots = (routingGenerator = new OrthogonalRoutingGenerator(RoutingDirection.NORTH_TO_SOUTH, edgeSpacing, "extsouth")).routeEdges(monitor, layeredGraph, southernSourceLayer, 0, southernTargetLayer, layeredGraph.getSize().y + nodeSpacing - layeredGraph.getOffset().y)) > 0) {
            layeredGraph.getSize().y += nodeSpacing + (double)(slots - 1) * edgeSpacing;
        }
    }

    private void removeTemporaryNorthSouthDummies(LGraph layeredGraph) {
        ArrayList<LNode> nodesToRemove = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                LEdge edge;
                LEdge[] edges;
                if (node.getType() != LNode.NodeType.EXTERNAL_PORT || !node.hasProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY)) continue;
                LPort nodeInPort = null;
                LPort nodeOutPort = null;
                LPort nodeOriginPort = null;
                for (LPort port : node.getPorts()) {
                    switch (port.getSide()) {
                        case WEST: {
                            nodeInPort = port;
                            break;
                        }
                        case EAST: {
                            nodeOutPort = port;
                            break;
                        }
                        default: {
                            nodeOriginPort = port;
                        }
                    }
                }
                LEdge nodeToOriginEdge = nodeOriginPort.getOutgoingEdges().get(0);
                KVectorChain incomingEdgeBendPoints = new KVectorChain(nodeToOriginEdge.getBendPoints());
                KVector firstBendPoint = new KVector(nodeOriginPort.getPosition());
                firstBendPoint.add(node.getPosition());
                incomingEdgeBendPoints.add(0, firstBendPoint);
                KVectorChain outgoingEdgeBendPoints = KVectorChain.reverse(nodeToOriginEdge.getBendPoints());
                KVector lastBendPoint = new KVector(nodeOriginPort.getPosition());
                lastBendPoint.add(node.getPosition());
                outgoingEdgeBendPoints.add(lastBendPoint);
                LNode replacedDummy = node.getProperty(InternalProperties.EXT_PORT_REPLACED_DUMMY);
                LPort replacedDummyPort = replacedDummy.getPorts().get(0);
                LEdge[] lEdgeArray = edges = nodeInPort.getIncomingEdges().toArray(new LEdge[0]);
                int n = edges.length;
                int n2 = 0;
                while (n2 < n) {
                    edge = lEdgeArray[n2];
                    edge.setTarget(replacedDummyPort);
                    edge.getBendPoints().addAllAsCopies(edge.getBendPoints().size(), incomingEdgeBendPoints);
                    ++n2;
                }
                lEdgeArray = edges = LGraphUtil.toEdgeArray(nodeOutPort.getOutgoingEdges());
                n = edges.length;
                n2 = 0;
                while (n2 < n) {
                    edge = lEdgeArray[n2];
                    edge.setSource(replacedDummyPort);
                    edge.getBendPoints().addAllAsCopies(0, outgoingEdgeBendPoints);
                    ++n2;
                }
                nodeToOriginEdge.setSource(null);
                nodeToOriginEdge.setTarget(null);
                nodesToRemove.add(node);
            }
        }
        for (LNode node : nodesToRemove) {
            node.setLayer(null);
        }
    }

    private void fixCoordinates(LGraph layeredGraph) {
        PortConstraints constraints = layeredGraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        List<Layer> layers = layeredGraph.getLayers();
        this.fixCoordinates(layers.get(0), constraints, layeredGraph);
        this.fixCoordinates(layers.get(layers.size() - 1), constraints, layeredGraph);
    }

    private void fixCoordinates(Layer layer, PortConstraints constraints, LGraph graph) {
        PortSide extPortSide;
        LPadding padding = graph.getPadding();
        KVector offset = graph.getOffset();
        KVector graphActualSize = graph.getActualSize();
        double newActualGraphHeight = graphActualSize.y;
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
            extPortSide = node.getProperty(InternalProperties.EXT_PORT_SIDE);
            KVector extPortSize = node.getProperty(InternalProperties.EXT_PORT_SIZE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case EAST: {
                    nodePosition.x = graph.getSize().x + padding.right - offset.x;
                    break;
                }
                case WEST: {
                    nodePosition.x = -offset.x - padding.left;
                }
            }
            double requiredActualGraphHeight = 0.0;
            switch (extPortSide) {
                case EAST: 
                case WEST: {
                    if (constraints == PortConstraints.FIXED_RATIO) {
                        double ratio = node.getProperty(InternalProperties.PORT_RATIO_OR_POSITION);
                        nodePosition.y = graphActualSize.y * ratio - node.getProperty(LayeredOptions.PORT_ANCHOR).y;
                        requiredActualGraphHeight = nodePosition.y + extPortSize.y;
                        node.borderToContentAreaCoordinates(false, true);
                        break;
                    }
                    if (constraints != PortConstraints.FIXED_POS) break;
                    nodePosition.y = node.getProperty(InternalProperties.PORT_RATIO_OR_POSITION) - node.getProperty(LayeredOptions.PORT_ANCHOR).y;
                    requiredActualGraphHeight = nodePosition.y + extPortSize.y;
                    node.borderToContentAreaCoordinates(false, true);
                }
            }
            newActualGraphHeight = Math.max(newActualGraphHeight, requiredActualGraphHeight);
        }
        graph.getSize().y += newActualGraphHeight - graphActualSize.y;
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT) continue;
            extPortSide = node.getProperty(InternalProperties.EXT_PORT_SIDE);
            KVector nodePosition = node.getPosition();
            switch (extPortSide) {
                case NORTH: {
                    nodePosition.y = -offset.y - padding.top;
                    break;
                }
                case SOUTH: {
                    nodePosition.y = graph.getSize().y + padding.bottom - offset.y;
                }
            }
        }
    }

    private void correctSlantedEdgeSegments(LGraph layeredGraph) {
        List<Layer> layers = layeredGraph.getLayers();
        this.correctSlantedEdgeSegments(layers.get(0));
        this.correctSlantedEdgeSegments(layers.get(layers.size() - 1));
    }

    private void correctSlantedEdgeSegments(Layer layer) {
        for (LNode node : layer) {
            PortSide extPortSide;
            if (node.getType() != LNode.NodeType.EXTERNAL_PORT || (extPortSide = node.getProperty(InternalProperties.EXT_PORT_SIDE)) != PortSide.EAST && extPortSide != PortSide.WEST) continue;
            for (LEdge edge : node.getConnectedEdges()) {
                LPort targetPort;
                KVectorChain bendPoints = edge.getBendPoints();
                if (bendPoints.isEmpty()) continue;
                LPort sourcePort = edge.getSource();
                if (sourcePort.getNode() == node) {
                    KVector firstBendPoint = (KVector)bendPoints.getFirst();
                    firstBendPoint.y = sourcePort.getAbsoluteAnchor().y;
                }
                if ((targetPort = edge.getTarget()).getNode() != node) continue;
                KVector lastBendPoint = (KVector)bendPoints.getLast();
                lastBendPoint.y = targetPort.getAbsoluteAnchor().y;
            }
        }
    }
}

