/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import java.util.Collection;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.EdgeConstraint;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InLayerConstraint;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.Alignment;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public final class LGraphUtil {
    private LGraphUtil() {
    }

    public static LNode[] toNodeArray(Collection<LNode> nodes) {
        return nodes.toArray(new LNode[nodes.size()]);
    }

    public static LEdge[] toEdgeArray(Collection<LEdge> edges) {
        return edges.toArray(new LEdge[edges.size()]);
    }

    public static LPort[] toPortArray(Collection<LPort> ports) {
        return ports.toArray(new LPort[ports.size()]);
    }

    public static void resizeNode(LNode node, KVector newSize, boolean movePorts, boolean moveLabels) {
        KVector oldSize = new KVector(node.getSize());
        float widthRatio = (float)(newSize.x / oldSize.x);
        float heightRatio = (float)(newSize.y / oldSize.y);
        float widthDiff = (float)(newSize.x - oldSize.x);
        float heightDiff = (float)(newSize.y - oldSize.y);
        if (movePorts) {
            boolean fixedPorts = node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS;
            for (LPort port : node.getPorts()) {
                switch (port.getSide()) {
                    case NORTH: {
                        if (fixedPorts) break;
                        port.getPosition().x *= (double)widthRatio;
                        break;
                    }
                    case EAST: {
                        port.getPosition().x += (double)widthDiff;
                        if (fixedPorts) break;
                        port.getPosition().y *= (double)heightRatio;
                        break;
                    }
                    case SOUTH: {
                        if (!fixedPorts) {
                            port.getPosition().x *= (double)widthRatio;
                        }
                        port.getPosition().y += (double)heightDiff;
                        break;
                    }
                    case WEST: {
                        if (fixedPorts) break;
                        port.getPosition().y *= (double)heightRatio;
                    }
                }
            }
        }
        if (moveLabels) {
            for (LLabel label : node.getLabels()) {
                double midx = label.getPosition().x + label.getSize().x / 2.0;
                double widthPercent = midx / oldSize.x;
                double midy = label.getPosition().y + label.getSize().y / 2.0;
                double heightPercent = midy / oldSize.y;
                if (!(widthPercent + heightPercent >= 1.0)) continue;
                if (widthPercent - heightPercent > 0.0 && midy >= 0.0) {
                    label.getPosition().x += (double)widthDiff;
                    label.getPosition().y += (double)heightDiff * heightPercent;
                    continue;
                }
                if (!(widthPercent - heightPercent < 0.0) || !(midx >= 0.0)) continue;
                label.getPosition().x += (double)widthDiff * widthPercent;
                label.getPosition().y += (double)heightDiff;
            }
        }
        node.getSize().x = newSize.x;
        node.getSize().y = newSize.y;
        node.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, SizeConstraint.fixed());
    }

    public static void offsetGraphs(Collection<LGraph> graphs, double offsetx, double offsety) {
        for (LGraph graph : graphs) {
            LGraphUtil.offsetGraph(graph, offsetx, offsety);
        }
    }

    public static void offsetGraph(LGraph graph, double offsetx, double offsety) {
        KVector graphOffset = new KVector(offsetx, offsety);
        for (LNode node : graph.getLayerlessNodes()) {
            node.getPosition().add(graphOffset);
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    edge.getBendPoints().offset(graphOffset);
                    KVectorChain junctionPoints = edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                    if (junctionPoints != null) {
                        junctionPoints.offset(graphOffset);
                    }
                    for (LLabel label : edge.getLabels()) {
                        label.getPosition().add(graphOffset);
                    }
                }
            }
        }
    }

    public static void placeNodesHorizontally(Layer layer, double xoffset) {
        double maxLeftMargin = 0.0;
        double maxRightMargin = 0.0;
        for (LNode node : layer.getNodes()) {
            maxLeftMargin = Math.max(maxLeftMargin, node.getMargin().left);
            maxRightMargin = Math.max(maxRightMargin, node.getMargin().right);
        }
        for (LNode node : layer.getNodes()) {
            double rightMargin;
            double ratio;
            Alignment alignment = node.getProperty(LayeredOptions.ALIGNMENT);
            switch (alignment) {
                case LEFT: {
                    ratio = 0.0;
                    break;
                }
                case RIGHT: {
                    ratio = 1.0;
                    break;
                }
                case CENTER: {
                    ratio = 0.5;
                    break;
                }
                default: {
                    int inports = 0;
                    int outports = 0;
                    for (LPort port : node.getPorts()) {
                        if (!port.getIncomingEdges().isEmpty()) {
                            ++inports;
                        }
                        if (port.getOutgoingEdges().isEmpty()) continue;
                        ++outports;
                    }
                    ratio = inports + outports == 0 ? 0.5 : (double)outports / (double)(inports + outports);
                }
            }
            KVector size = layer.getSize();
            double nodeSize = node.getSize().x;
            double xpos = (size.x - nodeSize) * ratio;
            if (ratio > 0.5) {
                xpos -= maxRightMargin * 2.0 * (ratio - 0.5);
            } else if (ratio < 0.5) {
                xpos += maxLeftMargin * 2.0 * (0.5 - ratio);
            }
            double leftMargin = node.getMargin().left;
            if (xpos < leftMargin) {
                xpos = leftMargin;
            }
            if (xpos > size.x - (rightMargin = node.getMargin().right) - nodeSize) {
                xpos = size.x - rightMargin - nodeSize;
            }
            node.getPosition().x = xoffset + xpos;
        }
    }

    public static double findMaxNonDummyNodeWidth(Layer layer, boolean respectNodeMargins) {
        if (layer.getGraph().getProperty(LayeredOptions.DIRECTION).isVertical()) {
            return 0.0;
        }
        double maxWidth = 0.0;
        for (LNode node : layer) {
            if (node.getType() != LNode.NodeType.NORMAL) continue;
            double width = node.getSize().x;
            if (respectNodeMargins) {
                width += node.getMargin().left + node.getMargin().right;
            }
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    public static void computeGraphProperties(LGraph layeredGraph) {
        Set<GraphProperties> props = layeredGraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (!props.isEmpty()) {
            props.clear();
        }
        Direction direction = LGraphUtil.getDirection(layeredGraph);
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.getProperty(LayeredOptions.COMMENT_BOX).booleanValue()) {
                props.add(GraphProperties.COMMENTS);
            } else if (node.getProperty(LayeredOptions.HYPERNODE).booleanValue()) {
                props.add(GraphProperties.HYPERNODES);
                props.add(GraphProperties.HYPEREDGES);
            } else if (node.getType() == LNode.NodeType.EXTERNAL_PORT) {
                props.add(GraphProperties.EXTERNAL_PORTS);
            }
            PortConstraints portConstraints = node.getProperty(LayeredOptions.PORT_CONSTRAINTS);
            if (portConstraints == PortConstraints.UNDEFINED) {
                node.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
            } else if (portConstraints != PortConstraints.FREE) {
                props.add(GraphProperties.NON_FREE_PORTS);
            }
            for (LPort port : node.getPorts()) {
                if (port.getIncomingEdges().size() + port.getOutgoingEdges().size() > 1) {
                    props.add(GraphProperties.HYPEREDGES);
                }
                PortSide portSide = port.getSide();
                switch (direction) {
                    case DOWN: 
                    case UP: {
                        if (portSide != PortSide.EAST && portSide != PortSide.WEST) break;
                        props.add(GraphProperties.NORTH_SOUTH_PORTS);
                        break;
                    }
                    default: {
                        if (portSide != PortSide.NORTH && portSide != PortSide.SOUTH) break;
                        props.add(GraphProperties.NORTH_SOUTH_PORTS);
                    }
                }
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.getTarget().getNode() == node) {
                        props.add(GraphProperties.SELF_LOOPS);
                    }
                    for (LLabel label : edge.getLabels()) {
                        switch (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT)) {
                            case CENTER: {
                                props.add(GraphProperties.CENTER_LABELS);
                                break;
                            }
                            case HEAD: 
                            case TAIL: {
                                props.add(GraphProperties.END_LABELS);
                            }
                        }
                    }
                }
            }
        }
    }

    public static LPort createPort(LNode node, KVector endPoint, PortType type, LGraph layeredGraph) {
        LPort port;
        Direction direction = LGraphUtil.getDirection(layeredGraph);
        boolean mergePorts = layeredGraph.getProperty(LayeredOptions.MERGE_EDGES);
        if ((mergePorts || node.getProperty(LayeredOptions.HYPERNODE).booleanValue()) && !node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
            PortSide defaultSide = PortSide.fromDirection(direction);
            port = LGraphUtil.provideCollectorPort(layeredGraph, node, type, type == PortType.OUTPUT ? defaultSide : defaultSide.opposed());
        } else {
            port = new LPort();
            port.setNode(node);
            if (endPoint != null) {
                KVector pos = port.getPosition();
                pos.x = endPoint.x - node.getPosition().x;
                pos.y = endPoint.y - node.getPosition().y;
                pos.bound(0.0, 0.0, node.getSize().x, node.getSize().y);
                port.setSide(LGraphUtil.calcPortSide(port, direction));
            } else {
                PortSide defaultSide = PortSide.fromDirection(direction);
                port.setSide(type == PortType.OUTPUT ? defaultSide : defaultSide.opposed());
            }
            Set<GraphProperties> graphProperties = layeredGraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
            PortSide portSide = port.getSide();
            switch (direction) {
                case RIGHT: 
                case LEFT: {
                    if (portSide != PortSide.NORTH && portSide != PortSide.SOUTH) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                    break;
                }
                case DOWN: 
                case UP: {
                    if (portSide != PortSide.EAST && portSide != PortSide.WEST) break;
                    graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                }
            }
        }
        return port;
    }

    static PortSide calcPortSide(LPort port, Direction direction) {
        LNode node = port.getNode();
        double nodeWidth = node.getSize().x;
        double nodeHeight = node.getSize().y;
        if (nodeWidth <= 0.0 && nodeHeight <= 0.0) {
            return PortSide.UNDEFINED;
        }
        double xpos = port.getPosition().x;
        double ypos = port.getPosition().y;
        double width = port.getSize().x;
        double height = port.getSize().y;
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0) {
                    return PortSide.WEST;
                }
                if (!(xpos + width > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0) {
                    return PortSide.NORTH;
                }
                if (!(ypos + height > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        double widthPercent = (xpos + width / 2.0) / nodeWidth;
        double heightPercent = (ypos + height / 2.0) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0 && widthPercent - heightPercent <= 0.0) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0 && widthPercent - heightPercent >= 0.0) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    static double calcPortOffset(LPort port, PortSide side) {
        LNode node = port.getNode();
        switch (side) {
            case NORTH: {
                return -(port.getPosition().y + port.getSize().y);
            }
            case EAST: {
                return port.getPosition().x - node.getSize().x;
            }
            case SOUTH: {
                return port.getPosition().y - node.getSize().y;
            }
            case WEST: {
                return -(port.getPosition().x + port.getSize().x);
            }
        }
        return 0.0;
    }

    static void centerPoint(KVector point, KVector boundary, PortSide side) {
        switch (side) {
            case NORTH: {
                point.x = boundary.x / 2.0;
                point.y = 0.0;
                break;
            }
            case EAST: {
                point.x = boundary.x;
                point.y = boundary.y / 2.0;
                break;
            }
            case SOUTH: {
                point.x = boundary.x / 2.0;
                point.y = boundary.y;
                break;
            }
            case WEST: {
                point.x = 0.0;
                point.y = boundary.y / 2.0;
            }
        }
    }

    public static LPort provideCollectorPort(LGraph layeredGraph, LNode node, PortType type, PortSide side) {
        LPort port = null;
        switch (type) {
            case INPUT: {
                for (LPort inport : node.getPorts()) {
                    if (!inport.getProperty(InternalProperties.INPUT_COLLECT).booleanValue()) continue;
                    return inport;
                }
                port = new LPort();
                port.setProperty(InternalProperties.INPUT_COLLECT, (Object)true);
                break;
            }
            case OUTPUT: {
                for (LPort outport : node.getPorts()) {
                    if (!outport.getProperty(InternalProperties.OUTPUT_COLLECT).booleanValue()) continue;
                    return outport;
                }
                port = new LPort();
                port.setProperty(InternalProperties.OUTPUT_COLLECT, (Object)true);
            }
        }
        if (port != null) {
            port.setNode(node);
            port.setSide(side);
            LGraphUtil.centerPoint(port.getPosition(), node.getSize(), side);
        }
        return port;
    }

    public static void initializePort(LPort port, PortConstraints portConstraints, Direction direction, KVector anchorPos) {
        PortSide portSide = port.getSide();
        if (portSide == PortSide.UNDEFINED && portConstraints.isSideFixed()) {
            portSide = LGraphUtil.calcPortSide(port, direction);
            port.setSide(portSide);
            if (!(port.getAllProperties().containsKey(LayeredOptions.PORT_BORDER_OFFSET) || portSide == PortSide.UNDEFINED || port.getPosition().x == 0.0 && port.getPosition().y == 0.0)) {
                port.setProperty(LayeredOptions.PORT_BORDER_OFFSET, (Object)LGraphUtil.calcPortOffset(port, portSide));
            }
        }
        if (portConstraints.isRatioFixed()) {
            double ratio = 0.0;
            switch (portSide) {
                case NORTH: 
                case SOUTH: {
                    double nodeWidth = port.getNode().getSize().x;
                    if (!(nodeWidth > 0.0)) break;
                    ratio = port.getPosition().x / nodeWidth;
                    break;
                }
                case EAST: 
                case WEST: {
                    double nodeHeight = port.getNode().getSize().y;
                    if (!(nodeHeight > 0.0)) break;
                    ratio = port.getPosition().y / nodeHeight;
                }
            }
            port.setProperty(InternalProperties.PORT_RATIO_OR_POSITION, (Object)ratio);
        }
        KVector portSize = port.getSize();
        KVector portAnchor = port.getAnchor();
        if (anchorPos != null) {
            portAnchor.x = anchorPos.x;
            portAnchor.y = anchorPos.y;
            port.setExplicitlySuppliedPortAnchor(true);
        } else if (portConstraints.isSideFixed() && portSide != PortSide.UNDEFINED) {
            switch (portSide) {
                case NORTH: {
                    portAnchor.x = portSize.x / 2.0;
                    break;
                }
                case EAST: {
                    portAnchor.x = portSize.x;
                    portAnchor.y = portSize.y / 2.0;
                    break;
                }
                case SOUTH: {
                    portAnchor.x = portSize.x / 2.0;
                    portAnchor.y = portSize.y;
                    break;
                }
                case WEST: {
                    portAnchor.y = portSize.y / 2.0;
                }
            }
        } else {
            portAnchor.x = portSize.x / 2.0;
            portAnchor.y = portSize.y / 2.0;
        }
    }

    public static LNode createExternalPortDummy(IPropertyHolder propertyHolder, PortConstraints portConstraints, PortSide portSide, int netFlow, KVector portNodeSize, KVector portPosition, KVector portSize, Direction layoutDirection, LGraph layeredGraph) {
        PortSide finalExternalPortSide = portSide;
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.EXTERNAL_PORT);
        dummy.setProperty(InternalProperties.EXT_PORT_SIZE, portSize);
        dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        double portBorderOffset = propertyHolder.getProperty(LayeredOptions.PORT_BORDER_OFFSET);
        dummy.setProperty(LayeredOptions.PORT_BORDER_OFFSET, (Object)portBorderOffset);
        LPort dummyPort = new LPort();
        dummyPort.setNode(dummy);
        if (!portConstraints.isSideFixed()) {
            assert (layoutDirection != Direction.UNDEFINED);
            finalExternalPortSide = netFlow >= 0 ? PortSide.fromDirection(layoutDirection) : PortSide.fromDirection(layoutDirection).opposed();
            propertyHolder.setProperty(LayeredOptions.PORT_SIDE, finalExternalPortSide);
        }
        KVector anchor = new KVector();
        boolean explicitAnchor = false;
        if (propertyHolder.hasProperty(LayeredOptions.PORT_ANCHOR)) {
            anchor.set(propertyHolder.getProperty(LayeredOptions.PORT_ANCHOR));
            explicitAnchor = true;
        } else {
            anchor.set(portSize.x / 2.0, portSize.y / 2.0);
        }
        switch (finalExternalPortSide) {
            case WEST: {
                dummy.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.FIRST_SEPARATE);
                dummy.setProperty(InternalProperties.EDGE_CONSTRAINT, (Object)EdgeConstraint.OUTGOING_ONLY);
                dummy.getSize().y = portSize.y;
                if (portBorderOffset < 0.0) {
                    dummy.getSize().x = -portBorderOffset;
                }
                dummyPort.setSide(PortSide.EAST);
                if (!explicitAnchor) {
                    anchor.x = portSize.x;
                }
                anchor.x -= portSize.x;
                break;
            }
            case EAST: {
                dummy.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.LAST_SEPARATE);
                dummy.setProperty(InternalProperties.EDGE_CONSTRAINT, (Object)EdgeConstraint.INCOMING_ONLY);
                dummy.getSize().y = portSize.y;
                if (portBorderOffset < 0.0) {
                    dummy.getSize().x = -portBorderOffset;
                }
                dummyPort.setSide(PortSide.WEST);
                if (explicitAnchor) break;
                anchor.x = 0.0;
                break;
            }
            case NORTH: {
                dummy.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.TOP);
                dummy.getSize().x = portSize.x;
                if (portBorderOffset < 0.0) {
                    dummy.getSize().y = -portBorderOffset;
                }
                dummyPort.setSide(PortSide.SOUTH);
                if (!explicitAnchor) {
                    anchor.y = portSize.y;
                }
                anchor.y -= portSize.y;
                break;
            }
            case SOUTH: {
                dummy.setProperty(InternalProperties.IN_LAYER_CONSTRAINT, (Object)InLayerConstraint.BOTTOM);
                dummy.getSize().x = portSize.x;
                if (portBorderOffset < 0.0) {
                    dummy.getSize().y = -portBorderOffset;
                }
                dummyPort.setSide(PortSide.NORTH);
                if (explicitAnchor) break;
                anchor.y = 0.0;
                break;
            }
            default: {
                assert (false) : finalExternalPortSide;
                break;
            }
        }
        dummyPort.getPosition().set(anchor);
        dummy.setProperty(LayeredOptions.PORT_ANCHOR, anchor);
        if (portConstraints.isOrderFixed()) {
            double informationAboutIt = 0.0;
            if (portConstraints == PortConstraints.FIXED_ORDER && propertyHolder.hasProperty(LayeredOptions.PORT_INDEX)) {
                switch (finalExternalPortSide) {
                    case NORTH: 
                    case EAST: {
                        informationAboutIt = propertyHolder.getProperty(LayeredOptions.PORT_INDEX).doubleValue();
                        break;
                    }
                    case SOUTH: 
                    case WEST: {
                        informationAboutIt = -1.0 * propertyHolder.getProperty(LayeredOptions.PORT_INDEX).doubleValue();
                    }
                }
            } else {
                switch (finalExternalPortSide) {
                    case EAST: 
                    case WEST: {
                        informationAboutIt = portPosition.y;
                        if (!portConstraints.isRatioFixed()) break;
                        informationAboutIt /= portNodeSize.y;
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        informationAboutIt = portPosition.x;
                        if (!portConstraints.isRatioFixed()) break;
                        informationAboutIt /= portNodeSize.x;
                    }
                }
            }
            dummy.setProperty(InternalProperties.PORT_RATIO_OR_POSITION, (Object)informationAboutIt);
        }
        dummy.setProperty(InternalProperties.EXT_PORT_SIDE, (Object)finalExternalPortSide);
        return dummy;
    }

    public static KVector getExternalPortPosition(LGraph graph, LNode portDummy, double portWidth, double portHeight) {
        KVector portPosition = new KVector(portDummy.getPosition());
        portPosition.x += portDummy.getSize().x / 2.0;
        portPosition.y += portDummy.getSize().y / 2.0;
        double portOffset = portDummy.getProperty(LayeredOptions.PORT_BORDER_OFFSET);
        KVector graphSize = graph.getSize();
        LPadding padding = graph.getPadding();
        KVector graphOffset = graph.getOffset();
        switch (portDummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
            case NORTH: {
                portPosition.x += padding.left + graphOffset.x - portWidth / 2.0;
                portPosition.y = -portHeight - portOffset;
                portDummy.getPosition().y = -(padding.top + portOffset + graphOffset.y);
                break;
            }
            case EAST: {
                portPosition.x = graphSize.x + padding.left + padding.right + portOffset;
                portPosition.y += padding.top + graphOffset.y - portHeight / 2.0;
                portDummy.getPosition().x = graphSize.x + padding.right + portOffset - graphOffset.x;
                break;
            }
            case SOUTH: {
                portPosition.x += padding.left + graphOffset.x - portWidth / 2.0;
                portPosition.y = graphSize.y + padding.top + padding.bottom + portOffset;
                portDummy.getPosition().y = graphSize.y + padding.bottom + portOffset - graphOffset.y;
                break;
            }
            case WEST: {
                portPosition.x = -portWidth - portOffset;
                portPosition.y += padding.top + graphOffset.y - portHeight / 2.0;
                portDummy.getPosition().x = -(padding.left + portOffset + graphOffset.x);
            }
        }
        return portPosition;
    }

    public static boolean isDescendant(LNode child, LNode parent) {
        LNode current = child;
        LNode next = current.getGraph().getParentNode();
        while (next != null) {
            current = next;
            if (current == parent) {
                return true;
            }
            next = current.getGraph().getParentNode();
        }
        return false;
    }

    public static void changeCoordSystem(KVector point, LGraph oldGraph, LGraph newGraph) {
        LPadding padding;
        LNode node;
        if (oldGraph == newGraph) {
            return;
        }
        LGraph graph = oldGraph;
        do {
            point.add(graph.getOffset());
            node = graph.getParentNode();
            if (node == null) continue;
            padding = graph.getPadding();
            point.add(padding.left, padding.top);
            point.add(node.getPosition());
            graph = node.getGraph();
        } while (node != null);
        graph = newGraph;
        do {
            point.sub(graph.getOffset());
            node = graph.getParentNode();
            if (node == null) continue;
            padding = graph.getPadding();
            point.sub(padding.left, padding.top);
            point.sub(node.getPosition());
            graph = node.getGraph();
        } while (node != null);
    }

    public static <T> T getIndividualOrInherited(LNode node, IProperty<T> property) {
        IPropertyHolder individualSpacings;
        T result = null;
        if (node.hasProperty(CoreOptions.SPACING_INDIVIDUAL) && (individualSpacings = (IPropertyHolder)node.getProperty(CoreOptions.SPACING_INDIVIDUAL)).hasProperty(property)) {
            result = individualSpacings.getProperty(property);
        }
        if (result == null && node.getGraph() != null) {
            result = node.getGraph().getProperty(property);
        }
        return result;
    }

    public static Direction getDirection(LGraph graph) {
        Direction direction = graph.getProperty(LayeredOptions.DIRECTION);
        if (direction == Direction.UNDEFINED) {
            double aspectRatio = graph.getProperty(LayeredOptions.ASPECT_RATIO);
            if (aspectRatio >= 1.0) {
                return Direction.RIGHT;
            }
            return Direction.DOWN;
        }
        return direction;
    }

    public static int getMinimalModelOrder(LGraph graph) {
        int order = Integer.MAX_VALUE;
        for (LNode node : graph.getLayerlessNodes()) {
            if (!node.hasProperty(InternalProperties.MODEL_ORDER)) continue;
            order = Math.min(order, node.getProperty(InternalProperties.MODEL_ORDER));
        }
        return order;
    }
}

