/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.utils.LineLocation;

public class StateDiagram
extends AbstractEntityDiagram {
    private static final String CONCURRENT_PREFIX = "CONC";
    private boolean hideEmptyDescription = false;

    public StateDiagram(UmlSource source, Previous previous, PreprocessingArtifact preprocessingArtifact) {
        super(source, UmlDiagramType.STATE, previous, preprocessingArtifact);
        this.setNamespaceSeparator(".");
    }

    @Override
    public Set<ParserPass> getRequiredPass() {
        return EnumSet.of(ParserPass.ONE, ParserPass.TWO, ParserPass.THREE);
    }

    public boolean checkConcurrentStateOk(Quark<Entity> code) {
        boolean result = this.checkConcurrentStateOkInternal(code);
        return result;
    }

    private boolean checkConcurrentStateOkInternal(Quark<Entity> code) {
        if (code.getData() == null) {
            return true;
        }
        Entity existing = code.getData();
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE && this.getCurrentGroup() != existing.getParentContainer()) {
            return false;
        }
        return existing.getParentContainer() == null || existing.getParentContainer().getGroupType() != GroupType.CONCURRENT_STATE || this.getCurrentGroup() == existing.getParentContainer();
    }

    public Entity getStart(LineLocation location) {
        Entity g2 = this.getCurrentGroup();
        if (g2.isRoot()) {
            String idShort = "*start*";
            Quark<Entity> quark = this.quarkInContext(true, this.cleanId("*start*"));
            if (quark.getData() == null) {
                this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.CIRCLE_START, null);
            }
            return quark.getData();
        }
        String idShort = "*start*" + g2.getName();
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        if (quark.getData() == null) {
            this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.CIRCLE_START, null);
        }
        return quark.getData();
    }

    public Entity getEnd(LineLocation location) {
        Entity p = this.getCurrentGroup();
        if (p.isRoot()) {
            String idShort = "*end*";
            Quark<Entity> quark = this.quarkInContext(true, this.cleanId("*end*"));
            if (quark.getData() == null) {
                this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.CIRCLE_END, null);
            }
            return quark.getData();
        }
        String idShort = "*end*" + p.getName();
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        if (quark.getData() == null) {
            this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.CIRCLE_END, null);
        }
        return quark.getData();
    }

    public Entity getHistorical(LineLocation location) {
        Entity g2 = this.getCurrentGroup();
        if (g2.isRoot()) {
            String idShort = "*historical*";
            Quark<Entity> quark = this.quarkInContext(true, this.cleanId("*historical*"));
            if (quark.getData() == null) {
                this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.PSEUDO_STATE, null);
            }
            return quark.getData();
        }
        String idShort = "*historical*" + g2.getName();
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        if (quark.getData() == null) {
            this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.PSEUDO_STATE, null);
        }
        return quark.getData();
    }

    public Entity getHistorical(LineLocation location, String idShort) {
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        this.gotoGroup(location, quark, Display.getWithNewlines(quark), GroupType.STATE);
        Entity g2 = this.getCurrentGroup();
        String tmp = "*historical*" + g2.getName();
        Quark<Entity> ident = this.quarkInContext(true, tmp);
        Entity result = ident.getData() == null ? this.reallyCreateLeaf(location, ident, Display.getWithNewlines(this.getPragma(), ""), LeafType.PSEUDO_STATE, null) : ident.getData();
        this.endGroup();
        return result;
    }

    public Entity getDeepHistory(LineLocation location) {
        Entity g2 = this.getCurrentGroup();
        if (g2.isRoot()) {
            String idShort = "*deephistory*";
            Quark<Entity> quark = this.quarkInContext(true, this.cleanId("*deephistory*"));
            if (quark.getData() == null) {
                this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.DEEP_HISTORY, null);
            }
            return quark.getData();
        }
        String idShort = "*deephistory*" + g2.getName();
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        if (quark.getData() == null) {
            this.reallyCreateLeaf(location, quark, Display.getWithNewlines(this.getPragma(), ""), LeafType.DEEP_HISTORY, null);
        }
        return quark.getData();
    }

    public Entity getDeepHistory(LineLocation location, String idShort) {
        Quark<Entity> quark = this.quarkInContext(true, this.cleanId(idShort));
        this.gotoGroup(location, quark, Display.getWithNewlines(quark), GroupType.STATE);
        Entity g2 = this.getCurrentGroup();
        String tmp = "*deephistory*" + g2.getName();
        Quark<Entity> ident = this.quarkInContext(true, this.cleanId(tmp));
        Entity result = ident.getData() == null ? this.reallyCreateLeaf(location, ident, Display.getWithNewlines(this.getPragma(), ""), LeafType.DEEP_HISTORY, null) : ident.getData();
        this.endGroup();
        return result;
    }

    public boolean concurrentState(LineLocation location, char direction, ParserPass currentPass) {
        Entity cur = this.getCurrentGroup();
        this.getCurrentGroup().setConcurrentSeparator(direction);
        if (cur.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        String tmp1 = this.getUniqueSequence2(CONCURRENT_PREFIX);
        Quark<Entity> ident1 = this.quarkInContext(true, this.cleanId(tmp1));
        this.gotoGroup(location, ident1, Display.create(""), GroupType.CONCURRENT_STATE);
        this.getCurrentGroup().setConcurrentSeparator(direction);
        return true;
    }

    @Override
    public boolean endGroup() {
        Entity cur = this.getCurrentGroup();
        if (cur.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        return super.endGroup();
    }

    @Override
    public final void setHideEmptyDescription(boolean hideEmptyDescription) {
        this.hideEmptyDescription = hideEmptyDescription;
    }

    @Override
    public final boolean isHideEmptyDescriptionForState() {
        return this.hideEmptyDescription;
    }

    @Override
    public String checkFinalError() {
        for (Link link : this.getLinks()) {
            Entity parent2;
            Entity parent1 = StateDiagram.getGroupParentIfItIsConcurrentState(link.getEntity1());
            if (StateDiagram.isCompatible(parent1, parent2 = StateDiagram.getGroupParentIfItIsConcurrentState(link.getEntity2()))) continue;
            return "State within concurrent state cannot be linked out of this concurrent state (between " + link.getEntity1().getName() + " and " + link.getEntity2().getName() + ")";
        }
        return super.checkFinalError();
    }

    private static boolean isCompatible(Entity parent1, Entity parent2) {
        if (parent1 == null && parent2 == null) {
            return true;
        }
        if (parent1 != null ^ parent2 != null) {
            return false;
        }
        assert (parent1 != null && parent2 != null);
        return parent1 == parent2;
    }

    private static Entity getGroupParentIfItIsConcurrentState(Entity ent) {
        for (Entity parent = ent.getParentContainer(); parent != null; parent = parent.getParentContainer()) {
            if (parent.getGroupType() != GroupType.CONCURRENT_STATE) continue;
            return parent;
        }
        return null;
    }

    public void ensureParentState(LineLocation location, Quark<Entity> current) {
        while (current != null) {
            Quark<Entity> parent = current.getParent();
            if (parent == null || parent.getData() != null) {
                return;
            }
            Entity parentGroup = this.createGroup(location, parent, GroupType.STATE);
            parentGroup.setDisplay(Display.getWithNewlines(parent));
            current = parent;
        }
    }
}

