/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.BasicCharArea;
import net.sourceforge.plantuml.asciiart.Wcwidth;

public class BasicCharAreaImpl
implements BasicCharArea {
    private int charSize1 = 160;
    private int charSize2 = 160;
    private int width;
    private int height;
    private char[][] chars = new char[this.charSize1][this.charSize2];

    public BasicCharAreaImpl() {
        for (int i = 0; i < this.charSize1; ++i) {
            for (int j = 0; j < this.charSize2; ++j) {
                this.chars[i][j] = 32;
            }
        }
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public void drawChar(char c, int x, int y) {
        this.ensurePossible(x, y);
        this.chars[x][y] = c;
        if (x >= this.width) {
            this.width = x + 1;
        }
        if (y >= this.height) {
            this.height = y + 1;
        }
    }

    private boolean isLong(char c) {
        int wc = Wcwidth.of(c);
        if (wc == 1) {
            return false;
        }
        return wc == 2;
    }

    private void ensurePossible(int x, int y) {
        int newCharSize1;
        int newCharSize2 = this.charSize2;
        for (newCharSize1 = this.charSize1; x >= newCharSize1; newCharSize1 *= 2) {
        }
        while (y >= newCharSize2) {
            newCharSize2 *= 2;
        }
        if (newCharSize1 != this.charSize1 || newCharSize2 != this.charSize2) {
            char[][] newChars = new char[newCharSize1][newCharSize2];
            for (int i = 0; i < newCharSize1; ++i) {
                for (int j = 0; j < newCharSize2; ++j) {
                    int c = 32;
                    if (i < this.charSize1 && j < this.charSize2) {
                        c = this.chars[i][j];
                    }
                    newChars[i][j] = c;
                }
            }
            this.chars = newChars;
            this.charSize1 = newCharSize1;
            this.charSize2 = newCharSize2;
        }
    }

    @Override
    public void drawStringLR(String string, int x, int y) {
        int pos = x;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.drawChar(c, pos, y);
            ++pos;
            if (!this.isLong(c)) continue;
            this.drawChar('\u0000', pos, y);
            ++pos;
        }
    }

    @Override
    public void drawStringTB(String string, int x, int y) {
        for (int i = 0; i < string.length(); ++i) {
            this.drawChar(string.charAt(i), x, y + i);
        }
    }

    @Override
    public String getLine(int line) {
        StringBuilder sb = new StringBuilder(this.charSize1);
        for (int x = 0; x < this.width; ++x) {
            char c = this.chars[x][line];
            if (c == '\u0000') continue;
            StringUtils.appendInternalToRealBoldNumber(sb, c);
        }
        return sb.toString();
    }

    @Override
    public void print(PrintStream ps) {
        for (String s2 : this.getLines()) {
            ps.println(s2);
        }
    }

    @Override
    public List<String> getLines() {
        ArrayList<String> result = new ArrayList<String>(this.height);
        for (int y = 0; y < this.height; ++y) {
            result.add(this.getLine(y));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void drawHLine(char c, int line, int col1, int col2) {
        for (int x = col1; x < col2; ++x) {
            this.drawChar(c, x, line);
        }
    }

    @Override
    public void drawHLine(char c, int line, int col1, int col2, char ifFound, char thenUse) {
        for (int x = col1; x < col2; ++x) {
            this.ensurePossible(x, line);
            if (this.chars[x][line] == ifFound) {
                this.drawChar(thenUse, x, line);
                continue;
            }
            this.drawChar(c, x, line);
        }
    }

    @Override
    public void drawVLine(char c, int col, int line1, int line2) {
        for (int y = line1; y < line2; ++y) {
            this.drawChar(c, col, y);
        }
    }

    public String toString() {
        return this.getLines().toString();
    }

    @Override
    public void fillRect(char c, int x, int y, int width, int height) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.drawChar(c, x + i, y + j);
            }
        }
    }
}

