/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.json.JsonValueFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2JsonValueFunction
extends JsonValueFunction {
    public DB2JsonValueFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        boolean encodedBoolean;
        boolean bl = encodedBoolean = arguments.returningType() != null && DB2JsonValueFunction.isEncodedBoolean(arguments.returningType().getJdbcMapping());
        if (encodedBoolean) {
            sqlAppender.append("decode(");
        }
        super.render(sqlAppender, arguments, returnType, walker);
        if (encodedBoolean) {
            JdbcMapping type = arguments.returningType().getJdbcMapping();
            JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
            SessionFactoryImplementor sessionFactory = walker.getSessionFactory();
            Dialect dialect = sessionFactory.getJdbcServices().getDialect();
            WrapperOptions wrapperOptions = sessionFactory.getWrapperOptions();
            Object trueValue = type.convertToRelationalValue(true);
            Object falseValue = type.convertToRelationalValue(false);
            sqlAppender.append(",'true',");
            jdbcLiteralFormatter.appendJdbcLiteral(sqlAppender, trueValue, dialect, wrapperOptions);
            sqlAppender.append(",'false',");
            jdbcLiteralFormatter.appendJdbcLiteral(sqlAppender, falseValue, dialect, wrapperOptions);
            sqlAppender.append(')');
        }
    }

    @Override
    protected void renderReturningClause(SqlAppender sqlAppender, JsonValueFunction.JsonValueArguments arguments, SqlAstTranslator<?> walker) {
        if (arguments.returningType() != null && !DB2JsonValueFunction.isEncodedBoolean(arguments.returningType().getJdbcMapping())) {
            super.renderReturningClause(sqlAppender, arguments, walker);
        }
    }

    static boolean isEncodedBoolean(JdbcMapping type) {
        return type.getJdbcType().isBoolean();
    }
}

