/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindingContext;

public class ArrayArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator DEFAULT_INSTANCE = new ArrayArgumentValidator(0);
    private final int arrayIndex;

    public ArrayArgumentValidator(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        this.getElementType(arguments, functionName, bindingContext);
    }

    protected BasicType<?> getElementType(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        return this.getElementType(this.arrayIndex, arguments, functionName, bindingContext);
    }

    protected BasicPluralType<?, ?> getPluralType(int arrayIndex, List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        SqmTypedNode<?> arrayArgument = arguments.get(arrayIndex);
        SqmBindableType<?> expressible = arrayArgument.getExpressible();
        if (expressible == null) {
            return null;
        }
        SqmDomainType arrayType = expressible.getSqmType();
        if (arrayType == null) {
            return null;
        }
        if (arrayType instanceof BasicPluralType) {
            BasicPluralType basicPluralType = (BasicPluralType)arrayType;
            return basicPluralType;
        }
        throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires an array type, but argument is of type '%s'", arrayIndex, functionName, arrayType.getTypeName()));
    }

    protected BasicType<?> getElementType(int arrayIndex, List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        return this.getPluralType(arrayIndex, arguments, functionName, bindingContext).getElementType();
    }
}

