/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.descriptors.OptionContainer;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public class FieldDescriptor
extends AnnotatedDescriptorImpl
implements AnnotatedDescriptor {
    protected final int number;
    protected final Label label;
    protected final String typeName;
    protected final String defaultValue;
    protected final List<Option> options;
    protected Type type;
    protected FileDescriptor fileDescriptor;
    protected Descriptor containingMessage;
    protected Descriptor messageType;
    protected EnumDescriptor enumType;

    protected FieldDescriptor(Builder builder) {
        super(builder.name, null, builder.documentation);
        this.number = builder.number;
        this.label = builder.label;
        this.options = List.copyOf(builder.options);
        this.typeName = builder.typeName;
        this.type = Type.primitiveFromString(this.typeName);
        String dv = null;
        for (Option o : this.options) {
            if (!"default".equals(o.getName())) continue;
            dv = o.getValue().toString();
            break;
        }
        this.defaultValue = dv;
    }

    public int getNumber() {
        return this.number;
    }

    public int getWireTag() {
        return WireType.makeTag(this.number, this.type.getWireType());
    }

    public Type getType() {
        return this.type;
    }

    public Descriptor getMessageType() {
        return this.messageType;
    }

    public Label getLabel() {
        return this.label;
    }

    public Option getOptionByName(String name) {
        return this.options.stream().filter(o -> name.equals(o.getName())).findFirst().orElse(null);
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean isRepeated() {
        return this.label == Label.REPEATED;
    }

    public boolean isMap() {
        return false;
    }

    public JavaType getJavaType() {
        return this.getType().getJavaType();
    }

    public EnumDescriptor getEnumType() {
        return this.enumType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public Descriptor getContainingMessage() {
        return this.containingMessage;
    }

    void setContainingMessage(Descriptor containingMessage) {
        this.containingMessage = containingMessage;
        this.fullName = FileDescriptor.fullName(containingMessage.getFullName(), this.name);
    }

    void setMessageType(Descriptor descriptor) {
        this.messageType = descriptor;
        this.type = Type.MESSAGE;
    }

    void setEnumType(EnumDescriptor enumDescriptor) {
        this.enumType = enumDescriptor;
        this.type = Type.ENUM;
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    @Override
    protected AnnotationConfiguration getAnnotationConfig(AnnotationElement.Annotation annotation) {
        AnnotationConfiguration annotationConfiguration = this.getAnnotationsConfig().annotations().get(annotation.getName());
        if (annotationConfiguration == null) {
            return null;
        }
        if (annotation.getPackageName() != null && !annotation.getPackageName().equals(annotationConfiguration.packageName())) {
            return null;
        }
        for (AnnotationElement.AnnotationTarget t : annotationConfiguration.target()) {
            if (t != AnnotationElement.AnnotationTarget.FIELD) continue;
            return annotationConfiguration;
        }
        throw new DescriptorParserException("Annotation '" + String.valueOf(annotation) + "' cannot be applied to fields.");
    }

    public String toString() {
        return "FieldDescriptor{label=" + String.valueOf((Object)this.label) + ", typeName='" + this.typeName + "', name='" + this.name + "', number='" + this.number + "'}";
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Object getDefaultValue() {
        if (this.getJavaType() == JavaType.MESSAGE) {
            throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field (only scalars can have a default value).");
        }
        if (!this.hasDefaultValue()) {
            return null;
        }
        return this.getJavaType().fromString(this.defaultValue);
    }

    public static class Builder
    implements OptionContainer<Builder> {
        String typeName;
        int number;
        String name;
        Label label = Label.OPTIONAL;
        List<Option> options = new ArrayList<Option>();
        String documentation;
        private String defaultValue;

        public Builder withNumber(int number) {
            this.number = number;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder withLabel(Label label) {
            this.label = label;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        @Override
        public Builder addOption(Option option) {
            this.options.add(option);
            return this;
        }

        public FieldDescriptor build() {
            return new FieldDescriptor(this);
        }
    }
}

