/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.infinispan.LazyModel;
import org.keycloak.models.cache.infinispan.SubjectCredentialManagerCacheAdapter;
import org.keycloak.models.cache.infinispan.UserCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedUser;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;

public class UserAdapter
implements CachedUserModel {
    private final Supplier<UserModel> modelSupplier;
    protected final CachedUser cached;
    protected final UserCacheSession userProviderCache;
    protected final KeycloakSession keycloakSession;
    protected final RealmModel realm;
    protected volatile UserModel updated;

    public UserAdapter(CachedUser cached, UserCacheSession userProvider, KeycloakSession keycloakSession, RealmModel realm) {
        this.cached = cached;
        this.userProviderCache = userProvider;
        this.keycloakSession = keycloakSession;
        this.realm = realm;
        this.modelSupplier = new LazyModel<UserModel>(this::getUserModel);
    }

    public String getFirstName() {
        if (this.updated != null) {
            return this.updated.getFirstName();
        }
        return this.getFirstAttribute("firstName");
    }

    public void setFirstName(String firstName) {
        this.setSingleAttribute("firstName", firstName);
    }

    public String getLastName() {
        if (this.updated != null) {
            return this.updated.getLastName();
        }
        return this.getFirstAttribute("lastName");
    }

    public void setLastName(String lastName) {
        this.setSingleAttribute("lastName", lastName);
    }

    public String getEmail() {
        if (this.updated != null) {
            return this.updated.getEmail();
        }
        return this.getFirstAttribute("email");
    }

    public void setEmail(String email) {
        email = email == null ? null : email.toLowerCase();
        this.setSingleAttribute("email", email);
    }

    public UserModel getDelegateForUpdate() {
        if (this.updated == null) {
            this.userProviderCache.registerUserInvalidation(this.cached);
            this.updated = this.modelSupplier.get();
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    public boolean isMarkedForEviction() {
        return this.updated != null;
    }

    public void invalidate() {
        try {
            this.getDelegateForUpdate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    public ConcurrentHashMap getCachedWith() {
        return this.cached.getCachedWith();
    }

    public String getId() {
        if (this.updated != null) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getUsername() {
        if (this.updated != null) {
            return this.updated.getUsername();
        }
        return this.getFirstAttribute("username");
    }

    public void setUsername(String username) {
        username = username == null ? null : username.toLowerCase();
        this.setSingleAttribute("username", username);
    }

    public Long getCreatedTimestamp() {
        return this.cached.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
    }

    public boolean isEnabled() {
        if (this.updated != null) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (this.updated == null && this.cached.isEnabled() == enabled) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public void setSingleAttribute(String name, String value) {
        if ("username".equals(name) || "email".equals(name)) {
            value = KeycloakModelUtils.toLowerCaseSafe((String)value);
        }
        if (this.updated == null) {
            Set<Object> newEntries;
            Set oldEntries = this.getAttributeStream(name).collect(Collectors.toSet());
            Set<Object> set = newEntries = value != null ? Set.of(value) : Collections.emptySet();
            if (CollectionUtil.collectionEquals(oldEntries, newEntries)) {
                return;
            }
        }
        this.getDelegateForUpdate();
        this.updated.setSingleAttribute(name, value);
    }

    public void setAttribute(String name, List<String> values) {
        HashSet<Object> newEntries;
        Set oldEntries;
        String lowerCasedFirstValue;
        if (("username".equals(name) || "email".equals(name)) && (lowerCasedFirstValue = KeycloakModelUtils.toLowerCaseSafe(values != null && values.size() > 0 ? values.get(0) : null)) != null) {
            values = Collections.singletonList(lowerCasedFirstValue);
        }
        if (this.updated == null && CollectionUtil.collectionEquals(oldEntries = this.getAttributeStream(name).collect(Collectors.toSet()), newEntries = values == null ? new HashSet() : new HashSet<String>(values))) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        if (this.updated == null && this.getFirstAttribute(name) == null) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getFirstAttribute(String name) {
        if (this.updated != null) {
            return this.updated.getFirstAttribute(name);
        }
        return this.cached.getFirstAttribute(this.keycloakSession, name, this.modelSupplier);
    }

    public Stream<String> getAttributeStream(String name) {
        if (this.updated != null) {
            return this.updated.getAttributeStream(name);
        }
        List result = (List)this.cached.getAttributes(this.keycloakSession, this.modelSupplier).get((Object)name);
        return result == null ? Stream.empty() : result.stream();
    }

    public Map<String, List<String>> getAttributes() {
        if (this.updated != null) {
            return this.updated.getAttributes();
        }
        return this.cached.getAttributes(this.keycloakSession, this.modelSupplier);
    }

    public Stream<String> getRequiredActionsStream() {
        if (this.updated != null) {
            return this.updated.getRequiredActionsStream();
        }
        return this.cached.getRequiredActions(this.keycloakSession, this.modelSupplier).stream();
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        if (action == null || this.updated == null && this.getCachedRequiredActions().contains(action.name())) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.addRequiredAction(action);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        if (action == null || this.updated == null && !this.getCachedRequiredActions().contains(action.name())) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.removeRequiredAction(action);
    }

    public void addRequiredAction(String action) {
        if (this.updated == null && this.getCachedRequiredActions().contains(action)) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.addRequiredAction(action);
    }

    public void removeRequiredAction(String action) {
        if (this.updated == null && !this.getCachedRequiredActions().contains(action)) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.removeRequiredAction(action);
    }

    private Set<String> getCachedRequiredActions() {
        return this.cached.getRequiredActions(this.keycloakSession, this.modelSupplier);
    }

    public boolean isEmailVerified() {
        if (this.updated != null) {
            return this.updated.isEmailVerified();
        }
        return this.cached.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        if (this.updated == null && this.cached.isEmailVerified() == verified) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.setEmailVerified(verified);
    }

    public String getFederationLink() {
        if (this.updated != null) {
            return this.updated.getFederationLink();
        }
        return this.cached.getFederationLink();
    }

    public void setFederationLink(String link) {
        if (this.updated == null && Objects.equals(this.cached.getFederationLink(), link)) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.setFederationLink(link);
    }

    public String getServiceAccountClientLink() {
        if (this.updated != null) {
            return this.updated.getServiceAccountClientLink();
        }
        return this.cached.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        if (this.updated == null && Objects.equals(this.cached.getServiceAccountClientLink(), clientInternalId)) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.setServiceAccountClientLink(clientInternalId);
    }

    public SubjectCredentialManager credentialManager() {
        return new SubjectCredentialManagerCacheAdapter(this.keycloakSession, this.realm, (UserModel)this){

            public CredentialModel getStoredCredentialById(String id) {
                if (UserAdapter.this.updated == null) {
                    return UserAdapter.this.cached.getStoredCredentials(UserAdapter.this.keycloakSession, UserAdapter.this.modelSupplier).stream().filter(credential -> Objects.equals(id, credential.getId())).findFirst().orElse(null);
                }
                return super.getStoredCredentialById(id);
            }

            public Stream<CredentialModel> getStoredCredentialsStream() {
                if (UserAdapter.this.updated == null) {
                    return UserAdapter.this.cached.getStoredCredentials(UserAdapter.this.keycloakSession, UserAdapter.this.modelSupplier).stream();
                }
                return super.getStoredCredentialsStream();
            }

            public Stream<CredentialModel> getStoredCredentialsByTypeStream(String type) {
                if (UserAdapter.this.updated == null) {
                    return UserAdapter.this.cached.getStoredCredentials(UserAdapter.this.keycloakSession, UserAdapter.this.modelSupplier).stream().filter(credential -> Objects.equals(type, credential.getType()));
                }
                return super.getStoredCredentialsByTypeStream(type);
            }

            public CredentialModel getStoredCredentialByNameAndType(String name, String type) {
                if (UserAdapter.this.updated == null) {
                    return UserAdapter.this.cached.getStoredCredentials(UserAdapter.this.keycloakSession, UserAdapter.this.modelSupplier).stream().filter(credential -> Objects.equals(type, credential.getType()) && Objects.equals(name, credential.getUserLabel())).findFirst().orElse(null);
                }
                return super.getStoredCredentialByNameAndType(name, type);
            }

            @Override
            public void invalidateCacheForEntity() {
                UserAdapter.this.getDelegateForUpdate();
            }
        };
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        if (this.updated != null) {
            return this.updated.getRealmRoleMappingsStream();
        }
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isRealmRole((RoleModel)r, (RealmModel)this.realm));
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        if (this.updated != null) {
            return this.updated.getClientRoleMappingsStream(app);
        }
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
    }

    public boolean hasDirectRole(RoleModel role) {
        if (this.updated != null) {
            return this.updated.hasDirectRole(role);
        }
        return this.cached.getRoleMappings(this.keycloakSession, this.modelSupplier).contains(role.getId());
    }

    public boolean hasRole(RoleModel role) {
        if (this.updated != null) {
            return this.updated.hasRole(role);
        }
        return this.cached.getRoleMappings(this.keycloakSession, this.modelSupplier).contains(role.getId()) || this.getRoleMappingsStream().anyMatch(r -> r.hasRole(role)) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        if (this.updated == null && this.cached.getRoleMappings(this.keycloakSession, this.modelSupplier).contains(role.getId())) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.grantRole(role);
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        if (this.updated != null) {
            return this.updated.getRoleMappingsStream();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getRoleMappings(this.keycloakSession, this.modelSupplier)) {
            RoleModel roleById = this.keycloakSession.roles().getRoleById(this.realm, id);
            if (roleById == null) {
                this.getDelegateForUpdate();
                return this.updated.getRoleMappingsStream();
            }
            roles.add(roleById);
        }
        return roles.stream();
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.updated == null && !this.cached.getRoleMappings(this.keycloakSession, this.modelSupplier).contains(role.getId())) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.deleteRoleMapping(role);
    }

    public Stream<GroupModel> getGroupsStream() {
        Stream result = Stream.empty();
        if (this.updated != null) {
            result = this.updated.getGroupsStream();
        } else {
            HashSet<GroupModel> groups = null;
            for (String id : this.cached.getGroups(this.keycloakSession, this.modelSupplier)) {
                GroupModel groupModel = this.keycloakSession.groups().getGroupById(this.realm, id);
                if (groupModel == null) {
                    this.getDelegateForUpdate();
                    result = this.updated.getGroupsStream();
                    break;
                }
                if (groups == null) {
                    groups = new HashSet<GroupModel>();
                }
                groups.add(groupModel);
            }
            if (groups != null) {
                result = groups.stream();
            }
        }
        return result.filter(g -> GroupModel.Type.REALM.equals((Object)g.getType())).sorted(Comparator.comparing(GroupModel::getName));
    }

    public long getGroupsCountByNameContaining(String search) {
        if (this.updated != null) {
            return this.updated.getGroupsCountByNameContaining(search);
        }
        return this.modelSupplier.get().getGroupsCountByNameContaining(search);
    }

    public void joinGroup(GroupModel group) {
        if (group.getType() == GroupModel.Type.REALM && this.cached.getGroups(this.keycloakSession, this.modelSupplier).contains(group.getId())) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.joinGroup(group);
    }

    public void leaveGroup(GroupModel group) {
        if (group.getType() == GroupModel.Type.REALM && this.updated == null && !this.cached.getGroups(this.keycloakSession, this.modelSupplier).contains(group.getId())) {
            return;
        }
        this.getDelegateForUpdate();
        this.updated.leaveGroup(group);
    }

    public boolean isMemberOf(GroupModel group) {
        if (this.updated != null) {
            return this.updated.isMemberOf(group);
        }
        return this.cached.getGroups(this.keycloakSession, this.modelSupplier).contains(group.getId()) || RoleUtils.isMember(this.getGroupsStream(), (GroupModel)group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private UserModel getUserModel() {
        return this.userProviderCache.getDelegate().getUserById(this.realm, this.cached.getId());
    }
}

