/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLEncryptedAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLExtensionsParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLStatusParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLStatusResponseTypeParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAMLResponseParser
extends SAMLStatusResponseTypeParser<ResponseType> {
    private static final SAMLResponseParser INSTANCE = new SAMLResponseParser();

    private SAMLResponseParser() {
        super(SAMLProtocolQNames.RESPONSE);
    }

    public static SAMLResponseParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected ResponseType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        SAMLParserUtil.validateAttributeValue(element, SAMLProtocolQNames.ATTR_VERSION, "2.0");
        String id = StaxParserUtil.getRequiredAttributeValue(element, SAMLProtocolQNames.ATTR_ID);
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getRequiredAttributeValue(element, SAMLProtocolQNames.ATTR_ISSUE_INSTANT));
        ResponseType res = new ResponseType(id, issueInstant);
        super.parseBaseAttributes(element, res);
        return res;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, ResponseType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ISSUER: {
                target.setIssuer(SAMLParserUtil.parseNameIDType(xmlEventReader));
                break;
            }
            case SIGNATURE: {
                Element sig = StaxParserUtil.getDOMElement(xmlEventReader);
                target.setSignature(sig);
                break;
            }
            case ASSERTION: {
                target.addAssertion(new ResponseType.RTChoiceType((AssertionType)SAMLAssertionParser.getInstance().parse(xmlEventReader)));
                break;
            }
            case EXTENSIONS: {
                target.setExtensions((ExtensionsType)SAMLExtensionsParser.getInstance().parse(xmlEventReader));
                break;
            }
            case STATUS: {
                target.setStatus((StatusType)SAMLStatusParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ENCRYPTED_ASSERTION: {
                target.addAssertion(new ResponseType.RTChoiceType(SAMLEncryptedAssertionParser.getInstance().parse(xmlEventReader)));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

