/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import org.keycloak.dom.saml.v2.protocol.NameIDPolicyType;

public class SAML2NameIDPolicyBuilder {
    private final NameIDPolicyType policyType = new NameIDPolicyType();
    private Boolean allowCreate;
    private String spNameQualifier;

    private SAML2NameIDPolicyBuilder(String format) {
        this.policyType.setFormat(URI.create(format));
    }

    public static SAML2NameIDPolicyBuilder format(String format) {
        return new SAML2NameIDPolicyBuilder(format);
    }

    public SAML2NameIDPolicyBuilder setAllowCreate(Boolean allowCreate) {
        this.allowCreate = allowCreate;
        return this;
    }

    public SAML2NameIDPolicyBuilder setSPNameQualifier(String spNameQualifier) {
        this.spNameQualifier = spNameQualifier;
        return this;
    }

    public NameIDPolicyType build() {
        if (this.allowCreate != null) {
            this.policyType.setAllowCreate(this.allowCreate);
        }
        if (this.spNameQualifier != null) {
            this.policyType.setSPNameQualifier(this.spNameQualifier);
        }
        return this.policyType;
    }
}

