/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InvokerCleanupTasks;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.AssignabilityCheck;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InvocationTransformer;
import io.quarkus.arc.processor.InvocationTransformerKind;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.smallrye.common.annotation.SuppressForbidden;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.invoke.Invoker;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.JandexReflection;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class InvokerGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(InvokerGenerator.class);
    private final Predicate<DotName> applicationClassPredicate;
    private final IndexView beanArchiveIndex;
    private final BeanDeployment beanDeployment;
    private final AnnotationLiteralProcessor annotationLiterals;
    private final ReflectionRegistration reflectionRegistration;
    private final Predicate<DotName> injectionPointAnnotationsPredicate;
    private final Assignability assignability;
    private static final Map<PrimitiveType, Set<ClassType>> WIDENING_CONVERSIONS_TO = Map.of(PrimitiveType.BOOLEAN, Set.of(), PrimitiveType.BYTE, Set.of(), PrimitiveType.SHORT, Set.of(ClassType.BYTE_CLASS), PrimitiveType.INT, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.LONG, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.INTEGER_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.FLOAT, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.INTEGER_CLASS, ClassType.LONG_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.DOUBLE, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.INTEGER_CLASS, ClassType.LONG_CLASS, ClassType.FLOAT_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.CHAR, Set.of());

    InvokerGenerator(boolean generateSources, Predicate<DotName> applicationClassPredicate, BeanDeployment deployment, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(generateSources);
        this.applicationClassPredicate = applicationClassPredicate;
        this.beanArchiveIndex = deployment.getBeanArchiveIndex();
        this.beanDeployment = deployment;
        this.annotationLiterals = annotationLiterals;
        this.reflectionRegistration = reflectionRegistration;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        this.assignability = new Assignability(deployment.getBeanArchiveIndex());
    }

    Collection<ResourceOutput.Resource> generate(InvokerInfo invoker) {
        Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction = className -> {
            if (className.equals(invoker.className) || className.equals(invoker.wrapperClassName)) {
                return ResourceOutput.Resource.SpecialType.INVOKER;
            }
            return null;
        };
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(invoker.targetBeanClass.name()), specialTypeFunction, this.generateSources);
        this.createInvokerClass(classOutput, invoker);
        this.createInvokerWrapperClass(classOutput, invoker);
        this.createInvokerLazyClass(classOutput, invoker);
        return classOutput.getResources();
    }

    private void createInvokerLazyClass(ClassOutput classOutput, InvokerInfo invoker) {
        if (!invoker.usesLookup) {
            return;
        }
        try (ClassCreator clazz = ClassCreator.builder().classOutput(classOutput).className(invoker.lazyClassName).interfaces(new Class[]{Invoker.class}).build();){
            String invokerClass = invoker.wrapperClassName != null ? invoker.wrapperClassName : invoker.className;
            MethodCreator invoke = clazz.getMethodCreator("invoke", Object.class, new Class[]{Object.class, Object[].class});
            ResultHandle delegateInvoker = invoke.invokeStaticMethod(MethodDescriptor.ofMethod((Object)invokerClass, (String)"get", Invoker.class, (Object[])new Object[0]), new ResultHandle[0]);
            ResultHandle result = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(Invoker.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), delegateInvoker, new ResultHandle[]{invoke.getMethodParam(0), invoke.getMethodParam(1)});
            invoke.returnValue(result);
            LOGGER.debugf("LazyInvoker class generated: %s", (Object)clazz.getClassName());
        }
    }

    private void createInvokerWrapperClass(ClassOutput classOutput, InvokerInfo invoker) {
        if (invoker.wrapperClassName == null) {
            return;
        }
        try (ClassCreator clazz = ClassCreator.builder().classOutput(classOutput).className(invoker.wrapperClassName).interfaces(new Class[]{Invoker.class}).build();){
            ResultHandle result;
            FieldCreator delegate = (FieldCreator)clazz.getFieldCreator("delegate", Invoker.class).setModifiers(18);
            MethodCreator ctor = (MethodCreator)clazz.getMethodCreator("<init>", Void.TYPE, new Class[0]).setModifiers(1);
            ctor.invokeSpecialMethod(MethodDescriptor.ofMethod(Object.class, (String)"<init>", Void.TYPE, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
            ctor.writeInstanceField(delegate.getFieldDescriptor(), ctor.getThis(), ctor.invokeStaticMethod(MethodDescriptor.ofMethod((Object)invoker.className, (String)"get", Invoker.class, (Object[])new Object[0]), new ResultHandle[0]));
            ctor.returnVoid();
            MethodCreator invoke = clazz.getMethodCreator("invoke", Object.class, new Class[]{Object.class, Object[].class});
            ResultHandle targetInstance = invoke.getMethodParam(0);
            ResultHandle argumentsArray = invoke.getMethodParam(1);
            ResultHandle delegateInvoker = invoke.readInstanceField(delegate.getFieldDescriptor(), invoke.getThis());
            MethodInfo wrappingMethod = this.findWrapper(invoker);
            ResultHandle resultHandle = result = invoker.invocationWrapper.clazz.isInterface() ? invoke.invokeStaticInterfaceMethod(wrappingMethod, new ResultHandle[]{targetInstance, argumentsArray, delegateInvoker}) : invoke.invokeStaticMethod(wrappingMethod, new ResultHandle[]{targetInstance, argumentsArray, delegateInvoker});
            if (wrappingMethod.returnType().kind() == Type.Kind.VOID) {
                result = invoke.loadNull();
            }
            invoke.returnValue(result);
            InvokerGenerator.generateStaticGetMethod(clazz, ctor);
            LOGGER.debugf("InvokerWrapper class generated: %s", (Object)clazz.getClassName());
        }
    }

    private MethodInfo findWrapper(InvokerInfo invoker) {
        InvocationTransformer wrapper = invoker.invocationWrapper;
        ClassInfo clazz = this.beanArchiveIndex.getClassByName(wrapper.clazz);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (MethodInfo method : clazz.methods()) {
            if (!Modifier.isStatic(method.flags()) || !wrapper.method.equals(method.name())) continue;
            methods.add(method);
        }
        ArrayList<MethodInfo> matching = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> notMatching = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (method.parametersCount() == 3 && method.parameterType(1).kind() == Type.Kind.ARRAY && method.parameterType(1).asArrayType().deepDimensions() == 1 && method.parameterType(1).asArrayType().elementType().name().equals((Object)DotName.OBJECT_NAME) && method.parameterType(2).name().equals((Object)DotName.createSimple(Invoker.class))) {
                boolean invokerTargetInstanceOk;
                Type targetInstanceType = method.parameterType(0);
                boolean targetInstanceOk = InvokerGenerator.isAnyType(targetInstanceType) || this.assignability.isSupertype(targetInstanceType, (Type)ClassType.create((DotName)invoker.targetBeanClass.name()));
                boolean isInvokerRaw = method.parameterType(2).kind() == Type.Kind.CLASS;
                boolean isInvokerParameterized = method.parameterType(2).kind() == Type.Kind.PARAMETERIZED_TYPE && method.parameterType(2).asParameterizedType().arguments().size() == 2;
                boolean bl = invokerTargetInstanceOk = isInvokerRaw || isInvokerParameterized && targetInstanceType.equals(method.parameterType(2).asParameterizedType().arguments().get(0));
                if (targetInstanceOk && invokerTargetInstanceOk) {
                    matching.add(method);
                    continue;
                }
                notMatching.add(method);
                continue;
            }
            notMatching.add(method);
        }
        if (matching.size() == 1) {
            return (MethodInfo)matching.get(0);
        }
        if (matching.isEmpty()) {
            String expectation = "\tmatching methods must be `static` and take 3 parameters (instance, argument array, invoker)\n\tthe 1st parameter must be a supertype of " + String.valueOf(invoker.targetBeanClass.name()) + ", possibly Object\n\tthe 2nd parameter must be Object[]\n\tthe 3rd parameter must be Invoker<type of 1st parameter, some type>";
            if (notMatching.isEmpty()) {
                throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(invoker) + ":\n\tno matching method found for " + String.valueOf(wrapper) + "\n" + expectation);
            }
            throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(invoker) + ":\n\tno matching method found for " + String.valueOf(wrapper) + "\n\tfound methods that do not match:\n" + notMatching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")) + "\n" + expectation);
        }
        throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(invoker) + ":\n\ttoo many matching methods for " + String.valueOf(wrapper) + ":\n" + matching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")));
    }

    private void createInvokerClass(ClassOutput classOutput, InvokerInfo invoker) {
        MethodInfo targetMethod = invoker.method;
        try (ClassCreator clazz = ClassCreator.builder().classOutput(classOutput).className(invoker.className).interfaces(new Class[]{Invoker.class}).build();){
            ResultHandle result;
            FieldCreator instance = (FieldCreator)clazz.getFieldCreator("INSTANCE", AtomicReference.class).setModifiers(26);
            MethodCreator clinit = (MethodCreator)clazz.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
            clinit.writeStaticField(instance.getFieldDescriptor(), clinit.newInstance(MethodDescriptor.ofConstructor(AtomicReference.class, (Class[])new Class[0]), new ResultHandle[0]));
            clinit.returnVoid();
            MethodCreator ctor = (MethodCreator)clazz.getMethodCreator("<init>", Void.TYPE, new Class[0]).setModifiers(1);
            ctor.invokeSpecialMethod(MethodDescriptor.ofMethod(Object.class, (String)"<init>", Void.TYPE, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
            MethodCreator invoke = clazz.getMethodCreator("invoke", Object.class, new Class[]{Object.class, Object[].class});
            FinisherGenerator finisher = new FinisherGenerator(invoke);
            LookupGenerator lookup = this.prepareLookup(invoke, invoker, ctor, clazz, classOutput);
            ResultHandle targetInstance = null;
            if (!Modifier.isStatic(targetMethod.flags())) {
                ClassType instanceType = ClassType.create((DotName)invoker.targetBeanClass.name());
                targetInstance = invoker.instanceLookup ? lookup.targetBeanInstance() : invoke.getMethodParam(0);
                targetInstance = this.findAndInvokeTransformer(invoker.instanceTransformer, (Type)instanceType, invoker, targetInstance, (BytecodeCreator)invoke, finisher);
            }
            ResultHandle argumentsArray = invoke.getMethodParam(1);
            ResultHandle[] unfoldedArguments = new ResultHandle[targetMethod.parametersCount()];
            for (int i = 0; i < targetMethod.parametersCount(); ++i) {
                Type parameterType = targetMethod.parameterType(i);
                ResultHandle originalArgument = invoker.argumentLookups[i] ? lookup.argumentBeanInstance(i) : invoke.readArrayValue(argumentsArray, i);
                originalArgument = this.findAndInvokeTransformer(invoker.argumentTransformers[i], parameterType, invoker, originalArgument, (BytecodeCreator)invoke, finisher);
                if (parameterType.kind() == Type.Kind.PRIMITIVE) {
                    Type transformedType = this.transformerReturnType(invoker.argumentTransformers[i], parameterType, invoker);
                    if (transformedType != null && transformedType.kind() == Type.Kind.PRIMITIVE) {
                        originalArgument = invoke.checkCast(originalArgument, PrimitiveType.box((PrimitiveType)parameterType.asPrimitiveType()).name().toString());
                    }
                    BranchResult ifNotNull = invoke.ifNotNull(originalArgument);
                    AssignableResultHandle variable = invoke.createVariable(parameterType.descriptor());
                    InvokerGenerator.assignWithUnboxingAndWideningConversion(ifNotNull.trueBranch(), originalArgument, variable, parameterType.asPrimitiveType(), i);
                    originalArgument = variable;
                    ifNotNull.falseBranch().throwException(NullPointerException.class, "Argument " + i + " is null, " + String.valueOf(parameterType) + " expected");
                }
                unfoldedArguments[i] = originalArgument;
            }
            ctor.returnVoid();
            if (lookup != null && invoker.argumentLookups.length > 0) {
                invoke.readArrayValue(argumentsArray, invoker.argumentLookups.length - 1);
            }
            TryBlock tryBlock = invoke.tryBlock();
            CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
            if (finisher.wasCreated()) {
                catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(InvokerCleanupTasks.class, (String)"finish", Void.TYPE, (Class[])new Class[0]), finisher.getOrCreate(), new ResultHandle[0]);
            }
            if (lookup != null) {
                lookup.destroyIfNecessary((BytecodeCreator)catchBlock, null);
            }
            if (invoker.exceptionTransformer != null) {
                catchBlock.returnValue(this.findAndInvokeTransformer(invoker.exceptionTransformer, (Type)ClassType.create(Throwable.class), invoker, catchBlock.getCaughtException(), (BytecodeCreator)catchBlock, null));
            } else {
                catchBlock.throwException(catchBlock.getCaughtException());
            }
            boolean isInterface = invoker.method.declaringClass().isInterface();
            if (Modifier.isStatic(targetMethod.flags())) {
                result = isInterface ? tryBlock.invokeStaticInterfaceMethod(targetMethod, unfoldedArguments) : tryBlock.invokeStaticMethod(targetMethod, unfoldedArguments);
            } else {
                ResultHandle resultHandle = result = isInterface ? tryBlock.invokeInterfaceMethod(targetMethod, targetInstance, unfoldedArguments) : tryBlock.invokeVirtualMethod(targetMethod, targetInstance, unfoldedArguments);
            }
            if (targetMethod.returnType().kind() == Type.Kind.VOID) {
                result = tryBlock.loadNull();
            }
            if (lookup != null) {
                result = lookup.destroyIfNecessary((BytecodeCreator)tryBlock, result);
            }
            result = this.findAndInvokeTransformer(invoker.returnValueTransformer, targetMethod.returnType(), invoker, result, (BytecodeCreator)tryBlock, null);
            if (finisher.wasCreated()) {
                tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(InvokerCleanupTasks.class, (String)"finish", Void.TYPE, (Class[])new Class[0]), finisher.getOrCreate(), new ResultHandle[0]);
            }
            tryBlock.returnValue(result);
            InvokerGenerator.generateStaticGetMethod(clazz, ctor);
            LOGGER.debugf("Invoker class generated: %s", (Object)clazz.getClassName());
        }
    }

    private static void generateStaticGetMethod(ClassCreator clazz, MethodCreator ctor) {
        FieldCreator instance = (FieldCreator)clazz.getFieldCreator("INSTANCE", AtomicReference.class).setModifiers(26);
        MethodCreator clinit = (MethodCreator)clazz.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
        clinit.writeStaticField(instance.getFieldDescriptor(), clinit.newInstance(MethodDescriptor.ofConstructor(AtomicReference.class, (Class[])new Class[0]), new ResultHandle[0]));
        clinit.returnVoid();
        MethodCreator get = (MethodCreator)clazz.getMethodCreator("get", Invoker.class, new Class[0]).setModifiers(9);
        ResultHandle atomicReference = get.readStaticField(instance.getFieldDescriptor());
        AssignableResultHandle resultInstance = get.createVariable(Invoker.class);
        get.assign(resultInstance, get.invokeVirtualMethod(MethodDescriptor.ofMethod(AtomicReference.class, (String)"get", Object.class, (Class[])new Class[0]), atomicReference, new ResultHandle[0]));
        BytecodeCreator isNull = get.ifNotNull((ResultHandle)resultInstance).falseBranch();
        isNull.invokeVirtualMethod(MethodDescriptor.ofMethod(AtomicReference.class, (String)"compareAndSet", Boolean.TYPE, (Class[])new Class[]{Object.class, Object.class}), atomicReference, new ResultHandle[]{isNull.loadNull(), isNull.newInstance(ctor.getMethodDescriptor(), new ResultHandle[0])});
        isNull.assign(resultInstance, isNull.invokeVirtualMethod(MethodDescriptor.ofMethod(AtomicReference.class, (String)"get", Object.class, (Class[])new Class[0]), atomicReference, new ResultHandle[0]));
        get.returnValue((ResultHandle)resultInstance);
    }

    private static void assignWithUnboxingAndWideningConversion(BytecodeCreator bytecode, ResultHandle value, AssignableResultHandle target, PrimitiveType targetType, int argumentNumber) {
        ClassType possibleSourceType = PrimitiveType.box((PrimitiveType)targetType);
        ResultHandle isInstance = bytecode.instanceOf(value, possibleSourceType.name().toString());
        BranchResult ifNotInstanceOf = bytecode.ifFalse(isInstance);
        ifNotInstanceOf.falseBranch().assign(target, value);
        bytecode = ifNotInstanceOf.trueBranch();
        for (ClassType possibleSourceType2 : WIDENING_CONVERSIONS_TO.get(targetType)) {
            ResultHandle isInstance2 = bytecode.instanceOf(value, possibleSourceType2.name().toString());
            BranchResult ifNotInstanceOf2 = bytecode.ifFalse(isInstance2);
            BytecodeCreator unbox = ifNotInstanceOf2.falseBranch();
            AssignableResultHandle unboxed = unbox.createVariable(PrimitiveType.unbox((ClassType)possibleSourceType2).descriptor());
            unbox.assign(unboxed, value);
            ResultHandle widened = unbox.convertPrimitive((ResultHandle)unboxed, JandexReflection.loadRawType((Type)targetType));
            unbox.assign(target, widened);
            bytecode = ifNotInstanceOf2.trueBranch();
        }
        ResultHandle message = Gizmo.newStringBuilder((BytecodeCreator)bytecode).append("No method invocation conversion to ").append(targetType.name().toString()).append(" exists for argument ").append("" + argumentNumber).append(": ").append(bytecode.invokeVirtualMethod(MethodDescriptors.OBJECT_GET_CLASS, value, new ResultHandle[0])).append(", value ").append(value).callToString();
        ResultHandle exception = bytecode.newInstance(MethodDescriptor.ofConstructor(ClassCastException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{message});
        bytecode.throwException(exception);
    }

    private LookupGenerator prepareLookup(MethodCreator invokeMethod, InvokerInfo invoker, MethodCreator invokerConstructor, ClassCreator invokerClass, ClassOutput classOutput) {
        boolean lookupUsed = invoker.instanceLookup;
        for (boolean argumentLookup : invoker.argumentLookups) {
            lookupUsed |= argumentLookup;
        }
        if (!lookupUsed) {
            return null;
        }
        ResolvedBean targetInstance = null;
        if (invoker.instanceLookup) {
            targetInstance = ResolvedBean.of(invoker.targetBean);
        }
        ResolvedBean[] arguments = new ResolvedBean[invoker.argumentLookups.length];
        for (int i = 0; i < invoker.argumentLookups.length; ++i) {
            if (!invoker.argumentLookups[i]) continue;
            InjectionPointInfo injectionPoint = invoker.getInjectionPointForArgument(i);
            if (injectionPoint != null) {
                arguments[i] = ResolvedBean.of(injectionPoint);
                continue;
            }
            throw new IllegalStateException("No injection point for argument " + i + " of " + String.valueOf(invoker));
        }
        return new LookupGenerator(this.beanDeployment, this.annotationLiterals, this.reflectionRegistration, this.injectionPointAnnotationsPredicate, invoker, targetInstance, arguments, invokeMethod, invokerConstructor, invokerClass, classOutput);
    }

    private ResultHandle findAndInvokeTransformer(InvocationTransformer transformer, Type expectedType, InvokerInfo invoker, ResultHandle originalValue, BytecodeCreator bytecode, FinisherGenerator finisher) {
        if (transformer == null) {
            return originalValue;
        }
        CandidateMethods candidates = this.findCandidates(transformer, expectedType, invoker);
        CandidateMethod transformerMethod = candidates.resolve();
        MethodDescriptor transformerMethodDescriptor = MethodDescriptor.of((MethodInfo)transformerMethod.method);
        if (Modifier.isStatic(transformerMethod.method.flags())) {
            ResultHandle[] arguments = new ResultHandle[transformerMethod.usesFinisher() ? 2 : 1];
            arguments[0] = originalValue;
            if (transformerMethod.usesFinisher()) {
                arguments[1] = finisher.getOrCreate();
            }
            if (transformer.clazz.isInterface()) {
                return bytecode.invokeStaticInterfaceMethod(transformerMethodDescriptor, arguments);
            }
            return bytecode.invokeStaticMethod(transformerMethodDescriptor, arguments);
        }
        if (transformer.clazz.isInterface()) {
            return bytecode.invokeInterfaceMethod(transformerMethodDescriptor, originalValue, new ResultHandle[0]);
        }
        return bytecode.invokeVirtualMethod(transformerMethodDescriptor, originalValue, new ResultHandle[0]);
    }

    private Type transformerReturnType(InvocationTransformer transformer, Type expectedType, InvokerInfo invoker) {
        if (transformer == null) {
            return null;
        }
        CandidateMethods candidates = this.findCandidates(transformer, expectedType, invoker);
        CandidateMethod transformerMethod = candidates.resolve();
        return transformerMethod.method.returnType();
    }

    private CandidateMethods findCandidates(InvocationTransformer transformer, Type expectedType, InvokerInfo invoker) {
        assert (transformer.kind != InvocationTransformerKind.WRAPPER);
        ClassInfo clazz = this.beanArchiveIndex.getClassByName(transformer.clazz);
        ArrayDeque<ClassInfo> worklist = new ArrayDeque<ClassInfo>();
        while (clazz != null) {
            worklist.addLast(clazz);
            clazz = clazz.superName() == null ? null : this.beanArchiveIndex.getClassByName(clazz.superName());
        }
        boolean originalClass = true;
        HashSet<Methods.MethodKey> seenMethods = new HashSet<Methods.MethodKey>();
        while (!worklist.isEmpty()) {
            ClassInfo current = (ClassInfo)worklist.removeFirst();
            for (MethodInfo method : current.methods()) {
                if (!transformer.method.equals(method.name())) continue;
                Methods.MethodKey key = new Methods.MethodKey(method);
                if (Modifier.isStatic(method.flags()) && originalClass) {
                    seenMethods.add(key);
                    continue;
                }
                if (Methods.isOverriden(key, seenMethods)) continue;
                seenMethods.add(key);
            }
            for (DotName iface : current.interfaceNames()) {
                worklist.addLast(this.beanArchiveIndex.getClassByName(iface));
            }
            originalClass = false;
        }
        ArrayList<CandidateMethod> matching = new ArrayList<CandidateMethod>();
        ArrayList<CandidateMethod> notMatching = new ArrayList<CandidateMethod>();
        for (Methods.MethodKey seenMethod : seenMethods) {
            CandidateMethod candidate = new CandidateMethod(seenMethod.method, this.assignability);
            if (candidate.matches(transformer, expectedType)) {
                matching.add(candidate);
                continue;
            }
            notMatching.add(candidate);
        }
        return new CandidateMethods(transformer, expectedType, matching, notMatching, invoker);
    }

    static boolean isAnyType(Type t) {
        if (ClassType.OBJECT_TYPE.equals((Object)t)) {
            return true;
        }
        if (t.kind() == Type.Kind.TYPE_VARIABLE) {
            TypeVariable typeVar = t.asTypeVariable();
            return typeVar.bounds().isEmpty() || InvokerGenerator.isAnyType((Type)typeVar.bounds().get(0));
        }
        return false;
    }

    static class Assignability {
        private final AssignabilityCheck assignabilityCheck;

        Assignability(IndexView index) {
            this.assignabilityCheck = new AssignabilityCheck(index, null);
        }

        boolean isSubtype(Type a, Type b) {
            Objects.requireNonNull(a);
            Objects.requireNonNull(b);
            switch (a.kind()) {
                case VOID: {
                    return b.kind() == Type.Kind.VOID || b.kind() == Type.Kind.CLASS && b.asClassType().name().equals((Object)DotName.createSimple(Void.class));
                }
                case PRIMITIVE: {
                    return b.kind() == Type.Kind.PRIMITIVE && a.asPrimitiveType().primitive() == b.asPrimitiveType().primitive();
                }
                case ARRAY: {
                    return b.kind() == Type.Kind.ARRAY && a.asArrayType().deepDimensions() == b.asArrayType().deepDimensions() && this.isSubtype(a.asArrayType().elementType(), b.asArrayType().elementType());
                }
                case CLASS: {
                    if (b.kind() == Type.Kind.VOID) {
                        return a.asClassType().name().equals((Object)DotName.createSimple(Void.class));
                    }
                    if (b.kind() == Type.Kind.CLASS) {
                        return this.isClassSubtype(a.asClassType(), b.asClassType());
                    }
                    if (b.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        return this.isClassSubtype(a.asClassType(), ClassType.create((DotName)b.name()));
                    }
                    if (b.kind() == Type.Kind.TYPE_VARIABLE) {
                        ClassType firstBound = b.asTypeVariable().bounds().isEmpty() ? ClassType.OBJECT_TYPE : (Type)b.asTypeVariable().bounds().get(0);
                        return this.isSubtype(a, (Type)firstBound);
                    }
                    return false;
                }
                case PARAMETERIZED_TYPE: {
                    if (b.kind() == Type.Kind.CLASS) {
                        return this.isClassSubtype(ClassType.create((DotName)a.name()), b.asClassType());
                    }
                    if (b.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        return this.isClassSubtype(ClassType.create((DotName)a.name()), ClassType.create((DotName)b.name()));
                    }
                    if (b.kind() == Type.Kind.TYPE_VARIABLE) {
                        ClassType firstBound = b.asTypeVariable().bounds().isEmpty() ? ClassType.OBJECT_TYPE : (Type)b.asTypeVariable().bounds().get(0);
                        return this.isSubtype(a, (Type)firstBound);
                    }
                    return false;
                }
                case TYPE_VARIABLE: {
                    if (b.kind() == Type.Kind.CLASS || b.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        ClassType firstBound = a.asTypeVariable().bounds().isEmpty() ? ClassType.OBJECT_TYPE : (Type)a.asTypeVariable().bounds().get(0);
                        return this.isSubtype((Type)firstBound, b);
                    }
                    return false;
                }
            }
            throw new IllegalArgumentException("Cannot determine assignability between " + String.valueOf(a) + " and " + String.valueOf(b));
        }

        boolean isSupertype(Type a, Type b) {
            return this.isSubtype(b, a);
        }

        private boolean isClassSubtype(ClassType a, ClassType b) {
            return this.assignabilityCheck.isAssignableFrom((Type)b, (Type)a);
        }
    }

    static class FinisherGenerator {
        private final MethodCreator method;
        private ResultHandle finisher;

        FinisherGenerator(MethodCreator method) {
            this.method = method;
        }

        ResultHandle getOrCreate() {
            if (this.finisher == null) {
                this.finisher = this.method.newInstance(MethodDescriptor.ofConstructor(InvokerCleanupTasks.class, (Class[])new Class[0]), new ResultHandle[0]);
            }
            return this.finisher;
        }

        boolean wasCreated() {
            return this.finisher != null;
        }
    }

    static class LookupGenerator {
        private final BeanDeployment beanDeployment;
        private final AnnotationLiteralProcessor annotationLiterals;
        private final ReflectionRegistration reflectionRegistration;
        private final Predicate<DotName> injectionPointAnnotationsPredicate;
        private final InvokerInfo invoker;
        private final ResolvedBean targetBean;
        private final ResolvedBean[] argumentBeans;
        private final MethodCreator invokeMethod;
        private final MethodCreator invokerConstructor;
        private final ClassCreator invokerClass;
        private final ClassOutput classOutput;
        private ResultHandle arc;
        private ResultHandle rootCreationalContext;

        LookupGenerator(BeanDeployment beanDeployment, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate, InvokerInfo invoker, ResolvedBean targetBean, ResolvedBean[] argumentBeans, MethodCreator invokeMethod, MethodCreator invokerConstructor, ClassCreator invokerClass, ClassOutput classOutput) {
            this.beanDeployment = beanDeployment;
            this.annotationLiterals = annotationLiterals;
            this.reflectionRegistration = reflectionRegistration;
            this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
            this.invoker = invoker;
            this.targetBean = targetBean;
            this.argumentBeans = argumentBeans;
            this.invokeMethod = invokeMethod;
            this.invokerConstructor = invokerConstructor;
            this.invokerClass = invokerClass;
            this.classOutput = classOutput;
        }

        ResultHandle arc() {
            if (this.arc == null) {
                this.arc = this.invokerConstructor.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
            }
            return this.arc;
        }

        ResultHandle rootCreationalContext() {
            if (this.rootCreationalContext == null) {
                this.rootCreationalContext = this.invokeMethod.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{this.invokeMethod.loadNull()});
            }
            return this.rootCreationalContext;
        }

        ResultHandle targetBeanInstance() {
            String name = "target";
            FieldCreator field = (FieldCreator)this.invokerClass.getFieldCreator(name, Supplier.class).setModifiers(18);
            ResultHandle bean = this.invokerConstructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), this.arc(), new ResultHandle[]{this.invokerConstructor.load(this.targetBean.getUserBean().getIdentifier())});
            this.invokerConstructor.writeInstanceField(field.getFieldDescriptor(), this.invokerConstructor.getThis(), bean);
            ResultHandle supplier = this.invokeMethod.readInstanceField(field.getFieldDescriptor(), this.invokeMethod.getThis());
            ResultHandle injectableReferenceProvider = this.invokeMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, supplier, new ResultHandle[0]);
            ResultHandle creationalContext = this.invokeMethod.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{injectableReferenceProvider, this.rootCreationalContext()});
            return this.invokeMethod.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, injectableReferenceProvider, new ResultHandle[]{creationalContext});
        }

        ResultHandle argumentBeanInstance(int position) {
            String name = "arg" + position;
            FieldCreator field = (FieldCreator)this.invokerClass.getFieldCreator(name, Supplier.class).setModifiers(18);
            ResolvedBean resolved = this.argumentBeans[position];
            if (resolved.isUserBean()) {
                ResultHandle bean = this.invokerConstructor.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), this.arc(), new ResultHandle[]{this.invokerConstructor.load(resolved.getUserBean().getIdentifier())});
                this.invokerConstructor.writeInstanceField(field.getFieldDescriptor(), this.invokerConstructor.getThis(), bean);
            } else {
                BuiltinBean builtinBean = resolved.getBuiltinBean();
                InjectionPointInfo injectionPoint = this.invoker.getInjectionPointForArgument(position);
                builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(this.classOutput, this.beanDeployment, injectionPoint, this.invokerClass, this.invokerConstructor, name, this.annotationLiterals, this.invoker, this.reflectionRegistration, this.injectionPointAnnotationsPredicate));
            }
            ResultHandle supplier = this.invokeMethod.readInstanceField(field.getFieldDescriptor(), this.invokeMethod.getThis());
            ResultHandle injectableReferenceProvider = this.invokeMethod.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, supplier, new ResultHandle[0]);
            ResultHandle creationalContext = this.invokeMethod.invokeStaticMethod(MethodDescriptors.CREATIONAL_CTX_CHILD_CONTEXTUAL, new ResultHandle[]{injectableReferenceProvider, this.rootCreationalContext()});
            return this.invokeMethod.invokeInterfaceMethod(MethodDescriptors.INJECTABLE_REF_PROVIDER_GET, injectableReferenceProvider, new ResultHandle[]{creationalContext});
        }

        ResultHandle destroyIfNecessary(BytecodeCreator bytecode, ResultHandle returnValue) {
            if (this.rootCreationalContext == null) {
                return returnValue;
            }
            if (returnValue != null && this.invoker.isAsynchronous()) {
                String asyncType = this.invoker.method.returnType().name().toString();
                return bytecode.invokeStaticMethod(MethodDescriptor.ofMethod(InvokerCleanupTasks.class, (String)"deferRelease", (Object)asyncType, (Object[])new Object[]{CreationalContext.class, asyncType}), new ResultHandle[]{this.rootCreationalContext(), returnValue});
            }
            bytecode.invokeInterfaceMethod(MethodDescriptors.CREATIONAL_CTX_RELEASE, this.rootCreationalContext(), new ResultHandle[0]);
            return returnValue;
        }
    }

    static class ResolvedBean {
        private final BeanInfo userBean;
        private final BuiltinBean builtinBean;

        static ResolvedBean of(BeanInfo userBean) {
            return new ResolvedBean(userBean, null);
        }

        static ResolvedBean of(InjectionPointInfo injectionPoint) {
            BeanInfo userBean = injectionPoint.getResolvedBean();
            if (userBean != null) {
                return new ResolvedBean(userBean, null);
            }
            BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
            if (builtinBean != null) {
                return new ResolvedBean(null, builtinBean);
            }
            throw new IllegalStateException("Injection point not resolved: " + String.valueOf(injectionPoint));
        }

        private ResolvedBean(BeanInfo userBean, BuiltinBean builtinBean) {
            this.userBean = userBean;
            this.builtinBean = builtinBean;
        }

        boolean isUserBean() {
            return this.userBean != null;
        }

        boolean isBuiltinBean() {
            return this.builtinBean != null;
        }

        BeanInfo getUserBean() {
            assert (this.isUserBean());
            return this.userBean;
        }

        BuiltinBean getBuiltinBean() {
            assert (this.isBuiltinBean());
            return this.builtinBean;
        }

        boolean requiresDestruction() {
            return this.userBean != null && BuiltinScope.DEPENDENT.is(this.userBean.getScope());
        }
    }

    static class CandidateMethods {
        final InvocationTransformer transformer;
        final Type expectedType;
        final List<CandidateMethod> matching;
        final List<CandidateMethod> notMatching;
        final InvokerInfo invoker;

        CandidateMethods(InvocationTransformer transformer, Type expectedType, List<CandidateMethod> matching, List<CandidateMethod> notMatching, InvokerInfo invoker) {
            this.transformer = transformer;
            this.expectedType = expectedType;
            this.matching = matching;
            this.notMatching = notMatching;
            this.invoker = invoker;
        }

        @SuppressForbidden(reason="Using Type.toString() to build an informative message")
        CandidateMethod resolve() {
            if (this.matching.size() == 1) {
                return this.matching.get(0);
            }
            if (this.matching.isEmpty()) {
                String expectedType = this.expectedType.toString();
                Object expectation = "";
                if (this.transformer.isInputTransformer()) {
                    expectation = "\n\tmatching `static` methods must take 1 or 2 parameters and return " + expectedType + " (or subtype)\n\t(if the `static` method takes 2 parameters, the 2nd must be `Consumer<Runnable>`)\n\tmatching instance methods must take no parameter and return " + expectedType + " (or subtype)";
                } else if (this.transformer.isOutputTransformer()) {
                    expectation = "\n\tmatching `static` method must take 1 parameter of type " + expectedType + " (or supertype)\n\tmatching instance methods must be declared on " + expectedType + " (or supertype) and take no parameter";
                }
                if (this.notMatching.isEmpty()) {
                    throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(this.invoker) + ":\n\tno matching method found for " + String.valueOf(this.transformer) + (String)expectation);
                }
                throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(this.invoker) + ":\n\tno matching method found for " + String.valueOf(this.transformer) + "\n\tfound methods that do not match:\n" + this.notMatching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")) + (String)expectation);
            }
            throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(this.invoker) + ":\n\ttoo many matching methods for " + String.valueOf(this.transformer) + ":\n" + this.matching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")));
        }
    }

    static class CandidateMethod {
        final MethodInfo method;
        final Assignability assignability;

        CandidateMethod(MethodInfo method, Assignability assignability) {
            this.method = method;
            this.assignability = assignability;
        }

        boolean matches(InvocationTransformer transformer, Type expectedType) {
            if (transformer.isInputTransformer()) {
                boolean returnTypeOk;
                boolean bl = returnTypeOk = InvokerGenerator.isAnyType(this.method.returnType()) || this.isSubtype(this.method.returnType(), expectedType);
                if (Modifier.isStatic(this.method.flags())) {
                    return this.method.parametersCount() == 1 && returnTypeOk || this.method.parametersCount() == 2 && returnTypeOk && this.isFinisher(this.method.parameterType(1));
                }
                return this.method.parametersCount() == 0 && returnTypeOk;
            }
            if (transformer.isOutputTransformer()) {
                if (Modifier.isStatic(this.method.flags())) {
                    return this.method.parametersCount() == 1 && (InvokerGenerator.isAnyType(this.method.parameterType(0)) || this.isSupertype(this.method.parameterType(0), expectedType));
                }
                return this.method.parametersCount() == 0 && this.isSupertype((Type)ClassType.create((DotName)this.method.declaringClass().name()), expectedType);
            }
            throw new IllegalArgumentException(transformer.toString());
        }

        boolean usesFinisher() {
            return Modifier.isStatic(this.method.flags()) && this.method.parametersCount() == 2 && this.isFinisher(this.method.parameterType(1));
        }

        private boolean isFinisher(Type type) {
            if (type.kind() == Type.Kind.CLASS) {
                return type.name().equals((Object)DotName.createSimple(Consumer.class));
            }
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                return type.name().equals((Object)DotName.createSimple(Consumer.class)) && type.asParameterizedType().arguments().size() == 1 && ((Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS && ((Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)DotName.createSimple(Runnable.class));
            }
            return false;
        }

        private boolean isSubtype(Type a, Type b) {
            return this.assignability.isSubtype(a, b);
        }

        private boolean isSupertype(Type a, Type b) {
            return this.assignability.isSupertype(a, b);
        }

        public String toString() {
            return this.method.toString() + " declared on " + String.valueOf(this.method.declaringClass());
        }
    }
}

