/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.h2.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Scanner;
import java.util.function.BiConsumer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class H2Reflections
implements Feature {
    public static final String REZ_NAME_DATA_TYPE_SINGLETONS = "h2BasicDataTypeSingletons.classlist";
    public static final String REZ_NAME_STATEFUL_DATATYPES = "h2StatefulDataType.classlist";

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class metaType = access.findClassByName("org.h2.mvstore.type.MetaType");
        access.registerReachabilityHandler(this::metaTypeReachable, new Object[]{metaType});
    }

    private void metaTypeReachable(Feature.DuringAnalysisAccess access) {
        this.register(REZ_NAME_DATA_TYPE_SINGLETONS, this::registerSingletonAccess, access);
        this.register(REZ_NAME_STATEFUL_DATATYPES, this::registerForReflection, access);
    }

    void register(String resourceName, BiConsumer<String, Feature.DuringAnalysisAccess> action, Feature.DuringAnalysisAccess access) {
        try (InputStream resource = access.getApplicationClassLoader().getResourceAsStream(resourceName);){
            Scanner s = new Scanner(resource);
            while (s.hasNext()) {
                String className = s.next();
                action.accept(className, access);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void registerSingletonAccess(String className, Feature.DuringAnalysisAccess access) {
        try {
            Field instance = access.findClassByName(className).getDeclaredField("INSTANCE");
            RuntimeReflection.register((Field[])new Field[]{instance});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    void registerForReflection(String className, Feature.DuringAnalysisAccess duringAnalysisAccess) {
        Class aClass = duringAnalysisAccess.findClassByName(className);
        Executable[] z = aClass.getDeclaredConstructors();
        RuntimeReflection.register((Class[])new Class[]{aClass});
        RuntimeReflection.register((Executable[])z);
    }

    public String getDescription() {
        return "Support for H2 Database's extended data types";
    }
}

