/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.comms;

import io.quarkus.arc.Arc;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.comms.JsonRpcMessage;
import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.devui.runtime.comms.ReflectionInfo;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcCodec;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequest;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.core.http.ServerWebSocket;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import org.jboss.logging.Logger;

public class JsonRpcRouter {
    private final Map<Integer, Cancellable> subscriptions = new ConcurrentHashMap<Integer, Cancellable>();
    private final Map<String, ReflectionInfo> jsonRpcToRuntimeClassPathJava = new HashMap<String, ReflectionInfo>();
    private final List<String> jsonRpcMethodToDeploymentClassPathJava = new ArrayList<String>();
    private final List<String> jsonRpcSubscriptionToDeploymentClassPathJava = new ArrayList<String>();
    private final Map<String, RuntimeValue> recordedValues = new HashMap<String, RuntimeValue>();
    private static final List<ServerWebSocket> SESSIONS = Collections.synchronizedList(new ArrayList());
    private JsonRpcCodec codec;
    @Inject
    Logger logger;
    private static final String DOT = ".";
    private static final String UNSUBSCRIBE = "unsubscribe";

    public void populateJsonRPCRuntimeMethods(Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap) {
        for (Map.Entry<String, Map<JsonRpcMethodName, JsonRpcMethod>> extension : extensionMethodsMap.entrySet()) {
            String extensionName = extension.getKey();
            Map<JsonRpcMethodName, JsonRpcMethod> jsonRpcMethods = extension.getValue();
            for (Map.Entry<JsonRpcMethodName, JsonRpcMethod> method : jsonRpcMethods.entrySet()) {
                JsonRpcMethodName methodName = method.getKey();
                JsonRpcMethod jsonRpcMethod = method.getValue();
                Object providerInstance = Arc.container().select(jsonRpcMethod.getClazz(), new Annotation[0]).get();
                try {
                    Method javaMethod;
                    Map<String, Class> params = null;
                    if (jsonRpcMethod.hasParams()) {
                        params = jsonRpcMethod.getParams();
                        javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getMethodName(), params.values().toArray(new Class[0]));
                    } else {
                        javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getMethodName(), new Class[0]);
                    }
                    ReflectionInfo reflectionInfo = new ReflectionInfo(jsonRpcMethod.getClazz(), providerInstance, javaMethod, params, jsonRpcMethod.getExplicitlyBlocking(), jsonRpcMethod.getExplicitlyNonBlocking());
                    String jsonRpcMethodName = extensionName + DOT + String.valueOf(methodName);
                    this.jsonRpcToRuntimeClassPathJava.put(jsonRpcMethodName, reflectionInfo);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public void setJsonRPCDeploymentActions(List<String> methods, List<String> subscriptions) {
        this.jsonRpcMethodToDeploymentClassPathJava.clear();
        this.jsonRpcMethodToDeploymentClassPathJava.addAll(methods);
        this.jsonRpcSubscriptionToDeploymentClassPathJava.clear();
        this.jsonRpcSubscriptionToDeploymentClassPathJava.addAll(subscriptions);
    }

    public void setRecordedValues(Map<String, RuntimeValue> recordedValues) {
        this.recordedValues.clear();
        this.recordedValues.putAll(recordedValues);
    }

    public void initializeCodec(JsonMapper jsonMapper) {
        this.codec = new JsonRpcCodec(jsonMapper);
    }

    public void addSocket(ServerWebSocket socket) {
        SESSIONS.add(socket);
        socket.textMessageHandler(e -> {
            JsonRpcRequest jsonRpcRequest = this.codec.readRequest((String)e);
            this.route(jsonRpcRequest, socket);
        }).closeHandler(e -> this.purge());
        this.purge();
    }

    void onStart(@Observes StartupEvent ev) {
        this.purge();
        for (ServerWebSocket s : new ArrayList<ServerWebSocket>(SESSIONS)) {
            if (s.isClosed()) continue;
            this.codec.writeResponse(s, -1, LocalDateTime.now().toString(), MessageType.HotReload);
        }
    }

    private void purge() {
        for (ServerWebSocket s : new ArrayList<ServerWebSocket>(SESSIONS)) {
            if (!s.isClosed()) continue;
            SESSIONS.remove(s);
        }
    }

    private void route(JsonRpcRequest jsonRpcRequest, ServerWebSocket s) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        if (jsonRpcMethodName.equalsIgnoreCase(UNSUBSCRIBE)) {
            this.routeUnsubscribe(jsonRpcRequest, s);
        } else if (this.jsonRpcToRuntimeClassPathJava.containsKey(jsonRpcMethodName)) {
            this.routeToRuntime(jsonRpcRequest, s);
        } else if (this.jsonRpcMethodToDeploymentClassPathJava.contains(jsonRpcMethodName) || this.jsonRpcSubscriptionToDeploymentClassPathJava.contains(jsonRpcMethodName)) {
            this.routeToDeployment(jsonRpcRequest, s);
        } else {
            this.codec.writeMethodNotFoundResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName);
        }
    }

    private void routeUnsubscribe(JsonRpcRequest jsonRpcRequest, ServerWebSocket s) {
        if (this.subscriptions.containsKey(jsonRpcRequest.getId())) {
            Cancellable cancellable = this.subscriptions.remove(jsonRpcRequest.getId());
            cancellable.cancel();
        }
        this.codec.writeResponse(s, jsonRpcRequest.getId(), null, MessageType.Void);
    }

    private void routeToRuntime(JsonRpcRequest jsonRpcRequest, ServerWebSocket s) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        ReflectionInfo reflectionInfo = this.jsonRpcToRuntimeClassPathJava.get(jsonRpcMethodName);
        Object target = Arc.container().select(reflectionInfo.bean, new Annotation[0]).get();
        if (reflectionInfo.isReturningMulti()) {
            this.routeToRuntimeSubscription(jsonRpcRequest, s, jsonRpcMethodName, reflectionInfo, target);
        } else {
            this.routeToRuntimeMethod(jsonRpcRequest, s, jsonRpcMethodName, reflectionInfo, target);
        }
    }

    private void routeToRuntimeSubscription(JsonRpcRequest jsonRpcRequest, ServerWebSocket s, String jsonRpcMethodName, ReflectionInfo reflectionInfo, Object target) {
        Multi multi;
        if (this.subscriptions.containsKey(jsonRpcRequest.getId())) {
            Cancellable cancellable = this.subscriptions.remove(jsonRpcRequest.getId());
            cancellable.cancel();
        }
        try {
            if (jsonRpcRequest.hasParams()) {
                Object[] args = this.getArgsAsObjects(reflectionInfo.params, jsonRpcRequest);
                multi = (Multi)reflectionInfo.method.invoke(target, args);
            } else {
                multi = (Multi)reflectionInfo.method.invoke(target, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.errorf((Throwable)e, "Unable to invoke method %s using JSON-RPC, request was: %s", (Object)jsonRpcMethodName, (Object)jsonRpcRequest);
            this.codec.writeErrorResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName, e);
            return;
        }
        Cancellable cancellable = multi.subscribe().with(item -> this.codec.writeResponse(s, jsonRpcRequest.getId(), item, MessageType.SubscriptionMessage), failure -> {
            this.codec.writeErrorResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName, (Throwable)failure);
            this.subscriptions.remove(jsonRpcRequest.getId());
        }, () -> this.subscriptions.remove(jsonRpcRequest.getId()));
        this.subscriptions.put(jsonRpcRequest.getId(), cancellable);
        this.codec.writeResponse(s, jsonRpcRequest.getId(), null, MessageType.Void);
    }

    private void routeToRuntimeMethod(JsonRpcRequest jsonRpcRequest, ServerWebSocket s, String jsonRpcMethodName, ReflectionInfo reflectionInfo, Object target) {
        Uni<?> uni;
        try {
            if (jsonRpcRequest.hasParams()) {
                Object[] args = this.getArgsAsObjects(reflectionInfo.params, jsonRpcRequest);
                uni = this.invoke(reflectionInfo, target, args);
            } else {
                uni = this.invoke(reflectionInfo, target, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.errorf((Throwable)e, "Unable to invoke method %s using JSON-RPC, request was: %s", (Object)jsonRpcMethodName, (Object)jsonRpcRequest);
            this.codec.writeErrorResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName, e);
            return;
        }
        uni.subscribe().with(item -> {
            if (item != null && JsonRpcMessage.class.isAssignableFrom(item.getClass())) {
                JsonRpcMessage jsonRpcMessage = (JsonRpcMessage)item;
                this.codec.writeResponse(s, jsonRpcRequest.getId(), jsonRpcMessage.getResponse(), jsonRpcMessage.getMessageType());
            } else {
                this.codec.writeResponse(s, jsonRpcRequest.getId(), item, MessageType.Response);
            }
        }, failure -> {
            Throwable patt0$temp;
            Throwable actualFailure;
            if (failure instanceof InvocationTargetException) {
                InvocationTargetException f = (InvocationTargetException)failure;
                actualFailure = f.getTargetException();
            } else if (failure.getCause() != null && (patt0$temp = failure.getCause()) instanceof InvocationTargetException) {
                InvocationTargetException f = (InvocationTargetException)patt0$temp;
                actualFailure = f.getTargetException();
            } else {
                actualFailure = failure;
            }
            this.codec.writeErrorResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName, actualFailure);
        });
    }

    private void routeToDeployment(JsonRpcRequest jsonRpcRequest, ServerWebSocket s) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        if (this.subscriptions.containsKey(jsonRpcRequest.getId())) {
            Cancellable cancellable = this.subscriptions.remove(jsonRpcRequest.getId());
            cancellable.cancel();
        }
        Object returnedObject = null;
        returnedObject = this.recordedValues.containsKey(jsonRpcMethodName) ? this.recordedValues.get(jsonRpcMethodName).getValue() : DevConsoleManager.invoke((String)jsonRpcMethodName, this.getArgsAsMap(jsonRpcRequest));
        if (returnedObject != null) {
            if (returnedObject instanceof Flow.Publisher) {
                Flow.Publisher publisher = (Flow.Publisher)returnedObject;
                Cancellable cancellable = Multi.createFrom().publisher(publisher).subscribe().with(item -> this.codec.writeResponse(s, jsonRpcRequest.getId(), item, MessageType.SubscriptionMessage), failure -> {
                    this.codec.writeErrorResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName, (Throwable)failure);
                    this.subscriptions.remove(jsonRpcRequest.getId());
                }, () -> this.subscriptions.remove(jsonRpcRequest.getId()));
                this.subscriptions.put(jsonRpcRequest.getId(), cancellable);
                this.codec.writeResponse(s, jsonRpcRequest.getId(), null, MessageType.Void);
            } else if (returnedObject instanceof CompletionStage) {
                CompletionStage future = (CompletionStage)returnedObject;
                future.thenAccept(r -> this.codec.writeResponse(s, jsonRpcRequest.getId(), r, MessageType.Response)).exceptionally(throwable -> {
                    this.codec.writeErrorResponse(s, jsonRpcRequest.getId(), jsonRpcMethodName, (Throwable)throwable);
                    return null;
                });
            } else {
                this.codec.writeResponse(s, jsonRpcRequest.getId(), returnedObject, MessageType.Response);
            }
        }
    }

    private Uni<?> invoke(ReflectionInfo info, Object target, Object[] args) {
        if (info.isReturningUni()) {
            try {
                Uni uni = (Uni)info.method.invoke(target, args);
                if (info.isExplicitlyBlocking()) {
                    return uni.runSubscriptionOn(Infrastructure.getDefaultExecutor());
                }
                return uni;
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        }
        Uni uni = Uni.createFrom().item(Unchecked.supplier(() -> info.method.invoke(target, args)));
        if (!info.isExplicitlyNonBlocking()) {
            return uni.runSubscriptionOn(Infrastructure.getDefaultExecutor());
        }
        return uni;
    }

    private Object[] getArgsAsObjects(Map<String, Class> params, JsonRpcRequest jsonRpcRequest) {
        ArrayList objects = new ArrayList();
        for (Map.Entry<String, Class> expectedParams : params.entrySet()) {
            String paramName = expectedParams.getKey();
            Class paramType = expectedParams.getValue();
            Object param = jsonRpcRequest.getParam(paramName, paramType);
            objects.add(param);
        }
        return objects.toArray(Object[]::new);
    }

    private Map<String, String> getArgsAsMap(JsonRpcRequest jsonRpcRequest) {
        if (jsonRpcRequest.hasParams()) {
            return jsonRpcRequest.getParams();
        }
        return Map.of();
    }
}

