/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ForEachLoop;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.IfThenElse;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.gizmo.WhileLoop;
import java.util.Objects;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public interface BytecodeCreator
extends AutoCloseable {
    public ResultHandle getThis();

    public ResultHandle invokeVirtualMethod(MethodDescriptor var1, ResultHandle var2, ResultHandle ... var3);

    default public ResultHandle invokeVirtualMethod(MethodInfo descriptor, ResultHandle object, ResultHandle ... args) {
        return this.invokeVirtualMethod(MethodDescriptor.of(descriptor), object, args);
    }

    public ResultHandle invokeInterfaceMethod(MethodDescriptor var1, ResultHandle var2, ResultHandle ... var3);

    default public ResultHandle invokeInterfaceMethod(MethodInfo descriptor, ResultHandle object, ResultHandle ... args) {
        return this.invokeInterfaceMethod(MethodDescriptor.of(descriptor), object, args);
    }

    public ResultHandle invokeStaticMethod(MethodDescriptor var1, ResultHandle ... var2);

    default public ResultHandle invokeStaticMethod(MethodInfo descriptor, ResultHandle ... args) {
        return this.invokeStaticMethod(MethodDescriptor.of(descriptor), args);
    }

    public ResultHandle invokeStaticInterfaceMethod(MethodDescriptor var1, ResultHandle ... var2);

    default public ResultHandle invokeStaticInterfaceMethod(MethodInfo descriptor, ResultHandle ... args) {
        return this.invokeStaticInterfaceMethod(MethodDescriptor.of(descriptor), args);
    }

    public ResultHandle invokeSpecialMethod(MethodDescriptor var1, ResultHandle var2, ResultHandle ... var3);

    default public ResultHandle invokeSpecialMethod(MethodInfo descriptor, ResultHandle object, ResultHandle ... args) {
        return this.invokeSpecialMethod(MethodDescriptor.of(descriptor), object, args);
    }

    public ResultHandle invokeSpecialInterfaceMethod(MethodDescriptor var1, ResultHandle var2, ResultHandle ... var3);

    default public ResultHandle invokeSpecialInterfaceMethod(MethodInfo descriptor, ResultHandle object, ResultHandle ... args) {
        return this.invokeSpecialInterfaceMethod(MethodDescriptor.of(descriptor), object, args);
    }

    public ResultHandle newInstance(MethodDescriptor var1, ResultHandle ... var2);

    default public ResultHandle newInstance(MethodInfo descriptor, ResultHandle ... args) {
        return this.newInstance(MethodDescriptor.of(descriptor), args);
    }

    public ResultHandle newArray(String var1, ResultHandle var2);

    default public ResultHandle newArray(String type, int length) {
        return this.newArray(type, this.load(length));
    }

    default public ResultHandle newArray(Class<?> type, ResultHandle length) {
        return this.newArray(type.getName(), length);
    }

    default public ResultHandle newArray(Class<?> type, int length) {
        return this.newArray(type.getName(), this.load(length));
    }

    public ResultHandle load(String var1);

    public ResultHandle load(byte var1);

    public ResultHandle load(short var1);

    public ResultHandle load(char var1);

    public ResultHandle load(int var1);

    public ResultHandle load(long var1);

    public ResultHandle load(float var1);

    public ResultHandle load(double var1);

    public ResultHandle load(boolean var1);

    default public ResultHandle load(Enum<?> val) {
        return this.readStaticField(FieldDescriptor.of(val.getDeclaringClass(), val.name(), val.getDeclaringClass()));
    }

    public ResultHandle loadClass(String var1);

    default public ResultHandle loadClass(Class<?> val) {
        return this.loadClass(val.getName());
    }

    default public ResultHandle loadClass(ClassInfo val) {
        return this.loadClass(val.name().toString());
    }

    public ResultHandle loadClassFromTCCL(String var1);

    default public ResultHandle loadClassFromTCCL(Class<?> val) {
        return this.loadClassFromTCCL(val.getName());
    }

    default public ResultHandle loadClassFromTCCL(ClassInfo val) {
        return this.loadClassFromTCCL(val.name().toString());
    }

    public ResultHandle loadNull();

    public void writeInstanceField(FieldDescriptor var1, ResultHandle var2, ResultHandle var3);

    default public void writeInstanceField(FieldInfo fieldDescriptor, ResultHandle instance, ResultHandle value) {
        this.writeInstanceField(FieldDescriptor.of(fieldDescriptor), instance, value);
    }

    public ResultHandle readInstanceField(FieldDescriptor var1, ResultHandle var2);

    default public ResultHandle readInstanceField(FieldInfo fieldDescriptor, ResultHandle instance) {
        return this.readInstanceField(FieldDescriptor.of(fieldDescriptor), instance);
    }

    public void writeStaticField(FieldDescriptor var1, ResultHandle var2);

    default public void writeStaticField(FieldInfo fieldDescriptor, ResultHandle value) {
        this.writeStaticField(FieldDescriptor.of(fieldDescriptor), value);
    }

    public ResultHandle readStaticField(FieldDescriptor var1);

    default public ResultHandle readStaticField(FieldInfo fieldDescriptor) {
        return this.readStaticField(FieldDescriptor.of(fieldDescriptor));
    }

    public ResultHandle arrayLength(ResultHandle var1);

    public ResultHandle readArrayValue(ResultHandle var1, ResultHandle var2);

    public void writeArrayValue(ResultHandle var1, ResultHandle var2, ResultHandle var3);

    default public ResultHandle readArrayValue(ResultHandle array, int index) {
        return this.readArrayValue(array, this.load(index));
    }

    default public void writeArrayValue(ResultHandle array, int index, ResultHandle value) {
        this.writeArrayValue(array, this.load(index), value);
    }

    public AssignableResultHandle createVariable(String var1);

    default public AssignableResultHandle createVariable(Class<?> type) {
        Objects.requireNonNull(type);
        return this.createVariable(DescriptorUtils.classToStringRepresentation(type));
    }

    public void assign(AssignableResultHandle var1, ResultHandle var2);

    public TryBlock tryBlock();

    public ResultHandle compareLong(ResultHandle var1, ResultHandle var2);

    public ResultHandle compareFloat(ResultHandle var1, ResultHandle var2, boolean var3);

    public ResultHandle compareDouble(ResultHandle var1, ResultHandle var2, boolean var3);

    public BranchResult ifNonZero(ResultHandle var1);

    public BranchResult ifZero(ResultHandle var1);

    public BranchResult ifTrue(ResultHandle var1);

    public BranchResult ifFalse(ResultHandle var1);

    public BranchResult ifNull(ResultHandle var1);

    public BranchResult ifNotNull(ResultHandle var1);

    public BranchResult ifGreaterThanZero(ResultHandle var1);

    public BranchResult ifGreaterEqualZero(ResultHandle var1);

    public BranchResult ifLessThanZero(ResultHandle var1);

    public BranchResult ifLessEqualZero(ResultHandle var1);

    public BranchResult ifIntegerEqual(ResultHandle var1, ResultHandle var2);

    public BranchResult ifIntegerGreaterThan(ResultHandle var1, ResultHandle var2);

    public BranchResult ifIntegerGreaterEqual(ResultHandle var1, ResultHandle var2);

    public BranchResult ifIntegerLessThan(ResultHandle var1, ResultHandle var2);

    public IfThenElse ifThenElse(ResultHandle var1);

    default public ResultHandle instanceOf(ResultHandle resultHandle, Class<?> testType) {
        return this.instanceOf(resultHandle, testType.getName());
    }

    public ResultHandle instanceOf(ResultHandle var1, String var2);

    public BranchResult ifIntegerLessEqual(ResultHandle var1, ResultHandle var2);

    public BranchResult ifReferencesEqual(ResultHandle var1, ResultHandle var2);

    public BranchResult ifReferencesNotEqual(ResultHandle var1, ResultHandle var2);

    public ResultHandle getMethodParam(int var1);

    public FunctionCreator createFunction(Class<?> var1);

    public void returnValue(ResultHandle var1);

    default public void returnVoid() {
        this.returnValue(null);
    }

    default public void returnNull() {
        this.returnValue(this.loadNull());
    }

    default public void returnBoolean(boolean value) {
        this.returnValue(this.load(value));
    }

    default public void returnInt(int value) {
        this.returnValue(this.load(value));
    }

    public void throwException(ResultHandle var1);

    public ResultHandle checkCast(ResultHandle var1, String var2);

    default public ResultHandle checkCast(ResultHandle resultHandle, Class<?> castTarget) {
        return this.checkCast(resultHandle, castTarget.getName());
    }

    public ResultHandle convertPrimitive(ResultHandle var1, Class<?> var2);

    default public <T extends Throwable> void throwException(Class<T> exceptionType, String message) {
        try {
            exceptionType.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Exception does not have appropriate constructor");
        }
        ResultHandle res = this.newInstance(MethodDescriptor.ofConstructor(exceptionType, String.class), this.load(message));
        this.throwException(res);
    }

    default public <T extends Throwable> void throwException(Class<T> exceptionType, String message, ResultHandle existing) {
        try {
            exceptionType.getDeclaredConstructor(String.class, Throwable.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Exception does not have appropriate constructor");
        }
        ResultHandle res = this.newInstance(MethodDescriptor.ofConstructor(exceptionType, String.class, Throwable.class), this.load(message), existing);
        this.throwException(res);
    }

    default public ResultHandle marshalAsArray(Class<?> arrayClass, ResultHandle ... params) {
        ResultHandle array = this.newArray(arrayClass, this.load(params.length));
        for (int i = 0; i < params.length; ++i) {
            this.writeArrayValue(array, this.load(i), params[i]);
        }
        return array;
    }

    public boolean isScopedWithin(BytecodeCreator var1);

    public void continueScope(BytecodeCreator var1);

    default public void continueScope() {
        this.continueScope(this);
    }

    public void breakScope(BytecodeCreator var1);

    default public void breakScope() {
        this.breakScope(this);
    }

    public BytecodeCreator createScope();

    public WhileLoop whileLoop(Function<BytecodeCreator, BranchResult> var1);

    public ForEachLoop forEach(ResultHandle var1);

    public ResultHandle add(ResultHandle var1, ResultHandle var2);

    public ResultHandle subtract(ResultHandle var1, ResultHandle var2);

    public ResultHandle multiply(ResultHandle var1, ResultHandle var2);

    public ResultHandle divide(ResultHandle var1, ResultHandle var2);

    public ResultHandle remainder(ResultHandle var1, ResultHandle var2);

    public ResultHandle bitwiseAnd(ResultHandle var1, ResultHandle var2);

    public ResultHandle bitwiseOr(ResultHandle var1, ResultHandle var2);

    public ResultHandle bitwiseXor(ResultHandle var1, ResultHandle var2);

    default public ResultHandle increment(ResultHandle toIncrement) {
        return this.add(toIncrement, this.load(1));
    }

    public Switch.StringSwitch stringSwitch(ResultHandle var1);

    public <E extends Enum<E>> Switch.EnumSwitch<E> enumSwitch(ResultHandle var1, Class<E> var2);

    @Override
    default public void close() {
    }
}

