/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.internal;

import java.util.function.BiConsumer;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractInitializer<Data extends InitializerData>
implements Initializer<Data> {
    protected final int initializerId;

    protected AbstractInitializer(AssemblerCreationState creationState) {
        this.initializerId = creationState.acquireInitializerId();
    }

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        InitializerData data = this.createInitializerData(rowProcessingState);
        rowProcessingState.setInitializerData(this.initializerId, data);
        this.forEachSubInitializer(Initializer::startLoading, data);
    }

    protected abstract InitializerData createInitializerData(RowProcessingState var1);

    @Override
    public void resolveKey(Data data) {
        ((InitializerData)data).setState(Initializer.State.KEY_RESOLVED);
        this.forEachSubInitializer(Initializer::resolveKey, (InitializerData)data);
    }

    @Override
    public void initializeInstance(Data data) {
    }

    @Override
    public Data getData(RowProcessingState rowProcessingState) {
        return (Data)rowProcessingState.getInitializerData(this.initializerId);
    }

    @Override
    public void finishUpRow(Data data) {
        ((InitializerData)data).setState(Initializer.State.UNINITIALIZED);
    }

    protected abstract void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> var1, InitializerData var2);
}

