/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class AbstractDependencyBuilder<B extends AbstractDependencyBuilder<B, T>, T> {
    String groupId;
    String artifactId;
    String classifier = "";
    String type = "jar";
    String version;
    String scope = "compile";
    int flags;
    Collection<ArtifactKey> exclusions = List.of();

    AbstractDependencyBuilder() {
    }

    public B setCoords(ArtifactCoords coords) {
        this.groupId = coords.getGroupId();
        this.artifactId = coords.getArtifactId();
        this.classifier = coords.getClassifier();
        this.type = coords.getType();
        this.version = coords.getVersion();
        return (B)this;
    }

    public B setGroupId(String groupId) {
        this.groupId = groupId;
        return (B)this;
    }

    public B setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (B)this;
    }

    public B setClassifier(String classifier) {
        this.classifier = classifier;
        return (B)this;
    }

    public B setType(String type) {
        this.type = type;
        return (B)this;
    }

    public B setVersion(String version) {
        this.version = version;
        return (B)this;
    }

    public B setScope(String scope) {
        this.scope = scope;
        return (B)this;
    }

    public B setOptional(boolean optional) {
        if (optional) {
            this.setFlags(1);
        } else {
            this.clearFlag(1);
        }
        return (B)this;
    }

    public B setDeploymentCp() {
        this.setFlags(8);
        return (B)this;
    }

    public B setRuntimeCp() {
        this.setFlags(4);
        return (B)this;
    }

    public B setWorkspaceModule() {
        this.setFlags(32);
        return (B)this;
    }

    public B setDirect(boolean direct) {
        if (direct) {
            this.setFlags(2);
        }
        return (B)this;
    }

    public B setReloadable() {
        this.setFlags(64);
        return (B)this;
    }

    public B setRuntimeExtensionArtifact() {
        this.setFlags(16);
        return (B)this;
    }

    public B setFlags(int flag) {
        this.flags |= flag;
        return (B)this;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & flag) > 0;
    }

    public void clearFlag(int flag) {
        if ((this.flags & flag) > 0) {
            this.flags ^= flag;
        }
    }

    public B addExclusion(String groupId, String artifactId) {
        return this.addExclusion(ArtifactKey.ga(groupId, artifactId));
    }

    public B addExclusion(ArtifactKey key) {
        if (this.exclusions.isEmpty()) {
            this.exclusions = new ArrayList<ArtifactKey>();
        }
        this.exclusions.add(key);
        return (B)this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public ArtifactKey getKey() {
        return ArtifactKey.of(this.groupId, this.artifactId, this.classifier, this.type);
    }

    public String toGACTVString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getClassifier() + ":" + this.getType() + ":" + this.getVersion();
    }

    public abstract T build();
}

