/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import java.util.Map;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.util.JsonSerialization;

public class OIDCIdentityProviderFactory
extends AbstractIdentityProviderFactory<OIDCIdentityProvider> {
    public static final String PROVIDER_ID = "oidc";

    public String getName() {
        return "OpenID Connect v1.0";
    }

    public OIDCIdentityProvider create(KeycloakSession session, IdentityProviderModel model) {
        return new OIDCIdentityProvider(session, new OIDCIdentityProviderConfig(model));
    }

    public OIDCIdentityProviderConfig createConfig() {
        return new OIDCIdentityProviderConfig();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Map<String, String> parseConfig(KeycloakSession session, String config) {
        return OIDCIdentityProviderFactory.parseOIDCConfig(session, config);
    }

    protected static Map<String, String> parseOIDCConfig(KeycloakSession session, String configString) {
        OIDCConfigurationRepresentation rep;
        try {
            rep = (OIDCConfigurationRepresentation)JsonSerialization.readValue((String)configString, OIDCConfigurationRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load openid connect metadata", e);
        }
        OIDCIdentityProviderConfig config = new OIDCIdentityProviderConfig();
        config.setIssuer(rep.getIssuer());
        config.setLogoutUrl(rep.getLogoutEndpoint());
        config.setAuthorizationUrl(rep.getAuthorizationEndpoint());
        config.setTokenUrl(rep.getTokenEndpoint());
        config.setUserInfoUrl(rep.getUserinfoEndpoint());
        if (rep.getJwksUri() != null) {
            config.setValidateSignature(true);
            config.setUseJwksUrl(true);
            config.setJwksUrl(rep.getJwksUri());
        }
        return config.getConfig();
    }
}

