/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.resteasy;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.keycloak.common.Version;

public final class KeycloakTracingCustomizer
implements HandlerChainCustomizer {
    public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod resourceMethod) {
        ArrayList<ServerRestHandler> handlers = new ArrayList<ServerRestHandler>();
        switch (phase) {
            case BEFORE_METHOD_INVOKE: {
                handlers.add(new StartHandler(resourceClass.getClassName(), resourceMethod.getName()));
                break;
            }
            case AFTER_METHOD_INVOKE: {
                handlers.add(new EndHandler());
            }
        }
        return handlers;
    }

    private static class StartHandler
    implements ServerRestHandler {
        private final String className;
        private final String methodName;
        private final String spanName;

        public StartHandler(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
            this.spanName = StringUtils.substringAfterLast((String)className, (String)".") + "." + methodName;
        }

        public void handle(ResteasyReactiveRequestContext requestContext) {
            if (requestContext.getProperty("span") != null) {
                return;
            }
            OpenTelemetry openTelemetry = (OpenTelemetry)CDI.current().select(OpenTelemetry.class, new Annotation[0]).get();
            Tracer myTracer = openTelemetry.getTracer(this.getClass().getName(), Version.VERSION);
            SpanBuilder spanBuilder = myTracer.spanBuilder(this.spanName);
            spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)Span.current()));
            spanBuilder.setAttribute("code.function", this.methodName);
            spanBuilder.setAttribute("code.namespace", this.className);
            Span span = spanBuilder.startSpan();
            requestContext.setProperty("span", (Object)span);
            requestContext.setProperty("scope", (Object)span.makeCurrent());
        }
    }

    private static class EndHandler
    implements ServerRestHandler {
        private EndHandler() {
        }

        public void handle(ResteasyReactiveRequestContext requestContext) {
            Span span;
            Scope scope = (Scope)requestContext.getProperty("scope");
            if (scope != null) {
                scope.close();
                requestContext.removeProperty("scope");
            }
            if ((span = (Span)requestContext.getProperty("span")) != null) {
                span.end();
                requestContext.removeProperty("span");
            }
        }
    }
}

