/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.aggregated;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.policy.provider.PolicyProvider;

public class AggregatePolicyProvider
implements PolicyProvider {
    private static final Logger logger = Logger.getLogger(AggregatePolicyProvider.class);

    public void evaluate(final Evaluation evaluation) {
        logger.debugf("Aggregate policy %s evaluating using parent class", (Object)evaluation.getPolicy().getName());
        DecisionResultCollector decision = new DecisionResultCollector(){

            protected void onComplete(Result result) {
                if (this.isGranted((Result.PolicyResult)result.getResults().iterator().next())) {
                    evaluation.grant();
                } else {
                    evaluation.deny();
                }
            }
        };
        AuthorizationProvider authorization = evaluation.getAuthorizationProvider();
        Policy policy = evaluation.getPolicy();
        DefaultEvaluation defaultEvaluation = (DefaultEvaluation)DefaultEvaluation.class.cast(evaluation);
        Map decisionCache = defaultEvaluation.getDecisionCache();
        ResourcePermission permission = evaluation.getPermission();
        for (Policy associatedPolicy : policy.getAssociatedPolicies()) {
            Map decisions = decisionCache.computeIfAbsent(associatedPolicy, p -> new HashMap());
            Decision.Effect effect = (Decision.Effect)decisions.get(permission);
            DefaultEvaluation eval = new DefaultEvaluation(evaluation.getPermission(), evaluation.getContext(), policy, associatedPolicy, (Decision)decision, authorization, decisionCache);
            if (effect == null) {
                PolicyProvider policyProvider = authorization.getProvider(associatedPolicy.getType());
                policyProvider.evaluate((Evaluation)eval);
                eval.denyIfNoEffect();
                decisions.put(permission, eval.getEffect());
                continue;
            }
            eval.setEffect(effect);
        }
        decision.onComplete(permission);
    }

    public void close() {
    }
}

