/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public abstract class AbstractColumnReferenceQualifier
implements ColumnReferenceQualifier {
    protected abstract TableReference getPrimaryTableReference();

    protected abstract List<TableReferenceJoin> getTableReferenceJoins();

    protected abstract SessionFactoryImplementor getSessionFactory();

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        TableReference primaryTableReference = this.getPrimaryTableReference().getTableReference(navigablePath, tableExpression, resolve);
        if (primaryTableReference != null) {
            return primaryTableReference;
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            TableReference tableReference = tableJoin.getJoinedTableReference().getTableReference(navigablePath, tableExpression, resolve);
            if (tableReference == null) continue;
            return tableReference;
        }
        return null;
    }
}

